/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.seasar.dbflute.util.DfTypeUtil;

public class HandyDate
implements Serializable {
    private static final long serialVersionUID = -5181512291555841795L;
    protected final Calendar _cal = Calendar.getInstance();
    protected int _yearBeginMonth = this._cal.getActualMinimum(2) + 1;
    protected int _monthBeginDay = this._cal.getActualMinimum(5);
    protected int _dayBeginHour = this._cal.getActualMinimum(11);
    protected int _weekBeginDay = 1;

    public HandyDate(Date date) {
        this.assertConstructorArgumentNotNull("date", date);
        this._cal.setTime(date);
    }

    public HandyDate(String exp) {
        this.assertConstructorArgumentNotNull("exp", exp);
        this._cal.setTime(DfTypeUtil.toDate(exp));
    }

    public HandyDate(String exp, String pattern) {
        this.assertConstructorArgumentNotNull("exp", exp);
        this.assertConstructorArgumentNotNull("pattern", pattern);
        this._cal.setTime(DfTypeUtil.toDate(exp, pattern));
    }

    protected void assertConstructorArgumentNotNull(String name, Object value) {
        if (value == null) {
            String msg = "The argument '" + name + "' should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    public HandyDate addYear(int year) {
        DfTypeUtil.addCalendarYear(this._cal, year);
        return this;
    }

    public HandyDate addMonth(int month) {
        DfTypeUtil.addCalendarMonth(this._cal, month);
        return this;
    }

    public HandyDate addDay(int day) {
        DfTypeUtil.addCalendarDay(this._cal, day);
        return this;
    }

    public HandyDate addHour(int hour) {
        DfTypeUtil.addCalendarHour(this._cal, hour);
        return this;
    }

    public HandyDate addMinute(int minute) {
        DfTypeUtil.addCalendarMinute(this._cal, minute);
        return this;
    }

    public HandyDate addSecond(int second) {
        DfTypeUtil.addCalendarSecond(this._cal, second);
        return this;
    }

    public HandyDate addMillisecond(int millisecond) {
        DfTypeUtil.addCalendarMillisecond(this._cal, millisecond);
        return this;
    }

    public HandyDate addWeek(int week) {
        DfTypeUtil.addCalendarWeek(this._cal, week);
        return this;
    }

    public HandyDate moveToYear(int year) {
        DfTypeUtil.moveToCalendarYear(this._cal, year);
        return this;
    }

    public HandyDate moveToYearJust() {
        DfTypeUtil.moveToCalendarYearJust(this._cal, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToYearJustAdded(int year) {
        DfTypeUtil.moveToCalendarYearJustAdded(this._cal, year);
        return this;
    }

    public HandyDate moveToYearJustFor(int year) {
        DfTypeUtil.moveToCalendarYearJustFor(this._cal, year);
        return this;
    }

    public HandyDate moveToYearTerminal() {
        DfTypeUtil.moveToCalendarYearTerminal(this._cal, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToYearTerminalAdded(int year) {
        DfTypeUtil.moveToCalendarYearTerminalAdded(this._cal, year);
        return this;
    }

    public HandyDate moveToYearTerminalFor(int year) {
        DfTypeUtil.moveToCalendarYearTerminalFor(this._cal, year);
        return this;
    }

    public HandyDate moveToMonth(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonth(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthJust() {
        DfTypeUtil.moveToCalendarMonthJust(this._cal, this._monthBeginDay);
        this.moveToDayJust();
        return this;
    }

    public HandyDate moveToMonthJustAdded(int month) {
        DfTypeUtil.moveToCalendarMonthJustAdded(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthJustFor(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonthJustFor(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthTerminal() {
        DfTypeUtil.moveToCalendarMonthTerminal(this._cal, this._monthBeginDay);
        this.moveToDayTerminal();
        return this;
    }

    public HandyDate moveToMonthTerminalAdded(int month) {
        DfTypeUtil.moveToCalendarMonthTerminalAdded(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthTerminalFor(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonthTerminalFor(this._cal, month);
        return this;
    }

    public HandyDate moveToDay(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDay(this._cal, day);
        return this;
    }

    public HandyDate moveToDayJust() {
        DfTypeUtil.moveToCalendarDayJust(this._cal, this._dayBeginHour);
        return this;
    }

    public HandyDate moveToDayJustAdded(int day) {
        DfTypeUtil.moveToCalendarDayJustAdded(this._cal, day);
        return this;
    }

    public HandyDate moveToDayJustFor(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDayJustFor(this._cal, day);
        return this;
    }

    public HandyDate moveToDayTerminal() {
        DfTypeUtil.moveToCalendarDayTerminal(this._cal, this._dayBeginHour);
        return this;
    }

    public HandyDate moveToDayTerminalAdded(int day) {
        DfTypeUtil.moveToCalendarDayTerminalAdded(this._cal, day);
        return this;
    }

    public HandyDate moveToDayTerminalFor(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDayTerminalFor(this._cal, day);
        return this;
    }

    public HandyDate moveToHour(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHour(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourJust() {
        DfTypeUtil.moveToCalendarHourJust(this._cal);
        return this;
    }

    public HandyDate moveToHourJustAdded(int hour) {
        DfTypeUtil.moveToCalendarHourJustAdded(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourJustFor(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHourJustFor(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourTerminal() {
        DfTypeUtil.moveToCalendarHourTerminal(this._cal);
        return this;
    }

    public HandyDate moveToHourTerminalAdded(int hour) {
        DfTypeUtil.moveToCalendarHourTerminalAdded(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourTerminalFor(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHourTerminalFor(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourJustNoon() {
        DfTypeUtil.moveToCalendarHourJustNoon(this._cal);
        return this;
    }

    public HandyDate moveToMinute(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinute(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteJust() {
        DfTypeUtil.moveToCalendarMinuteJust(this._cal);
        return this;
    }

    public HandyDate moveToMinuteJustAdded(int minute) {
        DfTypeUtil.moveToCalendarMinuteJustAdded(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteJustFor(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinuteJustFor(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteTerminal() {
        DfTypeUtil.moveToCalendarMinuteTerminal(this._cal);
        return this;
    }

    public HandyDate moveToMinuteTerminal\u00c5dded(int minute) {
        DfTypeUtil.moveToCalendarMinuteTerminalAdded(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteTerminalFor(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinuteTerminalFor(this._cal, minute);
        return this;
    }

    public HandyDate moveToSecond(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecond(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondJust() {
        DfTypeUtil.moveToCalendarSecondJust(this._cal);
        return this;
    }

    public HandyDate moveToSecondJustFor(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecondJustFor(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondJustAdded(int second) {
        DfTypeUtil.moveToCalendarSecondJustAdded(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondTerminal() {
        DfTypeUtil.moveToCalendarSecondTerminal(this._cal);
        return this;
    }

    public HandyDate moveToSecondTerminalAdded(int second) {
        DfTypeUtil.moveToCalendarSecondTerminalAdded(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondTerminalFor(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecondTerminalFor(this._cal, second);
        return this;
    }

    public HandyDate moveToMillisecond(int millisecond) {
        this.assertValidMillisecond(millisecond);
        DfTypeUtil.moveToCalendarMillisecond(this._cal, millisecond);
        return this;
    }

    public HandyDate moveToWeekOfMonth(int weekOfMonth) {
        DfTypeUtil.moveToCalendarWeekOfMonth(this._cal, weekOfMonth);
        return this;
    }

    public HandyDate moveToWeekOfYear(int weekOfYear) {
        DfTypeUtil.moveToCalendarWeekOfYear(this._cal, weekOfYear);
        return this;
    }

    public HandyDate moveToWeekJust() {
        DfTypeUtil.moveToCalendarWeekJust(this._cal, this._weekBeginDay);
        return this;
    }

    public HandyDate moveToWeekTerminal() {
        DfTypeUtil.moveToCalendarWeekTerminal(this._cal, this._weekBeginDay);
        return this;
    }

    public HandyDate moveToQuarterOfYearJust() {
        DfTypeUtil.moveToCalendarQuarterOfYearJust(this._cal, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearJustAdded(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustAdded(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearJustFor(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustFor(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminal() {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminal(this._cal, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminalAdded(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalAdded(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminalFor(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalFor(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate clearTimeParts() {
        DfTypeUtil.clearCalendarTimeParts(this._cal);
        return this;
    }

    public HandyDate clearMinuteWithRear() {
        DfTypeUtil.clearCalendarMinuteWithRear(this._cal);
        return this;
    }

    public HandyDate clearSecondWithRear() {
        DfTypeUtil.clearCalendarSecondWithRear(this._cal);
        return this;
    }

    public HandyDate clearMillisecond() {
        DfTypeUtil.clearCalendarMillisecond(this._cal);
        return this;
    }

    public boolean isMatch(Date date) {
        this.assertArgumentNotNull("date", date);
        return this._cal.getTimeInMillis() == date.getTime();
    }

    public boolean isGreaterThan(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterThanAll(date);
    }

    public boolean isGreaterThanAll(Date ... dates) {
        return this.doCompareAll(this.createGreaterThanCompareCallback(), dates);
    }

    public boolean isGreaterThanAny(Date ... dates) {
        return this.doCompareAny(this.createGreaterThanCompareCallback(), dates);
    }

    protected CompareCallback createGreaterThanCompareCallback() {
        return new CompareCallback(){

            public boolean isTarget(Date current, Date date) {
                return current.after(date);
            }
        };
    }

    public boolean isGreaterEqual(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterEqualAll(date);
    }

    public boolean isGreaterEqualAll(Date ... dates) {
        return this.doCompareAll(this.createGreaterEqualCompareCallback(), dates);
    }

    public boolean isGreaterEqualAny(Date ... dates) {
        return this.doCompareAny(this.createGreaterEqualCompareCallback(), dates);
    }

    protected CompareCallback createGreaterEqualCompareCallback() {
        return new CompareCallback(){

            public boolean isTarget(Date current, Date date) {
                return current.after(date) || current.equals(date);
            }
        };
    }

    public boolean isLessThan(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessThanAll(date);
    }

    public boolean isLessThanAll(Date ... dates) {
        return this.doCompareAll(this.createLessThanCompareCallback(), dates);
    }

    public boolean isLessThanAny(Date ... dates) {
        return this.doCompareAny(this.createLessThanCompareCallback(), dates);
    }

    protected CompareCallback createLessThanCompareCallback() {
        return new CompareCallback(){

            public boolean isTarget(Date current, Date date) {
                return current.before(date);
            }
        };
    }

    public boolean isLessEqual(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessEqualAll(date);
    }

    public boolean isLessEqualAll(Date ... dates) {
        return this.doCompareAll(this.createLessEqualCompareCallback(), dates);
    }

    public boolean isLessEqualAny(Date ... dates) {
        return this.doCompareAny(this.createLessEqualCompareCallback(), dates);
    }

    protected CompareCallback createLessEqualCompareCallback() {
        return new CompareCallback(){

            public boolean isTarget(Date current, Date date) {
                return current.before(date) || current.equals(date);
            }
        };
    }

    protected boolean doCompareAll(CompareCallback callback, Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Date current = this.getDate();
        for (Date date : dates) {
            if (callback.isTarget(current, date)) continue;
            return false;
        }
        return true;
    }

    protected boolean doCompareAny(CompareCallback callback, Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Date current = this.getDate();
        for (Date date : dates) {
            if (!callback.isTarget(current, date)) continue;
            return true;
        }
        return false;
    }

    protected void assertCompareDateArrayValid(Date[] dates) {
        if (dates == null || dates.length == 0) {
            String msg = "The argument 'dates' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean isYear(int year) {
        return this.getYear() == year;
    }

    public boolean isYear_AnnoDomini() {
        return this.getYear() > 0;
    }

    public boolean isYear_BeforeChrist() {
        return this.getYear() < 0;
    }

    public boolean isMonth(int month) {
        return this.getMonth() == month;
    }

    public boolean isMonth01_January() {
        return this.isMonth(1);
    }

    public boolean isMonth02_February() {
        return this.isMonth(2);
    }

    public boolean isMonth03_March() {
        return this.isMonth(3);
    }

    public boolean isMonth04_April() {
        return this.isMonth(4);
    }

    public boolean isMonth05_May() {
        return this.isMonth(5);
    }

    public boolean isMonth06_June() {
        return this.isMonth(6);
    }

    public boolean isMonth07_July() {
        return this.isMonth(7);
    }

    public boolean isMonth08_August() {
        return this.isMonth(8);
    }

    public boolean isMonth09_September() {
        return this.isMonth(9);
    }

    public boolean isMonth10_October() {
        return this.isMonth(10);
    }

    public boolean isMonth11_November() {
        return this.isMonth(11);
    }

    public boolean isMonth12_December() {
        return this.isMonth(12);
    }

    public boolean isDay(int day) {
        return this.getDay() == day;
    }

    public boolean isDay_MonthFirstDay() {
        return this.isDay(this._cal.getActualMinimum(5));
    }

    public boolean isDay_MonthLastDay() {
        return this.isDay(this._cal.getActualMaximum(5));
    }

    public HandyDate beginYear_Month(Date yearBeginMonth) {
        this.assertArgumentNotNull("yearBeginMonth", yearBeginMonth);
        Calendar cal = Calendar.getInstance();
        cal.setTime(yearBeginMonth);
        this._yearBeginMonth = cal.get(2) + 1;
        return this;
    }

    public HandyDate beginYear_Month(int yearBeginMonth) {
        this.assertNotMinusNotOver("yearBeginMonth", yearBeginMonth, 12);
        this._yearBeginMonth = yearBeginMonth;
        return this;
    }

    public HandyDate beginYear_Month01_January() {
        this._yearBeginMonth = 1;
        return this;
    }

    public HandyDate beginYear_Month02_February() {
        this._yearBeginMonth = 2;
        return this;
    }

    public HandyDate beginYear_Month03_March() {
        this._yearBeginMonth = 3;
        return this;
    }

    public HandyDate beginYear_Month04_April() {
        this._yearBeginMonth = 4;
        return this;
    }

    public HandyDate beginYear_Month05_May() {
        this._yearBeginMonth = 5;
        return this;
    }

    public HandyDate beginYear_Month06_June() {
        this._yearBeginMonth = 6;
        return this;
    }

    public HandyDate beginYear_Month07_July() {
        this._yearBeginMonth = 7;
        return this;
    }

    public HandyDate beginYear_Month08_August() {
        this._yearBeginMonth = 8;
        return this;
    }

    public HandyDate beginYear_Month09_September() {
        this._yearBeginMonth = 9;
        return this;
    }

    public HandyDate beginYear_Month10_October() {
        this._yearBeginMonth = 10;
        return this;
    }

    public HandyDate beginYear_Month11_November() {
        this._yearBeginMonth = 11;
        return this;
    }

    public HandyDate beginYear_Month12_December() {
        this._yearBeginMonth = 12;
        return this;
    }

    public HandyDate beginYear_PreviousMonth(int yearBeginMonth) {
        this.assertNotMinusNotOver("yearBeginMonth", yearBeginMonth, 12);
        this._yearBeginMonth = -yearBeginMonth;
        return this;
    }

    public HandyDate beginMonth_Day(Date monthBeginDay) {
        this.assertArgumentNotNull("monthBeginDay", monthBeginDay);
        Calendar cal = Calendar.getInstance();
        cal.setTime(monthBeginDay);
        this._monthBeginDay = cal.get(5);
        return this;
    }

    public HandyDate beginMonth_Day(int monthBeginDay) {
        this.assertNotMinusNotOver("monthBeginDay", monthBeginDay, 31);
        this._monthBeginDay = monthBeginDay;
        return this;
    }

    public HandyDate beginMonth_PreviousDay(int monthBeginDay) {
        this.assertNotMinusNotOver("monthBeginDay", monthBeginDay, 31);
        this._monthBeginDay = -monthBeginDay;
        return this;
    }

    public HandyDate beginDay_Hour(Date dayBeginHour) {
        this.assertArgumentNotNull("dayBeginHour", dayBeginHour);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dayBeginHour);
        this._dayBeginHour = cal.get(11);
        return this;
    }

    public HandyDate beginDay_Hour(int dayBeginHour) {
        this.assertNotMinusNotOver("dayBeginHour", dayBeginHour, 23);
        this._dayBeginHour = dayBeginHour;
        return this;
    }

    public HandyDate beginDay_PreviousHour(int dayBeginHour) {
        this.assertNotMinusNotOver("dayBeginHour", dayBeginHour, 23);
        this._dayBeginHour = -dayBeginHour;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek(Date weekBeginDayOfWeek) {
        this.assertArgumentNotNull("weekBeginDayOfWeek", weekBeginDayOfWeek);
        Calendar cal = Calendar.getInstance();
        cal.setTime(weekBeginDayOfWeek);
        this._weekBeginDay = cal.get(7);
        return this;
    }

    public HandyDate beginWeek_DayOfWeek1st_Sunday() {
        this._weekBeginDay = 1;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek2nd_Monday() {
        this._weekBeginDay = 2;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek3rd_Tuesday() {
        this._weekBeginDay = 3;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek4th_Wednesday() {
        this._weekBeginDay = 4;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek5th_Thursday() {
        this._weekBeginDay = 5;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek6th_Friday() {
        this._weekBeginDay = 6;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek7th_Saturday() {
        this._weekBeginDay = 7;
        return this;
    }

    public Date getDate() {
        return new Date(this._cal.getTimeInMillis());
    }

    public Timestamp getTimestamp() {
        return new Timestamp(this._cal.getTimeInMillis());
    }

    protected int getYear() {
        int year = this._cal.get(1);
        int era = this._cal.get(0);
        return era == 1 ? year : -year;
    }

    protected int getMonth() {
        return this._cal.get(2) + 1;
    }

    protected int getDay() {
        return this._cal.get(5);
    }

    protected int getFirstDayOfMonth() {
        return this._cal.getActualMinimum(5);
    }

    protected int getLastDayOfMonth() {
        return this._cal.getActualMaximum(5);
    }

    protected void assertArgumentNotNull(String name, Object value) {
        if (value == null) {
            String msg = "The argument '" + name + "' should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertNotMinusNotOver(String name, int value, int max) {
        if (value < 0) {
            String msg = "The argument '" + name + "' should not be minus: value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value > max) {
            String msg = "The argument '" + name + "' should not be over: value=" + value + " max=" + max;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidMonth(int month) {
        if (month < 1 || month > 12) {
            String msg = "The argument 'month' should be 1 to 12: " + month;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidDay(int day) {
        int firstDayOfMonth = this.getFirstDayOfMonth();
        int lastDayOfMonth = this.getLastDayOfMonth();
        if (day < firstDayOfMonth || day > lastDayOfMonth) {
            String msg = "The argument 'day' should be " + firstDayOfMonth + " to " + lastDayOfMonth + ": " + day;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidHour(int hour) {
    }

    protected void assertValidMinute(int minute) {
        if (minute < 0 || minute > 59) {
            String msg = "The argument 'minute' should be 0 to 59: " + minute;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidSecond(int second) {
        if (second < 0 || second > 59) {
            String msg = "The argument 'second' should be 0 to 59: " + second;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidMillisecond(int millisecond) {
        if (millisecond < 0 || millisecond > 999) {
            String msg = "The argument 'millisecond' should be 0 to 999: " + millisecond;
            throw new IllegalArgumentException(msg);
        }
    }

    public String toDisp(String pattern) {
        return DfTypeUtil.toString(this._cal.getTime(), pattern);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HandyDate) {
            HandyDate date = (HandyDate)obj;
            String pattern = this.getBasicPattern();
            return date.toDisp(pattern).equals(this.toDisp(pattern));
        }
        return false;
    }

    public int hashCode() {
        String pattern = this.getBasicPattern();
        return pattern.hashCode();
    }

    public String toString() {
        return DfTypeUtil.toString(this._cal.getTime(), this.getBasicPattern());
    }

    protected String getBasicPattern() {
        if (this.isYear_BeforeChrist()) {
            return "'BC'yyyy/MM/dd HH:mm:ss.SSS";
        }
        return "yyyy/MM/dd HH:mm:ss.SSS";
    }

    public HandyDate deepCopy() {
        HandyDate cloned = this.newCopyInstance();
        cloned._yearBeginMonth = this._yearBeginMonth;
        cloned._monthBeginDay = this._monthBeginDay;
        cloned._dayBeginHour = this._dayBeginHour;
        cloned._weekBeginDay = this._weekBeginDay;
        return cloned;
    }

    protected HandyDate newCopyInstance() {
        return new HandyDate(this.getDate());
    }

    protected static interface CompareCallback {
        public boolean isTarget(Date var1, Date var2);
    }
}

