/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.ckey;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.ckey.ConditionKeyEqual;
import org.seasar.dbflute.cbean.ckey.ConditionKeyGreaterEqual;
import org.seasar.dbflute.cbean.ckey.ConditionKeyGreaterEqualOrIsNull;
import org.seasar.dbflute.cbean.ckey.ConditionKeyGreaterThan;
import org.seasar.dbflute.cbean.ckey.ConditionKeyGreaterThanOrIsNull;
import org.seasar.dbflute.cbean.ckey.ConditionKeyInScope;
import org.seasar.dbflute.cbean.ckey.ConditionKeyIsNotNull;
import org.seasar.dbflute.cbean.ckey.ConditionKeyIsNull;
import org.seasar.dbflute.cbean.ckey.ConditionKeyIsNullOrEmpty;
import org.seasar.dbflute.cbean.ckey.ConditionKeyLessEqual;
import org.seasar.dbflute.cbean.ckey.ConditionKeyLessEqualOrIsNull;
import org.seasar.dbflute.cbean.ckey.ConditionKeyLessThan;
import org.seasar.dbflute.cbean.ckey.ConditionKeyLessThanOrIsNull;
import org.seasar.dbflute.cbean.ckey.ConditionKeyLikeSearch;
import org.seasar.dbflute.cbean.ckey.ConditionKeyNotEqualStandard;
import org.seasar.dbflute.cbean.ckey.ConditionKeyNotEqualTradition;
import org.seasar.dbflute.cbean.ckey.ConditionKeyNotInScope;
import org.seasar.dbflute.cbean.ckey.ConditionKeyNotLikeSearch;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.cbean.sqlclause.query.StringQueryClause;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConditionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log _log = LogFactory.getLog(ConditionKey.class);
    public static final ConditionKey CK_EQUAL = new ConditionKeyEqual();
    public static final ConditionKey CK_NOT_EQUAL_STANDARD = new ConditionKeyNotEqualStandard();
    public static final ConditionKey CK_NOT_EQUAL_TRADITION = new ConditionKeyNotEqualTradition();
    public static final ConditionKey CK_GREATER_THAN = new ConditionKeyGreaterThan();
    public static final ConditionKey CK_GREATER_THAN_OR_IS_NULL = new ConditionKeyGreaterThanOrIsNull();
    public static final ConditionKey CK_LESS_THAN = new ConditionKeyLessThan();
    public static final ConditionKey CK_LESS_THAN_OR_IS_NULL = new ConditionKeyLessThanOrIsNull();
    public static final ConditionKey CK_GREATER_EQUAL = new ConditionKeyGreaterEqual();
    public static final ConditionKey CK_GREATER_EQUAL_OR_IS_NULL = new ConditionKeyGreaterEqualOrIsNull();
    public static final ConditionKey CK_LESS_EQUAL = new ConditionKeyLessEqual();
    public static final ConditionKey CK_LESS_EQUAL_OR_IS_NULL = new ConditionKeyLessEqualOrIsNull();
    public static final ConditionKey CK_IN_SCOPE = new ConditionKeyInScope();
    public static final ConditionKey CK_NOT_IN_SCOPE = new ConditionKeyNotInScope();
    public static final ConditionKey CK_LIKE_SEARCH = new ConditionKeyLikeSearch();
    public static final ConditionKey CK_NOT_LIKE_SEARCH = new ConditionKeyNotLikeSearch();
    public static final ConditionKey CK_IS_NULL = new ConditionKeyIsNull();
    public static final ConditionKey CK_IS_NULL_OR_EMPTY = new ConditionKeyIsNullOrEmpty();
    public static final ConditionKey CK_IS_NOT_NULL = new ConditionKeyIsNotNull();
    protected static final Object DUMMY_OBJECT = new Object();
    protected String _conditionKey;
    protected String _operand;

    public static boolean isNullaleConditionKey(ConditionKey key) {
        return CK_GREATER_EQUAL_OR_IS_NULL.equals(key) || CK_GREATER_THAN_OR_IS_NULL.equals(key) || CK_LESS_EQUAL_OR_IS_NULL.equals(key) || CK_LESS_THAN_OR_IS_NULL.equals(key) || CK_IS_NULL.equals(key) || CK_IS_NULL_OR_EMPTY.equals(key);
    }

    public boolean isValidRegistration(final ConditionValue.QueryModeProvider provider, final ConditionValue cvalue, final Object value, final ColumnRealName callerName) {
        return cvalue.process(new ConditionValue.CallbackProcessor<Boolean>(){

            @Override
            public Boolean process() {
                return ConditionKey.this.doIsValidRegistration(cvalue, value, callerName);
            }

            @Override
            public ConditionValue.QueryModeProvider getProvider() {
                return provider;
            }
        });
    }

    protected abstract boolean doIsValidRegistration(ConditionValue var1, Object var2, ColumnRealName var3);

    public void addWhereClause(final ConditionValue.QueryModeProvider provider, final List<QueryClause> conditionList, final ColumnRealName columnRealName, final ConditionValue cvalue, final ColumnFunctionCipher cipher, final ConditionOption option) {
        cvalue.process(new ConditionValue.CallbackProcessor<Void>(){

            @Override
            public Void process() {
                if (option != null) {
                    ConditionKey.this.doAddWhereClause(conditionList, columnRealName, cvalue, cipher, option);
                } else {
                    ConditionKey.this.doAddWhereClause(conditionList, columnRealName, cvalue, cipher);
                }
                return null;
            }

            @Override
            public ConditionValue.QueryModeProvider getProvider() {
                return provider;
            }
        });
    }

    protected abstract void doAddWhereClause(List<QueryClause> var1, ColumnRealName var2, ConditionValue var3, ColumnFunctionCipher var4);

    protected abstract void doAddWhereClause(List<QueryClause> var1, ColumnRealName var2, ConditionValue var3, ColumnFunctionCipher var4, ConditionOption var5);

    public void setupConditionValue(ConditionValue.QueryModeProvider provider, ConditionValue conditionValue, Object value, String location) {
        this.setupConditionValue(provider, conditionValue, value, location, null);
    }

    public void setupConditionValue(final ConditionValue.QueryModeProvider provider, final ConditionValue cvalue, final Object value, final String location, final ConditionOption option) {
        cvalue.process(new ConditionValue.CallbackProcessor<Void>(){

            @Override
            public Void process() {
                if (option != null) {
                    ConditionKey.this.doSetupConditionValue(cvalue, value, location, option);
                } else {
                    ConditionKey.this.doSetupConditionValue(cvalue, value, location);
                }
                return null;
            }

            @Override
            public ConditionValue.QueryModeProvider getProvider() {
                return provider;
            }
        });
    }

    protected abstract void doSetupConditionValue(ConditionValue var1, Object var2, String var3);

    protected abstract void doSetupConditionValue(ConditionValue var1, Object var2, String var3, ConditionOption var4);

    protected QueryClause buildBindClause(ColumnRealName columnRealName, String location, ColumnFunctionCipher cipher) {
        return new StringQueryClause(this.doBuildBindMainQuery(columnRealName, location, cipher));
    }

    protected QueryClause doBuildBindClauseOrIsNull(ColumnRealName columnRealName, String location, ColumnFunctionCipher cipher) {
        String mainQuery = this.doBuildBindMainQuery(columnRealName, location, cipher);
        String clause = "(" + mainQuery + " or " + columnRealName + " is null)";
        return new StringQueryClause(clause);
    }

    protected String doBuildBindMainQuery(ColumnRealName columnRealName, String location, ColumnFunctionCipher cipher) {
        String bindExpression = this.buildBindExpression(location, null, cipher);
        return columnRealName + " " + this.getOperand() + " " + bindExpression;
    }

    protected QueryClause buildBindClause(ColumnRealName columnRealName, String operand, String location, String rearOption, ColumnFunctionCipher cipher) {
        String bindExpression = this.buildBindExpression(location, null, cipher);
        String clause = columnRealName + " " + operand + " " + bindExpression + rearOption;
        return new StringQueryClause(clause);
    }

    protected QueryClause buildBindClause(ColumnRealName columnRealName, String location, String dummyValue, ColumnFunctionCipher cipher) {
        String bindExpression = this.buildBindExpression(location, dummyValue, cipher);
        String clause = columnRealName + " " + this.getOperand() + " " + bindExpression;
        return new StringQueryClause(clause);
    }

    protected QueryClause buildClauseWithoutValue(ColumnRealName columnRealName) {
        String clause = columnRealName + " " + this.getOperand();
        return new StringQueryClause(clause);
    }

    protected String buildBindExpression(String location, String dummyValue, ColumnFunctionCipher cipher) {
        String bindExpression = "/*pmb." + location + "*/" + dummyValue;
        return cipher != null ? cipher.encrypt(bindExpression) : bindExpression;
    }

    protected String getWildCard() {
        return "%";
    }

    protected void noticeRegistered(ColumnRealName callerName, Object value) {
        if (_log.isDebugEnabled()) {
            String target = callerName + "." + this._conditionKey;
            _log.debug((Object)("*Found the duplicate query: target=" + target + " value=" + value));
        }
    }

    public String toString() {
        return "ConditionKey:{" + this.getConditionKey() + " " + this.getOperand() + "}";
    }

    public String getConditionKey() {
        return this._conditionKey;
    }

    public String getOperand() {
        return this._operand;
    }
}

