/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualOrderBean {
    public static final String THEME_KEY = "ManualOrder";
    protected final List<CaseWhenElement> _caseWhenAcceptedList = new ArrayList<CaseWhenElement>();
    protected final List<CaseWhenElement> _caseWhenBoundList = new ArrayList<CaseWhenElement>();
    protected ConnectionMode _connectionMode;

    public ConnectedOrderBean when_Equal(Object orderValue) {
        return this.doWhen(ConditionKey.CK_EQUAL, orderValue);
    }

    public ConnectedOrderBean when_NotEqual(Object orderValue) {
        return this.doWhen(ConditionKey.CK_NOT_EQUAL_STANDARD, orderValue);
    }

    public ConnectedOrderBean when_GreaterThan(Object orderValue) {
        return this.doWhen(ConditionKey.CK_GREATER_THAN, orderValue);
    }

    public ConnectedOrderBean when_LessThan(Object orderValue) {
        return this.doWhen(ConditionKey.CK_LESS_THAN, orderValue);
    }

    public ConnectedOrderBean when_GreaterEqual(Object orderValue) {
        return this.doWhen(ConditionKey.CK_GREATER_EQUAL, orderValue);
    }

    public ConnectedOrderBean when_LessEqual(Object orderValue) {
        return this.doWhen(ConditionKey.CK_LESS_EQUAL, orderValue);
    }

    public ConnectedOrderBean when_IsNull() {
        return this.doWhen(ConditionKey.CK_IS_NULL, null);
    }

    public ConnectedOrderBean when_IsNotNull() {
        return this.doWhen(ConditionKey.CK_IS_NOT_NULL, null);
    }

    public ConnectedOrderBean when_FromTo(Date fromDate, Date toDate, FromToOption option) {
        return this.doWhen_FromTo(fromDate, toDate, option);
    }

    public ConnectedOrderBean when_DateFromTo(Date fromDate, Date toDate) {
        return this.doWhen_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected ConnectedOrderBean doWhen_FromTo(Date fromDate, Date toDate, FromToOption option) {
        if (option == null) {
            String msg = "The argument 'option' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        ConditionKey fromDateConditionKey = option.getFromDateConditionKey();
        ConditionKey toDateConditionKey = option.getToDateConditionKey();
        Date filteredFromDate = option.filterFromDate(fromDate);
        Date filteredToDate = option.filterToDate(toDate);
        return this.doWhen(fromDateConditionKey, filteredFromDate).doAnd(toDateConditionKey, filteredToDate);
    }

    protected ConnectedOrderBean doWhen(ConditionKey conditionKey, Object orderValue) {
        ConnectedOrderBean resultBean = new ConnectedOrderBean(this);
        if (orderValue == null && !this.isManualOrderConditionKeyNullHandling(conditionKey)) {
            String msg = "The argument 'orderValue' should not be null: conditionKey=" + conditionKey;
            throw new IllegalArgumentException(msg);
        }
        CaseWhenElement addedElement = this.createElement(conditionKey, orderValue);
        if (this._connectionMode != null) {
            CaseWhenElement previousConnected;
            ConnectionMode previousMode;
            if (this._caseWhenAcceptedList.isEmpty()) {
                String msg = "The connected mode should exist only when previous conditions exist:";
                msg = msg + " conditionKey=" + conditionKey + " orderValue=" + orderValue;
                throw new IllegalStateException(msg);
            }
            addedElement.setConnectionMode(this._connectionMode);
            CaseWhenElement lastElement = this._caseWhenAcceptedList.get(this._caseWhenAcceptedList.size() - 1);
            List<CaseWhenElement> connectedElementList = lastElement.getConnectedElementList();
            if (!connectedElementList.isEmpty() && (previousMode = (previousConnected = connectedElementList.get(connectedElementList.size() - 1)).getConnectionMode()) != null && !previousMode.equals((Object)addedElement.getConnectionMode())) {
                this.throwManualOrderTwoConnectorUnsupportedException(conditionKey, orderValue, lastElement);
            }
            lastElement.addConnectedElement(addedElement);
        } else {
            this._caseWhenAcceptedList.add(addedElement);
        }
        return resultBean;
    }

    protected boolean isManualOrderConditionKeyNullHandling(ConditionKey conditionKey) {
        return conditionKey.equals(ConditionKey.CK_IS_NULL) || conditionKey.equals(ConditionKey.CK_IS_NOT_NULL);
    }

    protected void throwManualOrderTwoConnectorUnsupportedException(ConditionKey conditionKey, Object orderValue, CaseWhenElement lastElement) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("both two connectors and/or were set.");
        br.addItem("Advice");
        br.addElement("Unsupported using both two connectors and/or in one case.");
        br.addElement("For example:");
        br.addElement("  (o): when FOO > 1 and FOO < 9 then ...");
        br.addElement("  (o): when FOO >= 1 or FOO >= 9 then ...");
        br.addElement("  (x): when FOO >= 1 and FOO >= 9 or FOO = 20 then ...");
        br.addItem("Added ConditionKey");
        br.addElement(conditionKey);
        br.addItem("Added OrderValue");
        br.addElement(orderValue);
        br.addItem("Fixed ConnectionMode");
        br.addElement((Object)lastElement.getConnectionMode());
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    public void acceptOrderValueList(List<? extends Object> orderValueList) {
        if (orderValueList == null) {
            String msg = "The argument 'orderValueList' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        for (Object object : orderValueList) {
            this.when_Equal(object);
        }
    }

    public boolean hasManualOrder() {
        return !this._caseWhenAcceptedList.isEmpty();
    }

    public void toBeConnectionModeAsAnd() {
        this._connectionMode = ConnectionMode.AND;
    }

    public void toBeConnectionModeAsOr() {
        this._connectionMode = ConnectionMode.OR;
    }

    public void clearConnectionMode() {
        this._connectionMode = null;
    }

    protected CaseWhenElement createElement(ConditionKey conditionKey, Object orderValue) {
        return new CaseWhenElement(conditionKey, orderValue);
    }

    public void bind(FreeParameterManualOrderThemeListHandler handler) {
        if (!this.hasManualOrder()) {
            return;
        }
        for (CaseWhenElement topElement : this._caseWhenAcceptedList) {
            CaseWhenElement boundTopElement = this.doBind(handler, topElement);
            List<CaseWhenElement> connectedList = topElement.getConnectedElementList();
            for (CaseWhenElement connectedElement : connectedList) {
                CaseWhenElement boundConnectedElement = this.doBind(handler, connectedElement);
                boundTopElement.addConnectedElement(boundConnectedElement);
            }
            this._caseWhenBoundList.add(boundTopElement);
        }
    }

    protected CaseWhenElement doBind(FreeParameterManualOrderThemeListHandler handler, CaseWhenElement element) {
        Object orderValue = this.getResolvedOrderValue(element);
        String bindExp = handler.register(THEME_KEY, orderValue);
        CaseWhenElement boundElement = this.createElement(element.getConditionKey(), bindExp);
        boundElement.setConnectionMode(element.getConnectionMode());
        return boundElement;
    }

    protected Object getResolvedOrderValue(CaseWhenElement element) {
        Object orderValue = element.getOrderValue();
        if (orderValue instanceof Classification) {
            orderValue = ((Classification)orderValue).code();
        }
        return orderValue;
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._caseWhenAcceptedList + "}";
    }

    public List<CaseWhenElement> getCaseWhenAcceptedList() {
        return this._caseWhenAcceptedList;
    }

    public List<CaseWhenElement> getCaseWhenBoundList() {
        return this._caseWhenBoundList;
    }

    public static interface FreeParameterManualOrderThemeListHandler {
        public String register(String var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CaseWhenElement {
        protected ConditionKey _conditionKey;
        protected Object _orderValue;
        protected List<CaseWhenElement> _connectedElementList;
        protected ConnectionMode _connectionMode;

        public CaseWhenElement(ConditionKey conditionKey, Object orderValue) {
            this._conditionKey = conditionKey;
            this._orderValue = orderValue;
        }

        public void toBeConnectionModeAsAnd() {
            this._connectionMode = ConnectionMode.AND;
        }

        public void toBeConnectionModeAsOr() {
            this._connectionMode = ConnectionMode.OR;
        }

        public String toConnector() {
            return this._connectionMode != null ? this._connectionMode.toString() : null;
        }

        public String toString() {
            return DfTypeUtil.toClassTitle(this) + ":{" + this._conditionKey + ", " + this._orderValue + ", " + this._connectedElementList + ", " + (Object)((Object)this._connectionMode) + "}";
        }

        public ConditionKey getConditionKey() {
            return this._conditionKey;
        }

        public Object getOrderValue() {
            return this._orderValue;
        }

        public List<CaseWhenElement> getConnectedElementList() {
            return this._connectedElementList != null ? this._connectedElementList : Collections.EMPTY_LIST;
        }

        public void addConnectedElement(CaseWhenElement connectedElement) {
            if (this._connectedElementList == null) {
                this._connectedElementList = new ArrayList<CaseWhenElement>();
            }
            this._connectedElementList.add(connectedElement);
        }

        public ConnectionMode getConnectionMode() {
            return this._connectionMode;
        }

        public void setConnectionMode(ConnectionMode connectionMode) {
            this._connectionMode = connectionMode;
        }
    }

    public static class ConnectedOrderBean {
        protected final ManualOrderBean _parentBean;

        public ConnectedOrderBean(ManualOrderBean parentBean) {
            this._parentBean = parentBean;
        }

        public ConnectedOrderBean and_Equal(Object orderValue) {
            return this.doAnd(ConditionKey.CK_EQUAL, orderValue);
        }

        public ConnectedOrderBean and_NotEqual(Object orderValue) {
            return this.doAnd(ConditionKey.CK_NOT_EQUAL_STANDARD, orderValue);
        }

        public ConnectedOrderBean and_GreaterThan(Object orderValue) {
            return this.doAnd(ConditionKey.CK_GREATER_THAN, orderValue);
        }

        public ConnectedOrderBean and_LessThan(Object orderValue) {
            return this.doAnd(ConditionKey.CK_LESS_THAN, orderValue);
        }

        public ConnectedOrderBean and_GreaterEqual(Object orderValue) {
            return this.doAnd(ConditionKey.CK_GREATER_EQUAL, orderValue);
        }

        public ConnectedOrderBean and_LessEqual(Object orderValue) {
            return this.doAnd(ConditionKey.CK_LESS_EQUAL, orderValue);
        }

        public ConnectedOrderBean and_IsNull() {
            return this.doAnd(ConditionKey.CK_IS_NULL, null);
        }

        public ConnectedOrderBean and_IsNotNull() {
            return this.doAnd(ConditionKey.CK_IS_NOT_NULL, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectedOrderBean doAnd(ConditionKey conditionKey, Object orderValue) {
            this.toBeConnectionModeAsAnd();
            try {
                ConnectedOrderBean connectedOrderBean = this.delegate(conditionKey, orderValue);
                return connectedOrderBean;
            }
            finally {
                this.clearConnectionMode();
            }
        }

        public ConnectedOrderBean or_Equal(Object orderValue) {
            return this.doOr(ConditionKey.CK_EQUAL, orderValue);
        }

        public ConnectedOrderBean or_NotEqual(Object orderValue) {
            return this.doOr(ConditionKey.CK_NOT_EQUAL_STANDARD, orderValue);
        }

        public ConnectedOrderBean or_GreaterThan(Object orderValue) {
            return this.doOr(ConditionKey.CK_GREATER_THAN, orderValue);
        }

        public ConnectedOrderBean or_LessThan(Object orderValue) {
            return this.doOr(ConditionKey.CK_LESS_THAN, orderValue);
        }

        public ConnectedOrderBean or_GreaterEqual(Object orderValue) {
            return this.doOr(ConditionKey.CK_GREATER_EQUAL, orderValue);
        }

        public ConnectedOrderBean or_LessEqual(Object orderValue) {
            return this.doOr(ConditionKey.CK_LESS_EQUAL, orderValue);
        }

        public ConnectedOrderBean or_IsNull() {
            return this.doOr(ConditionKey.CK_IS_NULL, null);
        }

        public ConnectedOrderBean or_IsNotNull() {
            return this.doOr(ConditionKey.CK_IS_NOT_NULL, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectedOrderBean doOr(ConditionKey conditionKey, Object orderValue) {
            this.toBeConnectionModeAsOr();
            try {
                ConnectedOrderBean connectedOrderBean = this.delegate(conditionKey, orderValue);
                return connectedOrderBean;
            }
            finally {
                this.clearConnectionMode();
            }
        }

        protected ConnectedOrderBean delegate(ConditionKey conditionKey, Object orderValue) {
            if (ConditionKey.CK_EQUAL.equals(conditionKey)) {
                this._parentBean.when_Equal(orderValue);
            } else if (ConditionKey.CK_NOT_EQUAL_STANDARD.equals(conditionKey)) {
                this._parentBean.when_NotEqual(orderValue);
            } else if (ConditionKey.CK_GREATER_THAN.equals(conditionKey)) {
                this._parentBean.when_GreaterThan(orderValue);
            } else if (ConditionKey.CK_LESS_THAN.equals(conditionKey)) {
                this._parentBean.when_LessThan(orderValue);
            } else if (ConditionKey.CK_GREATER_EQUAL.equals(conditionKey)) {
                this._parentBean.when_GreaterEqual(orderValue);
            } else if (ConditionKey.CK_LESS_EQUAL.equals(conditionKey)) {
                this._parentBean.when_LessEqual(orderValue);
            } else if (ConditionKey.CK_IS_NULL.equals(conditionKey)) {
                this._parentBean.when_IsNull();
            } else if (ConditionKey.CK_IS_NOT_NULL.equals(conditionKey)) {
                this._parentBean.when_IsNotNull();
            } else {
                String msg = "Unknown conditionKey: " + conditionKey;
                throw new IllegalStateException(msg);
            }
            return this;
        }

        protected void toBeConnectionModeAsAnd() {
            this._parentBean.toBeConnectionModeAsAnd();
        }

        protected void toBeConnectionModeAsOr() {
            this._parentBean.toBeConnectionModeAsOr();
        }

        protected void clearConnectionMode() {
            this._parentBean.clearConnectionMode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ConnectionMode {
        AND("and"),
        OR("or");

        private String _connector;

        private ConnectionMode(String connector) {
            this._connector = connector;
        }

        public String toString() {
            return this._connector;
        }
    }
}

