/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.bhv.WritableOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.chelper.HpCalcSpecification;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.exception.SpecifyUpdateColumnInvalidException;
import org.seasar.dbflute.exception.VaryingUpdateCalculationUnsupportedColumnTypeException;
import org.seasar.dbflute.exception.VaryingUpdateCommonColumnSpecificationException;
import org.seasar.dbflute.exception.VaryingUpdateInvalidColumnSpecificationException;
import org.seasar.dbflute.exception.VaryingUpdateNotFoundCalculationException;
import org.seasar.dbflute.exception.VaryingUpdateOptimisticLockSpecificationException;
import org.seasar.dbflute.exception.VaryingUpdatePrimaryKeySpecificationException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateOption<CB extends ConditionBean>
implements WritableOption<CB> {
    protected List<HpCalcSpecification<CB>> _selfSpecificationList;
    protected Map<String, HpCalcSpecification<CB>> _selfSpecificationMap;
    protected SpecifyQuery<CB> _updateColumnSpecification;
    protected CB _updateColumnSpecifiedCB;
    protected Set<String> _forcedSpecifiedUpdateColumnSet;
    protected boolean _exceptCommonColumnForcedSpecified;
    protected boolean _disableCommonColumnAutoSetup;
    protected boolean _allowNonQueryUpdate;
    protected Integer _batchLoggingUpdateLimit;

    public HpCalculator self(SpecifyQuery<CB> selfCalculationSpecification) {
        if (selfCalculationSpecification == null) {
            String msg = "The argument 'selfCalculationSpecification' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._selfSpecificationList == null) {
            this._selfSpecificationList = DfCollectionUtil.newArrayList();
        }
        HpCalcSpecification<CB> specification = new HpCalcSpecification<CB>(selfCalculationSpecification);
        this._selfSpecificationList.add(specification);
        return specification;
    }

    public boolean hasSelfSpecification() {
        return this._selfSpecificationList != null && !this._selfSpecificationList.isEmpty();
    }

    public void resolveSelfSpecification(CB cb) {
        if (this._selfSpecificationList == null || this._selfSpecificationList.isEmpty()) {
            return;
        }
        this._selfSpecificationMap = StringKeyMap.createAsFlexibleOrdered();
        for (HpCalcSpecification<CB> specification : this._selfSpecificationList) {
            specification.specify(cb);
            String columnDbName = specification.getSpecifiedColumnInfo().getColumnDbName();
            this.assertSpecifiedColumn(cb, columnDbName);
            this._selfSpecificationMap.put(columnDbName, specification);
        }
    }

    protected void assertSpecifiedColumn(CB cb, String columnDbName) {
        ColumnInfo columnInfo;
        if (columnDbName == null) {
            this.throwVaryingUpdateInvalidColumnSpecificationException(cb);
        }
        if ((columnInfo = cb.getDBMeta().findColumnInfo(columnDbName)).isPrimary()) {
            this.throwVaryingUpdatePrimaryKeySpecificationException(columnInfo);
        }
        if (columnInfo.isCommonColumn()) {
            this.throwVaryingUpdateCommonColumnSpecificationException(columnInfo);
        }
        if (columnInfo.isOptimisticLock()) {
            this.throwVaryingUpdateOptimisticLockSpecificationException(columnInfo);
        }
        if (!columnInfo.isPropertyTypeNumber()) {
            String msg = "Not number column specified: " + columnInfo;
            throw new VaryingUpdateCalculationUnsupportedColumnTypeException(msg);
        }
    }

    protected void throwVaryingUpdateInvalidColumnSpecificationException(CB cb) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The specified column for varying-update was invalid.");
        br.addItem("Advice");
        br.addElement("You should call specify().column[TargetColumn]() only once.");
        br.addElement("For example:");
        br.addElement("");
        br.addElement("  (x):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            // *no, empty");
        br.addElement("        }");
        br.addElement("    });");
        br.addElement("  (x):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount();");
        br.addElement("            cb.specify().columnPurchasePrice(); // *no, duplicated");
        br.addElement("        }");
        br.addElement("    });");
        br.addElement("  (o)");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount(); // OK");
        br.addElement("        }");
        br.addElement("    });");
        br.addItem("Target Table");
        br.addElement(cb.getTableDbName());
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateInvalidColumnSpecificationException(msg);
    }

    protected void throwVaryingUpdatePrimaryKeySpecificationException(ColumnInfo columnInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The primary key column was specified.");
        br.addItem("Advice");
        br.addElement("Varying-update is not allowed to specify a PK column.");
        br.addItem("Target Table");
        br.addElement(columnInfo.getDBMeta().getTableDbName());
        br.addItem("Specified Column");
        br.addElement(columnInfo);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdatePrimaryKeySpecificationException(msg);
    }

    protected void throwVaryingUpdateCommonColumnSpecificationException(ColumnInfo columnInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The column for optimistic lock was specified.");
        br.addItem("Advice");
        br.addElement("Varying-update is not allowed to specify a optimistic-lock column.");
        br.addItem("Target Table");
        br.addElement(columnInfo.getDBMeta().getTableDbName());
        br.addItem("Specified Column");
        br.addElement(columnInfo);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateCommonColumnSpecificationException(msg);
    }

    protected void throwVaryingUpdateOptimisticLockSpecificationException(ColumnInfo columnInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The column for optimistic lock was specified.");
        br.addItem("Advice");
        br.addElement("Varying-update is not allowed to specify a optimistic-lock column.");
        br.addItem("Target Table");
        br.addElement(columnInfo.getDBMeta().getTableDbName());
        br.addItem("Specified Column");
        br.addElement(columnInfo);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateOptimisticLockSpecificationException(msg);
    }

    protected String getSpecifiedColumnDbNameAsOne(CB cb) {
        return cb.getSqlClause().getSpecifiedColumnDbNameAsOne();
    }

    public boolean hasStatement(String columnDbName) {
        return this.findStatementSpecification(columnDbName) != null;
    }

    public String buildStatement(String columnDbName) {
        HpCalcSpecification<CB> calcSp = this.findStatementSpecification(columnDbName);
        if (calcSp == null) {
            return null;
        }
        String statement = calcSp.buildStatementAsSqlName();
        if (statement == null) {
            this.throwVaryingUpdateNotFoundCalculationException(columnDbName);
        }
        return statement;
    }

    protected HpCalcSpecification<CB> findStatementSpecification(String columnDbName) {
        return this._selfSpecificationMap != null ? this._selfSpecificationMap.get(columnDbName) : null;
    }

    protected void throwVaryingUpdateNotFoundCalculationException(String columnDbName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("A calculation of specified column for varying-update was not found.");
        br.addItem("Advice");
        br.addElement("You should call plus()/minus()/... methods after specification.");
        br.addElement("For example:");
        br.addElement("");
        br.addElement("  (x):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount();");
        br.addElement("        }");
        br.addElement("    }); // *no!");
        br.addElement("  (o):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount();");
        br.addElement("        }");
        br.addElement("    }).plus(1); // OK");
        br.addItem("Specified Column");
        br.addElement(columnDbName);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateNotFoundCalculationException(msg);
    }

    public void specify(SpecifyQuery<CB> updateColumnSpecification) {
        if (updateColumnSpecification == null) {
            String msg = "The argument 'updateColumnSpecification' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._updateColumnSpecification = updateColumnSpecification;
    }

    public boolean hasSpecifiedUpdateColumn() {
        return this._updateColumnSpecification != null;
    }

    public void resolveUpdateColumnSpecification(CB cb) {
        if (!this.hasSpecifiedUpdateColumn()) {
            return;
        }
        this._updateColumnSpecification.specify(cb);
        this._updateColumnSpecifiedCB = cb;
        if (!this._exceptCommonColumnForcedSpecified) {
            List<ColumnInfo> beforeUpdateList = cb.getDBMeta().getCommonColumnInfoBeforeUpdateList();
            this.xacceptForcedSpecifiedUpdateColumn(beforeUpdateList);
        }
    }

    public void xcheckSpecifiedUpdateColumnPrimaryKey() {
        if (!this.hasSpecifiedUpdateColumn()) {
            return;
        }
        this.assertUpdateColumnSpecifiedCB();
        CB cb = this._updateColumnSpecifiedCB;
        String basePointAliasName = cb.getSqlClause().getBasePointAliasName();
        DBMeta dbmeta = cb.getDBMeta();
        if (dbmeta.hasPrimaryKey()) {
            UniqueInfo pkInfo = dbmeta.getPrimaryUniqueInfo();
            List<ColumnInfo> pkList = pkInfo.getUniqueColumnList();
            for (ColumnInfo pk : pkList) {
                String columnDbName = pk.getColumnDbName();
                if (!cb.getSqlClause().hasSpecifiedSelectColumn(basePointAliasName, columnDbName)) continue;
                String msg = "PK columns should not be allowed to specify as update columns: " + columnDbName;
                throw new SpecifyUpdateColumnInvalidException(msg);
            }
        }
    }

    public boolean isSpecifiedUpdateColumn(String columnDbName) {
        if (this._forcedSpecifiedUpdateColumnSet != null && this._forcedSpecifiedUpdateColumnSet.contains(columnDbName)) {
            return true;
        }
        this.assertUpdateColumnSpecifiedCB();
        SqlClause sqlClause = this._updateColumnSpecifiedCB.getSqlClause();
        return sqlClause.hasSpecifiedSelectColumn(sqlClause.getBasePointAliasName(), columnDbName);
    }

    protected void assertUpdateColumnSpecifiedCB() {
        if (this._updateColumnSpecifiedCB == null) {
            String msg = "The CB for specification of update columns should be required here.";
            throw new IllegalStateException(msg);
        }
    }

    public UpdateOption<CB> exceptCommonColumnForcedSpecified() {
        this._exceptCommonColumnForcedSpecified = true;
        return this;
    }

    protected void xacceptForcedSpecifiedUpdateColumn(List<ColumnInfo> columnInfoList) {
        if (columnInfoList == null || columnInfoList.isEmpty()) {
            return;
        }
        if (this._forcedSpecifiedUpdateColumnSet == null) {
            this._forcedSpecifiedUpdateColumnSet = DfCollectionUtil.newHashSet();
        }
        for (ColumnInfo columnInfo : columnInfoList) {
            this._forcedSpecifiedUpdateColumnSet.add(columnInfo.getColumnDbName());
        }
    }

    public UpdateOption<CB> disableCommonColumnAutoSetup() {
        this._disableCommonColumnAutoSetup = true;
        return this;
    }

    public boolean isCommonColumnAutoSetupDisabled() {
        return this._disableCommonColumnAutoSetup;
    }

    public UpdateOption<CB> allowNonQueryUpdate() {
        this._allowNonQueryUpdate = true;
        return this;
    }

    public boolean isNonQueryUpdateAllowed() {
        return this._allowNonQueryUpdate;
    }

    public void limitBatchUpdateLogging(Integer batchLoggingUpdateLimit) {
        this._batchLoggingUpdateLimit = batchLoggingUpdateLimit;
    }

    public Integer getBatchUpdateLoggingLimit() {
        return this._batchLoggingUpdateLimit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._selfSpecificationList != null && !this._selfSpecificationList.isEmpty()) {
            sb.append("SelfCalculationSpecified");
        }
        if (this._updateColumnSpecification != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("UpdateColumnSpecified");
        }
        if (this._disableCommonColumnAutoSetup) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("CommonColumnDisabled");
        }
        if (this._allowNonQueryUpdate) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("NonQueryUpdateAllowed");
        }
        if (this._batchLoggingUpdateLimit != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("batchLogging(" + this._batchLoggingUpdateLimit + ")");
        }
        if (sb.length() == 0) {
            sb.append("default");
        }
        return DfTypeUtil.toClassTitle(this) + ":{" + sb.toString() + "}";
    }
}

