/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.stat.quantile;

import java.util.Comparator;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.jet.random.engine.RandomEngine;
import org.apache.mahout.math.jet.random.sampling.WeightedRandomSampler;
import org.apache.mahout.math.jet.stat.quantile.DoubleBuffer;
import org.apache.mahout.math.jet.stat.quantile.DoubleQuantileEstimator;
import org.apache.mahout.math.jet.stat.quantile.Utils;
import org.apache.mahout.math.list.DoubleArrayList;

class UnknownDoubleQuantileEstimator
extends DoubleQuantileEstimator {
    private int currentTreeHeight;
    private final int treeHeightStartingSampling;
    private WeightedRandomSampler sampler;
    private final double precomputeEpsilon;

    UnknownDoubleQuantileEstimator(int b, int k, int h, double precomputeEpsilon, RandomEngine generator) {
        this.sampler = new WeightedRandomSampler(1, generator);
        this.setUp(b, k);
        this.treeHeightStartingSampling = h;
        this.precomputeEpsilon = precomputeEpsilon;
        this.clear();
    }

    protected DoubleBuffer[] buffersToCollapse() {
        DoubleBuffer[] fullBuffers = this.bufferSet._getFullOrPartialBuffers();
        UnknownDoubleQuantileEstimator.sortAscendingByLevel(fullBuffers);
        int minLevel = fullBuffers[1].level();
        if (fullBuffers[0].level() < minLevel) {
            fullBuffers[0].level(minLevel);
        }
        return this.bufferSet._getFullOrPartialBuffersWithLevel(minLevel);
    }

    public synchronized void clear() {
        super.clear();
        this.currentTreeHeight = 1;
        this.sampler.setWeight(1);
    }

    public Object clone() {
        UnknownDoubleQuantileEstimator copy = (UnknownDoubleQuantileEstimator)super.clone();
        if (this.sampler != null) {
            copy.sampler = (WeightedRandomSampler)((Object)copy.sampler.clone());
        }
        return copy;
    }

    protected void newBuffer() {
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (this.currentBufferToFill == null) {
            throw new IllegalStateException("Oops, no empty buffer.");
        }
        this.currentBufferToFill.level(this.currentTreeHeight - 1);
        this.currentBufferToFill.weight(this.sampler.getWeight());
    }

    protected void postCollapse(DoubleBuffer[] toCollapse) {
        if (toCollapse.length == this.bufferSet.b()) {
            ++this.currentTreeHeight;
            if (this.currentTreeHeight >= this.treeHeightStartingSampling) {
                this.sampler.setWeight(this.sampler.getWeight() * 2);
            }
        }
    }

    public DoubleArrayList quantileElements(DoubleArrayList phis) {
        if (this.precomputeEpsilon <= 0.0) {
            return super.quantileElements(phis);
        }
        int quantilesToPrecompute = (int)Utils.epsilonCeiling(1.0 / this.precomputeEpsilon);
        phis = phis.copy();
        double e = this.precomputeEpsilon;
        int index = phis.size();
        while (--index >= 0) {
            double phi = phis.get(index);
            int i = (int)Math.round((2.0 * phi / e - 1.0) / 2.0);
            i = Math.min(quantilesToPrecompute - 1, Math.max(0, i));
            double augmentedPhi = e / 2.0 * (double)(1 + 2 * i);
            phis.set(index, augmentedPhi);
        }
        return super.quantileElements(phis);
    }

    protected boolean sampleNextElement() {
        return this.sampler.sampleNextElement();
    }

    private static void sortAscendingByLevel(DoubleBuffer[] fullBuffers) {
        Sorting.quickSort((Object[])fullBuffers, (int)0, (int)(fullBuffers.length - 1), (Comparator)new Comparator<DoubleBuffer>(){

            @Override
            public int compare(DoubleBuffer o1, DoubleBuffer o2) {
                int l2;
                int l1 = o1.level();
                return l1 < (l2 = o2.level()) ? -1 : (l1 == l2 ? 0 : 1);
            }
        });
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.setLength(buf.length() - 1);
        return buf + ", h=" + this.currentTreeHeight + ", hStartSampling=" + this.treeHeightStartingSampling + ", precomputeEpsilon=" + this.precomputeEpsilon + ')';
    }
}

