/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.random.engine.RandomEngine;

@Deprecated
public class Hyperbolic
extends AbstractContinousDistribution {
    private double alpha;
    private double beta;
    private double a_setup = 0.0;
    private double b_setup = -1.0;
    private double hr;
    private double hl;
    private double s;
    private double pm;
    private double pr;
    private double samb;
    private double pmr;
    private double mpa_1;
    private double mmb_1;
    private static final Hyperbolic shared = new Hyperbolic(10.0, 10.0, Hyperbolic.makeDefaultGenerator());

    public Hyperbolic(double alpha, double beta, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(alpha, beta);
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double nextDouble(double alpha, double beta) {
        if (this.a_setup != alpha || this.b_setup != beta) {
            double amb = alpha * alpha - beta * beta;
            this.samb = Math.sqrt(amb);
            double mode = beta / this.samb;
            double help_1 = alpha * Math.sqrt(2.0 * this.samb + 1.0);
            double help_2 = beta * (this.samb + 1.0);
            double mpa = (help_2 + help_1) / amb;
            double mmb = (help_2 - help_1) / amb;
            double a_ = mpa - mode;
            double b_ = -mmb + mode;
            this.hr = -1.0 / (-alpha * mpa / Math.sqrt(1.0 + mpa * mpa) + beta);
            this.hl = 1.0 / (-alpha * mmb / Math.sqrt(1.0 + mmb * mmb) + beta);
            double a_1 = a_ - this.hr;
            double b_1 = b_ - this.hl;
            this.mmb_1 = mode - b_1;
            this.mpa_1 = mode + a_1;
            this.s = a_ + b_;
            this.pm = (a_1 + b_1) / this.s;
            this.pr = this.hr / this.s;
            this.pmr = this.pm + this.pr;
            this.a_setup = alpha;
            this.b_setup = beta;
        }
        while (true) {
            double e;
            double x;
            double u = this.randomGenerator.raw();
            double v = this.randomGenerator.raw();
            if (u <= this.pm) {
                x = this.mmb_1 + u * this.s;
                if (!(Math.log(v) <= -alpha * Math.sqrt(1.0 + x * x) + beta * x + this.samb)) continue;
                return x;
            }
            if (u <= this.pmr) {
                e = -Math.log((u - this.pm) / this.pr);
                x = this.mpa_1 + this.hr * e;
                if (!(Math.log(v) - e <= -alpha * Math.sqrt(1.0 + x * x) + beta * x + this.samb)) continue;
                return x;
            }
            e = Math.log((u - this.pmr) / (1.0 - this.pmr));
            x = this.mmb_1 + this.hl * e;
            if (Math.log(v) + e <= -alpha * Math.sqrt(1.0 + x * x) + beta * x + this.samb) return x;
        }
    }

    public void setState(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double alpha, double beta) {
        Hyperbolic hyperbolic = shared;
        synchronized (hyperbolic) {
            return shared.nextDouble(alpha, beta);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.alpha + ',' + this.beta + ')';
    }
}

