/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.function.IntFunction;
import org.apache.mahout.math.function.UnaryFunction;
import org.apache.mahout.math.jet.random.engine.RandomEngine;

public abstract class AbstractDistribution
extends PersistentObject
implements UnaryFunction,
IntFunction {
    protected RandomEngine randomGenerator;

    protected AbstractDistribution() {
    }

    public double apply(double dummy) {
        return this.nextDouble();
    }

    public int apply(int dummy) {
        return this.nextInt();
    }

    public Object clone() {
        AbstractDistribution copy = (AbstractDistribution)super.clone();
        if (this.randomGenerator != null) {
            copy.randomGenerator = (RandomEngine)this.randomGenerator.clone();
        }
        return copy;
    }

    protected RandomEngine getRandomGenerator() {
        return this.randomGenerator;
    }

    public static RandomEngine makeDefaultGenerator() {
        return RandomEngine.makeDefault();
    }

    public abstract double nextDouble();

    public int nextInt() {
        return (int)Math.round(this.nextDouble());
    }

    public byte nextByte() {
        return (byte)this.nextInt();
    }

    public char nextChar() {
        return (char)this.nextInt();
    }

    public long nextLong() {
        return Math.round(this.nextDouble());
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    protected void setRandomGenerator(RandomEngine randomGenerator) {
        this.randomGenerator = randomGenerator;
    }
}

