/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.h264.NALUnitReader;
import java.io.IOException;
import java.util.Arrays;

public class AnnexBNALUnitReader
implements NALUnitReader {
    private final IsoBufferWrapper src;

    public AnnexBNALUnitReader(IsoBufferWrapper src) throws IOException {
        this.src = src;
    }

    public IsoBufferWrapper nextNALUnit() throws IOException {
        if (this.src.remaining() < 5L) {
            return null;
        }
        long start = -1L;
        do {
            byte[] marker = new byte[4];
            if (this.src.remaining() >= 4L) {
                this.src.read(marker);
                if (Arrays.equals(new byte[]{0, 0, 0, 1}, marker)) {
                    if (start == -1L) {
                        start = this.src.position();
                        continue;
                    }
                    this.src.position(this.src.position() - 4L);
                    return this.src.getSegment(start, this.src.position() - start);
                }
                this.src.position(this.src.position() - 3L);
                continue;
            }
            return this.src.getSegment(start, this.src.size() - start);
        } while (this.src.remaining() > 0L);
        return this.src.getSegment(start, this.src.position());
    }
}

