/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.ultraviolet;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class AssetInformationBox
extends AbstractFullBox {
    String apid;
    String profileVersion;

    public AssetInformationBox() {
        super(IsoFile.fourCCtoBytes("ainf"));
    }

    protected long getContentSize() {
        return IsoFile.utf8StringLengthInBytes(this.apid) + 1 + 4;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(IsoFile.fourCCtoBytes(this.profileVersion));
        os.writeStringZeroTerm(this.apid);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.profileVersion = in.readString(4);
        this.apid = in.readString();
    }

    public String getApid() {
        return this.apid;
    }

    public void setApid(String apid) {
        this.apid = apid;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String profileVersion) {
        assert (profileVersion != null && profileVersion.length() == 4);
        this.profileVersion = profileVersion;
    }
}

