/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderSpecificInfo;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ProfileLevelIndicationDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Descriptor(tags={4})
public class DecoderConfigDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(DecoderConfigDescriptor.class.getName());
    int objectTypeIndication;
    int streamType;
    int upStream;
    int bufferSizeDB;
    long maxBitRate;
    long avgBitRate;
    DecoderSpecificInfo decoderSpecificInfo;
    AudioSpecificConfig audioSpecificInfo;
    List<ProfileLevelIndicationDescriptor> profileLevelIndicationDescriptors = new ArrayList<ProfileLevelIndicationDescriptor>();
    byte[] configDescriptorDeadBytes;

    @Override
    public void parse(int tag, IsoBufferWrapper in, int maxLength) throws IOException {
        int size;
        long read;
        BaseDescriptor descriptor;
        long begin;
        super.parse(tag, in, maxLength);
        this.objectTypeIndication = in.readUInt8();
        int data = in.readUInt8();
        this.streamType = data >>> 2;
        this.upStream = data >> 1 & 1;
        this.bufferSizeDB = in.readUInt24();
        this.maxBitRate = in.readUInt32();
        this.avgBitRate = in.readUInt32();
        int remainungSize = this.getSizeOfInstance() - 13;
        if (remainungSize > 2) {
            begin = in.position();
            descriptor = ObjectDescriptorFactory.createFrom(this.objectTypeIndication, in, remainungSize);
            read = in.position() - begin;
            log.finer(descriptor + " - DecoderConfigDescr1 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                if (read < (long)size) {
                    this.configDescriptorDeadBytes = in.read((int)((long)size - read));
                    in.position(begin + (long)size);
                }
                remainungSize -= size;
            } else {
                remainungSize = (int)((long)remainungSize - read);
            }
            if (descriptor instanceof DecoderSpecificInfo) {
                this.decoderSpecificInfo = (DecoderSpecificInfo)descriptor;
            }
            if (descriptor instanceof AudioSpecificConfig) {
                this.audioSpecificInfo = (AudioSpecificConfig)descriptor;
            }
        }
        while (remainungSize > 2) {
            begin = in.position();
            descriptor = ObjectDescriptorFactory.createFrom(this.objectTypeIndication, in, remainungSize);
            read = in.position() - begin;
            log.finer(descriptor + " - DecoderConfigDescr2 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                in.position(begin + (long)size);
                remainungSize -= size;
            } else {
                remainungSize = (int)((long)remainungSize - read);
            }
            if (!(descriptor instanceof ProfileLevelIndicationDescriptor)) continue;
            this.profileLevelIndicationDescriptors.add((ProfileLevelIndicationDescriptor)descriptor);
        }
    }

    public DecoderSpecificInfo getDecoderSpecificInfo() {
        return this.decoderSpecificInfo;
    }

    public AudioSpecificConfig getAudioSpecificInfo() {
        return this.audioSpecificInfo;
    }

    public List<ProfileLevelIndicationDescriptor> getProfileLevelIndicationDescriptors() {
        return this.profileLevelIndicationDescriptors;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DecoderConfigDescriptor");
        sb.append("{objectTypeIndication=").append(this.objectTypeIndication);
        sb.append(", streamType=").append(this.streamType);
        sb.append(", upStream=").append(this.upStream);
        sb.append(", bufferSizeDB=").append(this.bufferSizeDB);
        sb.append(", maxBitRate=").append(this.maxBitRate);
        sb.append(", avgBitRate=").append(this.avgBitRate);
        sb.append(", decoderSpecificInfo=").append(this.decoderSpecificInfo);
        sb.append(", audioSpecificInfo=").append(this.audioSpecificInfo);
        sb.append(", configDescriptorDeadBytes=").append(Hex.encodeHex(this.configDescriptorDeadBytes != null ? this.configDescriptorDeadBytes : new byte[]{}));
        sb.append(", profileLevelIndicationDescriptors=").append(this.profileLevelIndicationDescriptors == null ? "null" : Arrays.asList(this.profileLevelIndicationDescriptors).toString());
        sb.append('}');
        return sb.toString();
    }
}

