/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class OmaDrmInfoUrlBox
extends AbstractFullBox {
    public static final String TYPE = "infu";
    private String infoUrl;

    protected long getContentSize() {
        return OmaDrmInfoUrlBox.utf8StringLengthInBytes(this.infoUrl);
    }

    public OmaDrmInfoUrlBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.infoUrl = in.readString((int)(size - 4L));
    }

    public String toString() {
        return "OmaDrmInfoUrlBox[infoUrl=" + this.getInfoUrl() + "]";
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeStringNoTerm(this.infoUrl);
    }
}

