/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackFragmentRandomAccessBox
extends AbstractFullBox {
    public static final String TYPE = "tfra";
    private long trackId;
    private int reserved;
    private int lengthSizeOfTrafNum;
    private int lengthSizeOfTrunNum;
    private int lengthSizeOfSampleNum;
    private List<Entry> entries = Collections.emptyList();

    public TrackFragmentRandomAccessBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        long contentSize = 0L;
        contentSize += 12L;
        contentSize = this.getVersion() == 1 ? (contentSize += (long)(16 * this.entries.size())) : (contentSize += (long)(8 * this.entries.size()));
        contentSize += (long)((this.lengthSizeOfTrafNum + 1) * this.entries.size());
        contentSize += (long)((this.lengthSizeOfTrunNum + 1) * this.entries.size());
        return contentSize += (long)((this.lengthSizeOfSampleNum + 1) * this.entries.size());
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.trackId = in.readUInt32();
        long temp = in.readUInt32();
        this.reserved = (int)(temp >> 6);
        this.lengthSizeOfTrafNum = (int)(temp & 0x3FL) >> 4;
        this.lengthSizeOfTrunNum = (int)(temp & 0xCL) >> 2;
        this.lengthSizeOfSampleNum = (int)(temp & 3L);
        long numberOfEntries = in.readUInt32();
        this.entries = new ArrayList<Entry>();
        int i = 0;
        while ((long)i < numberOfEntries) {
            Entry entry = new Entry();
            if (this.getVersion() == 1) {
                entry.time = in.readUInt64();
                entry.moofOffset = in.readUInt64();
            } else {
                entry.time = in.readUInt32();
                entry.moofOffset = in.readUInt32();
            }
            entry.trafNumber = this.getVariable(this.lengthSizeOfTrafNum, in);
            entry.trunNumber = this.getVariable(this.lengthSizeOfTrunNum, in);
            entry.sampleNumber = this.getVariable(this.lengthSizeOfSampleNum, in);
            this.entries.add(entry);
            ++i;
        }
    }

    private long getVariable(long length, IsoBufferWrapper in) throws IOException {
        long ret;
        if ((length + 1L) * 8L == 8L) {
            ret = in.readUInt8();
        } else if ((length + 1L) * 8L == 16L) {
            ret = in.readUInt16();
        } else if ((length + 1L) * 8L == 24L) {
            ret = in.readUInt24();
        } else if ((length + 1L) * 8L == 32L) {
            ret = in.readUInt32();
        } else if ((length + 1L) * 8L == 64L) {
            ret = in.readUInt64();
        } else {
            throw new IOException("lengthSize not power of two");
        }
        return ret;
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.trackId);
        long temp = this.reserved << 6;
        temp |= (long)((this.lengthSizeOfTrafNum & 3) << 4);
        temp |= (long)((this.lengthSizeOfTrunNum & 3) << 2);
        os.writeUInt32(temp |= (long)(this.lengthSizeOfSampleNum & 3));
        os.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            if (this.getVersion() == 1) {
                os.writeUInt64(entry.time);
                os.writeUInt64(entry.moofOffset);
            } else {
                os.writeUInt32(entry.time);
                os.writeUInt32(entry.moofOffset);
            }
            os.write(this.toByteArray(this.lengthSizeOfTrafNum + 1, entry.trafNumber));
            os.write(this.toByteArray(this.lengthSizeOfTrunNum + 1, entry.trunNumber));
            os.write(this.toByteArray(this.lengthSizeOfSampleNum + 1, entry.sampleNumber));
        }
    }

    private byte[] toByteArray(int length, long value) {
        byte[] b = new byte[length];
        for (int j = b.length; j > 0; --j) {
            b[j - 1] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return b;
    }

    public void setTrackId(long trackId) {
        this.trackId = trackId;
    }

    public void setLengthSizeOfTrafNum(int lengthSizeOfTrafNum) {
        this.lengthSizeOfTrafNum = lengthSizeOfTrafNum;
    }

    public void setLengthSizeOfTrunNum(int lengthSizeOfTrunNum) {
        this.lengthSizeOfTrunNum = lengthSizeOfTrunNum;
    }

    public void setLengthSizeOfSampleNum(int lengthSizeOfSampleNum) {
        this.lengthSizeOfSampleNum = lengthSizeOfSampleNum;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getLengthSizeOfTrafNum() {
        return this.lengthSizeOfTrafNum;
    }

    public int getLengthSizeOfTrunNum() {
        return this.lengthSizeOfTrunNum;
    }

    public int getLengthSizeOfSampleNum() {
        return this.lengthSizeOfSampleNum;
    }

    public long getNumberOfEntries() {
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public static class Entry {
        private long time;
        private long moofOffset;
        private long trafNumber;
        private long trunNumber;
        private long sampleNumber;

        public long getTime() {
            return this.time;
        }

        public long getMoofOffset() {
            return this.moofOffset;
        }

        public long getTrafNumber() {
            return this.trafNumber;
        }

        public long getTrunNumber() {
            return this.trunNumber;
        }

        public long getSampleNumber() {
            return this.sampleNumber;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setMoofOffset(long moofOffset) {
            this.moofOffset = moofOffset;
        }

        public void setTrafNumber(long trafNumber) {
            this.trafNumber = trafNumber;
        }

        public void setTrunNumber(long trunNumber) {
            this.trunNumber = trunNumber;
        }

        public void setSampleNumber(long sampleNumber) {
            this.sampleNumber = sampleNumber;
        }

        public String toString() {
            return "Entry{time=" + this.time + ", moofOffset=" + this.moofOffset + ", trafNumber=" + this.trafNumber + ", trunNumber=" + this.trunNumber + ", sampleNumber=" + this.sampleNumber + '}';
        }
    }
}

