/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hwpf.model.PictureDescriptor;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class Picture
extends PictureDescriptor {
    private static final POILogger log = POILogFactory.getLogger(Picture.class);
    static final int PICF_OFFSET = 0;
    static final int PICT_HEADER_OFFSET = 4;
    static final int MFPMM_OFFSET = 6;
    static final int PICF_SHAPE_OFFSET = 14;
    static final int UNKNOWN_HEADER_SIZE = 73;
    @Deprecated
    public static final byte[] GIF = PictureType.GIF.getSignatures()[0];
    @Deprecated
    public static final byte[] PNG = PictureType.PNG.getSignatures()[0];
    @Deprecated
    public static final byte[] JPG = PictureType.JPEG.getSignatures()[0];
    @Deprecated
    public static final byte[] BMP = PictureType.BMP.getSignatures()[0];
    @Deprecated
    public static final byte[] TIFF = PictureType.TIFF.getSignatures()[0];
    @Deprecated
    public static final byte[] TIFF1 = PictureType.TIFF.getSignatures()[1];
    @Deprecated
    public static final byte[] EMF = PictureType.EMF.getSignatures()[0];
    @Deprecated
    public static final byte[] WMF1 = PictureType.WMF.getSignatures()[0];
    @Deprecated
    public static final byte[] WMF2 = PictureType.WMF.getSignatures()[1];
    public static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    public static final byte[] COMPRESSED1 = new byte[]{-2, 120, -38};
    public static final byte[] COMPRESSED2 = new byte[]{-2, 120, -100};
    private int dataBlockStartOfsset;
    private int pictureBytesStartOffset;
    private int dataBlockSize;
    private int size;
    private byte[] rawContent;
    private byte[] content;
    private byte[] _dataStream;
    private int height = -1;
    private int width = -1;

    public Picture(int dataBlockStartOfsset, byte[] _dataStream, boolean fillBytes) {
        super(_dataStream, dataBlockStartOfsset);
        this._dataStream = _dataStream;
        this.dataBlockStartOfsset = dataBlockStartOfsset;
        this.dataBlockSize = LittleEndian.getInt((byte[])_dataStream, (int)dataBlockStartOfsset);
        this.pictureBytesStartOffset = Picture.getPictureBytesStartOffset(dataBlockStartOfsset, _dataStream, this.dataBlockSize);
        this.size = this.dataBlockSize - (this.pictureBytesStartOffset - dataBlockStartOfsset);
        if (this.size < 0) {
            // empty if block
        }
        if (fillBytes) {
            this.fillImageContent();
        }
    }

    public Picture(byte[] _dataStream) {
        this._dataStream = _dataStream;
        this.dataBlockStartOfsset = 0;
        this.dataBlockSize = _dataStream.length;
        this.pictureBytesStartOffset = 0;
        this.size = _dataStream.length;
    }

    private void fillWidthHeight() {
        PictureType pictureType = this.suggestPictureType();
        switch (pictureType) {
            case JPEG: {
                this.fillJPGWidthHeight();
                break;
            }
            case PNG: {
                this.fillPNGWidthHeight();
                break;
            }
        }
    }

    public String suggestFullFileName() {
        String fileExt = this.suggestFileExtension();
        return Integer.toHexString(this.dataBlockStartOfsset) + (fileExt.length() > 0 ? "." + fileExt : "");
    }

    public void writeImageContent(OutputStream out) throws IOException {
        if (this.rawContent != null && this.rawContent.length > 0) {
            out.write(this.rawContent, 0, this.size);
        } else {
            out.write(this._dataStream, this.pictureBytesStartOffset, this.size);
        }
    }

    public int getStartOffset() {
        return this.dataBlockStartOfsset;
    }

    public byte[] getContent() {
        this.fillImageContent();
        return this.content;
    }

    public byte[] getRawContent() {
        this.fillRawImageContent();
        return this.rawContent;
    }

    public int getSize() {
        return this.size;
    }

    @Deprecated
    public int getAspectRatioX() {
        return this.mx / 10;
    }

    public int getHorizontalScalingFactor() {
        return this.mx;
    }

    @Deprecated
    public int getAspectRatioY() {
        return this.my / 10;
    }

    public int getVerticalScalingFactor() {
        return this.my;
    }

    public int getDxaGoal() {
        return this.dxaGoal;
    }

    public int getDyaGoal() {
        return this.dyaGoal;
    }

    public int getDxaCropLeft() {
        return this.dxaCropLeft;
    }

    public int getDyaCropTop() {
        return this.dyaCropTop;
    }

    public int getDxaCropRight() {
        return this.dxaCropRight;
    }

    public int getDyaCropBottom() {
        return this.dyaCropBottom;
    }

    public String suggestFileExtension() {
        return this.suggestPictureType().getExtension();
    }

    public String getMimeType() {
        return this.suggestPictureType().getMime();
    }

    public PictureType suggestPictureType() {
        return PictureType.findMatchingType(this.getContent());
    }

    private void fillRawImageContent() {
        if (this.rawContent != null && this.rawContent.length > 0) {
            return;
        }
        this.rawContent = new byte[this.size];
        System.arraycopy(this._dataStream, this.pictureBytesStartOffset, this.rawContent, 0, this.size);
    }

    private void fillImageContent() {
        if (this.content != null && this.content.length > 0) {
            return;
        }
        byte[] rawContent = this.getRawContent();
        if (Picture.matchSignature(rawContent, COMPRESSED1, 32) || Picture.matchSignature(rawContent, COMPRESSED2, 32)) {
            try {
                int readBytes;
                InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(rawContent, 33, rawContent.length - 33));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((readBytes = in.read(buf)) > 0) {
                    out.write(buf, 0, readBytes);
                }
                this.content = out.toByteArray();
            }
            catch (IOException e) {
                log.log(POILogger.INFO, (Object)"Possibly corrupt compression or non-compressed data", (Throwable)e);
            }
        } else {
            this.content = rawContent;
        }
    }

    private static boolean matchSignature(byte[] pictureData, byte[] signature, int offset) {
        boolean matched = offset < pictureData.length;
        for (int i = 0; i + offset < pictureData.length && i < signature.length; ++i) {
            if (pictureData[i + offset] == signature[i]) continue;
            matched = false;
            break;
        }
        return matched;
    }

    private static int getPictureBytesStartOffset(int dataBlockStartOffset, byte[] _dataStream, int dataBlockSize) {
        short PICTF1BlockSize;
        int unknownHeaderOffset;
        int realPicoffset = dataBlockStartOffset;
        int dataBlockEndOffset = dataBlockSize + dataBlockStartOffset;
        short PICTFBlockSize = LittleEndian.getShort((byte[])_dataStream, (int)(dataBlockStartOffset + 4));
        int PICTF1BlockOffset = PICTFBlockSize + 4;
        short MM_TYPE = LittleEndian.getShort((byte[])_dataStream, (int)(dataBlockStartOffset + 4 + 2));
        if (MM_TYPE == 102) {
            int cchPicName = LittleEndian.getUnsignedByte((byte[])_dataStream, (int)PICTF1BlockOffset);
            PICTF1BlockOffset += 1 + cchPicName;
        }
        int n = unknownHeaderOffset = (PICTF1BlockSize = LittleEndian.getShort((byte[])_dataStream, (int)(dataBlockStartOffset + PICTF1BlockOffset))) + PICTF1BlockOffset < dataBlockEndOffset ? PICTF1BlockSize + PICTF1BlockOffset : PICTF1BlockOffset;
        if ((realPicoffset += unknownHeaderOffset + 73) >= dataBlockEndOffset) {
            realPicoffset -= 73;
        }
        return realPicoffset;
    }

    private void fillJPGWidthHeight() {
        int pointer = this.pictureBytesStartOffset + 2;
        byte firstByte = this._dataStream[pointer];
        byte secondByte = this._dataStream[pointer + 1];
        int endOfPicture = this.pictureBytesStartOffset + this.size;
        while (pointer < endOfPicture - 1) {
            do {
                firstByte = this._dataStream[pointer];
                secondByte = this._dataStream[pointer + 1];
            } while (firstByte != -1 && (pointer += 2) < endOfPicture - 1);
            if (firstByte == -1 && pointer < endOfPicture - 1) {
                if (secondByte == -39 || secondByte == -38) break;
                if ((secondByte & 0xF0) == 192 && secondByte != -60 && secondByte != -56 && secondByte != -52) {
                    this.height = Picture.getBigEndianShort(this._dataStream, pointer += 5);
                    this.width = Picture.getBigEndianShort(this._dataStream, pointer + 2);
                    break;
                }
                ++pointer;
                int length = Picture.getBigEndianShort(this._dataStream, ++pointer);
                pointer += length;
                continue;
            }
            ++pointer;
        }
    }

    private void fillPNGWidthHeight() {
        int HEADER_START = this.pictureBytesStartOffset + PNG.length + 4;
        if (Picture.matchSignature(this._dataStream, IHDR, HEADER_START)) {
            int IHDR_CHUNK_WIDTH = HEADER_START + 4;
            this.width = Picture.getBigEndianInt(this._dataStream, IHDR_CHUNK_WIDTH);
            this.height = Picture.getBigEndianInt(this._dataStream, IHDR_CHUNK_WIDTH + 4);
        }
    }

    public int getWidth() {
        if (this.width == -1) {
            this.fillWidthHeight();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            this.fillWidthHeight();
        }
        return this.height;
    }

    private static int getBigEndianInt(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 24) + ((data[offset + 1] & 0xFF) << 16) + ((data[offset + 2] & 0xFF) << 8) + (data[offset + 3] & 0xFF);
    }

    private static int getBigEndianShort(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 8) + (data[offset + 1] & 0xFF);
    }
}

