/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas_data.impl;

import java.util.Iterator;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.FeatureStructure;
import org.apache.uima.cas_data.FeatureValue;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.apache.uima.util.Level;

public class CasDataUtils {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class<CasDataUtils> CLASS_NAME = CasDataUtils.class;

    public static boolean hasFeature(CasData aCAS, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs;
            FeatureValue fValue;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || (fValue = (fs = object).getFeatureValue(featureName)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFeatureStructure(CasData aCAS, String aName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || !(fs = object).getType().equals(aName)) continue;
            return true;
        }
        return false;
    }

    public static void dumpFeatures(CasData aCAS) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure)) continue;
            FeatureStructure fs = object;
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "dumpFeatures", LOG_RESOURCE_BUNDLE, "UIMA_cas_feature_structure_type__FINE", fs.getType());
            String[] names = fs.getFeatureNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                FeatureValue fValue = fs.getFeatureValue(names[i]);
                if (fValue == null) continue;
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "dumpFeatures", LOG_RESOURCE_BUNDLE, "UIMA_cas_feature_name__FINE", new Object[]{names[i], fValue.toString()});
            }
        }
    }

    public static String getFeatureValueByType(CasData aCAS, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        String featureValue = null;
        while (it.hasNext()) {
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure)) continue;
            FeatureStructure fs = object;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("FeatureName::::::::::::::::::::::::::::::::::::::::::>" + fs.getType() + " Searching For::" + featureName);
            }
            if (!featureName.equals(fs.getType())) continue;
            String[] names = fs.getFeatureNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("Feature Structure:::" + fs.getType() + " Has Value::" + names[i]);
            }
            if ("uima.cpm.DocumentText".equals(featureName) || "UTF8:UTF8Content".equals(featureName)) {
                FeatureValue fValue = fs.getFeatureValue("value");
                if (fValue == null) {
                    return null;
                }
                return fValue.toString();
            }
            if ("Detag:DetagContent".equals(featureName)) {
                FeatureValue fValue = fs.getFeatureValue("Doc:SpannedText");
                if (fValue == null) {
                    return null;
                }
                return fValue.toString();
            }
            FeatureValue fValue = fs.getFeatureValue(featureName);
            if (fValue == null) continue;
            featureValue = fValue.toString();
            break;
        }
        return featureValue;
    }

    public static String[] getFeatureStructureValues(CasData aCAS, String featureStructureName, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        String featureValue = null;
        Vector<String> v = new Vector<String>();
        while (it.hasNext()) {
            FeatureStructure fs;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || !featureStructureName.equals((fs = object).getType())) continue;
            String[] names = fs.getFeatureNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                FeatureValue fValue;
                if (!names[i].equals(featureName) || (fValue = fs.getFeatureValue(featureName)) == null) continue;
                featureValue = fValue.toString();
                v.add(featureValue);
            }
        }
        Object[] features = new String[v.size()];
        v.copyInto(features);
        return features;
    }

    public static String getFeatureValueByType(CasData aCAS, String aFeatureStructure, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        String featureValue = null;
        while (it.hasNext()) {
            FeatureStructure fs;
            FeatureValue fValue;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || !object.getType().equals(aFeatureStructure) || (fValue = (fs = object).getFeatureValue(featureName)) == null) continue;
            featureValue = fValue.toString();
            break;
        }
        return featureValue;
    }

    public static NameValuePair[] getCasDataFeatures(CasData aCasData, String aFeatureStructureName) {
        NameValuePair[] valuePairSet = null;
        Iterator<FeatureStructure> it = aCasData.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || !object.getType().equals(aFeatureStructureName)) continue;
            FeatureStructure fs = object;
            String[] featureNames = fs.getFeatureNames();
            if (featureNames == null) {
                return new NameValuePair[0];
            }
            valuePairSet = new NameValuePair[featureNames.length];
            for (int i = 0; i < featureNames.length; ++i) {
                valuePairSet[i] = new NameValuePair_impl();
                valuePairSet[i].setName(featureNames[i]);
                valuePairSet[i].setValue(fs.getFeatureValue(featureNames[i]).toString());
            }
        }
        return valuePairSet;
    }
}

