/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.ArrayElement;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSData;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XCASParsingException;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XCASDeserializer {
    private TypeSystemImpl ts;
    private UimaContext uimaContext;
    private String docTypeName = "uima.tcas.Document";

    public XCASDeserializer(TypeSystem ts, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)ts;
        this.uimaContext = uimaContext;
    }

    public XCASDeserializer(TypeSystem ts) {
        this(ts, null);
    }

    public DefaultHandler getXCASHandler(CAS cas) {
        return this.getXCASHandler(cas, null);
    }

    public DefaultHandler getXCASHandler(CAS cas, OutOfTypeSystemData outOfTypeSystemData) {
        return new XCASDeserializerHandler((CASImpl)cas, outOfTypeSystemData);
    }

    public String getDocumentTypeName() {
        return this.docTypeName;
    }

    public void setDocumentTypeName(String aDocTypeName) {
        this.docTypeName = aDocTypeName;
    }

    public static void deserialize(InputStream aStream, CAS aCAS) throws SAXException, IOException {
        XCASDeserializer.deserialize(aStream, aCAS, false);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        XCASDeserializer deser = new XCASDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = aLenient ? deser.getXCASHandler(aCAS, new OutOfTypeSystemData()) : deser.getXCASHandler(aCAS);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(aStream));
    }

    private class XCASDeserializerHandler
    extends DefaultHandler {
        private static final int DOC_STATE = 0;
        private static final int FS_STATE = 1;
        private static final int FEAT_STATE = 2;
        private static final int CONTENT_STATE = 3;
        private static final int FEAT_CONTENT_STATE = 4;
        private static final int ARRAY_ELE_CONTENT_STATE = 5;
        private static final int ARRAY_ELE_STATE = 6;
        private static final int DOC_TEXT_STATE = 7;
        private static final int OOTS_FEAT_STATE = 8;
        private static final int OOTS_CONTENT_STATE = 9;
        private static final String DEFAULT_CONTENT_FEATURE = "value";
        private static final String reservedAttrPrefix = "_";
        private static final String unknownXMLSource = "<unknown>";
        private Locator locator;
        private CASImpl cas;
        private RedBlackTree<FSInfo> fsTree;
        private List<FSInfo> idLess;
        private int state;
        private StringBuffer buffer;
        private int currentAddr;
        private String currentContentFeat = "value";
        private int arrayPos;
        private OutOfTypeSystemData outOfTypeSystemData;
        private FSData currentOotsFs;
        private int sofaTypeCode;
        private Type annotBaseType;
        private List<FSIndexRepository> indexRepositories;
        private List<CAS> views;
        private IntVector sofaRefMap;
        private IntVector indexMap;
        private int nextIndex;

        private XCASDeserializerHandler(CASImpl aCAS, OutOfTypeSystemData ootsData) {
            this.cas = aCAS.getBaseCAS();
            this.cas.resetNoQuestions();
            this.fsTree = new RedBlackTree();
            this.idLess = new ArrayList<FSInfo>();
            this.buffer = new StringBuffer();
            this.outOfTypeSystemData = ootsData;
            this.indexRepositories = new ArrayList<FSIndexRepository>();
            this.views = new ArrayList<CAS>();
            this.indexRepositories.add(this.cas.getBaseIndexRepository());
            this.indexRepositories.add(this.cas.getView("_InitialView").getIndexRepository());
            this.sofaTypeCode = this.cas.ll_getTypeSystem().ll_getCodeForType(this.cas.getTypeSystem().getType("uima.cas.Sofa"));
            this.annotBaseType = this.cas.getAnnotationType();
            this.sofaRefMap = new IntVector();
            this.indexMap = new IntVector();
            this.sofaRefMap.add(1);
            this.indexMap.add(0);
        }

        private final void resetBuffer() {
            this.buffer = new StringBuffer();
        }

        public void startDocument() throws SAXException {
            this.state = 0;
        }

        public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            this.resetBuffer();
            switch (this.state) {
                case 0: {
                    if (!qualifiedName.equals("CAS")) {
                        throw this.createException(0, qualifiedName);
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.currentContentFeat = DEFAULT_CONTENT_FEATURE;
                    if (qualifiedName.equals(XCASDeserializer.this.getDocumentTypeName())) {
                        this.readDocument(attrs);
                        break;
                    }
                    this.readFS(qualifiedName, attrs);
                    break;
                }
                case 6: {
                    this.readArrayElement(qualifiedName, attrs);
                    break;
                }
                default: {
                    throw this.createException(1, qualifiedName);
                }
            }
        }

        private void readDocument(Attributes attrs) {
            this.state = 7;
        }

        private void readArrayElement(String eleName, Attributes attrs) throws SAXParseException {
            if (!eleName.equals("i")) {
                throw this.createException(2, eleName);
            }
            if (attrs.getLength() > 0) {
                throw this.createException(3);
            }
            this.state = 5;
        }

        private void readFS(String qualifiedName, Attributes attrs) throws SAXParseException {
            String typeName = this.getCasTypeName(qualifiedName);
            TypeImpl type = (TypeImpl)XCASDeserializer.this.ts.getType(typeName);
            if (type == null && typeName.equals("uima.cas.SofA")) {
                type = (TypeImpl)XCASDeserializer.this.ts.getType("uima.cas.Sofa");
            }
            if (type == null) {
                if (this.outOfTypeSystemData == null) {
                    throw this.createException(4, typeName);
                }
                this.addToOutOfTypeSystemData(typeName, attrs);
            } else {
                if (this.cas.isArrayType(type.getCode())) {
                    this.readArray(type, attrs);
                    return;
                }
                int addr = this.cas.ll_createFS(type.getCode());
                this.readFS(addr, attrs, true);
            }
        }

        private void readFS(int addr, Attributes attrs, boolean toIndex) throws SAXParseException {
            this.currentAddr = addr;
            int id = -1;
            IntVector indexRep = new IntVector();
            int heapValue = this.cas.getHeapValue(addr);
            Type type = this.cas.ll_getTypeSystem().ll_getTypeForCode(this.cas.ll_getFSRefType(addr));
            if (this.sofaTypeCode == heapValue) {
                boolean isInitialView = false;
                String sofaID = attrs.getValue("sofaID");
                if (sofaID.equals("_DefaultTextSofaName")) {
                    sofaID = "_InitialView";
                }
                if (sofaID.equals("_InitialView")) {
                    isInitialView = true;
                }
                String sofaNum = attrs.getValue("sofaNum");
                int thisSofaNum = Integer.parseInt(sofaNum);
                int sofaFsId = Integer.parseInt(attrs.getValue("_id"));
                if (this.indexMap.size() == 1) {
                    if (isInitialView) {
                        if (thisSofaNum == 2) {
                            this.indexMap.add(-1);
                            this.indexMap.add(1);
                            this.nextIndex = 2;
                        } else {
                            this.indexMap.add(1);
                            this.nextIndex = 2;
                        }
                    } else if (thisSofaNum > 1) {
                        this.indexMap.add(1);
                        assert (thisSofaNum == 2);
                        this.indexMap.add(2);
                        this.nextIndex = 3;
                    } else {
                        this.indexMap.add(2);
                        this.nextIndex = 3;
                    }
                } else if (isInitialView) {
                    if (this.indexMap.size() == thisSofaNum) {
                        this.indexMap.add(1);
                    }
                } else {
                    this.indexMap.add(this.nextIndex);
                    ++this.nextIndex;
                }
                if (this.sofaRefMap.size() == thisSofaNum) {
                    this.sofaRefMap.add(sofaFsId);
                } else if (this.sofaRefMap.size() > thisSofaNum) {
                    this.sofaRefMap.set(thisSofaNum, sofaFsId);
                } else {
                    this.sofaRefMap.setSize(thisSofaNum + 1);
                    this.sofaRefMap.set(thisSofaNum, sofaFsId);
                }
            }
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.startsWith(reservedAttrPrefix)) {
                    if (attrName.equals("_id")) {
                        try {
                            id = Integer.parseInt(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw this.createException(5, attrValue);
                        }
                    }
                    if (attrName.equals("_content")) {
                        this.currentContentFeat = attrValue;
                        continue;
                    }
                    if (attrName.equals("_indexed")) {
                        String[] arrayvals = this.parseArray(attrValue);
                        for (int s = 0; s < arrayvals.length; ++s) {
                            indexRep.add(Integer.parseInt(arrayvals[s]));
                        }
                        continue;
                    }
                    this.handleFeature(type, addr, attrName, attrValue, false);
                    continue;
                }
                if (this.sofaTypeCode == heapValue && attrName.equals("sofaID") && attrValue.equals("_DefaultTextSofaName")) {
                    attrValue = "_InitialView";
                }
                this.handleFeature(type, addr, attrName, attrValue, false);
            }
            if (this.sofaTypeCode == heapValue) {
                SofaFS sofa = (SofaFS)this.cas.createFS(addr);
                this.cas.getBaseIndexRepository().addFS(sofa);
                CAS view = this.cas.getView(sofa);
                if (sofa.getSofaRef() == 1) {
                    this.cas.registerInitialSofa();
                } else {
                    this.indexRepositories.add(this.cas.getSofaIndexRepository(sofa));
                }
                ((CASImpl)view).registerView(sofa);
                this.views.add(view);
            }
            FSInfo fsInfo = new FSInfo(addr, indexRep);
            if (id < 0) {
                this.idLess.add(fsInfo);
            } else {
                this.fsTree.put(id, fsInfo);
            }
            this.state = 3;
        }

        private void readArray(TypeImpl type, Attributes attrs) throws SAXParseException {
            IntVector indexRep = new IntVector();
            int size = 0;
            int id = -1;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrVal = attrs.getValue(i);
                if (attrName.equals("_id")) {
                    try {
                        id = Integer.parseInt(attrVal);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(5, attrVal);
                    }
                }
                if (attrName.equals("size")) {
                    try {
                        size = Integer.parseInt(attrVal);
                        if (size >= 0) continue;
                        throw this.createException(6, attrVal);
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(9, attrVal);
                    }
                }
                if (attrName.equals("_indexed")) {
                    String[] arrayvals = this.parseArray(attrVal);
                    for (int s = 0; s < arrayvals.length; ++s) {
                        indexRep.add(Integer.parseInt(arrayvals[s]));
                    }
                    continue;
                }
                throw this.createException(7, attrName);
            }
            FeatureStructureImpl fs = this.cas.isIntArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createIntArrayFS(size)) : (this.cas.isFloatArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createFloatArrayFS(size)) : (this.cas.isStringArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createStringArrayFS(size)) : (this.cas.isBooleanArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createBooleanArrayFS(size)) : (this.cas.isByteArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createByteArrayFS(size)) : (this.cas.isShortArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createShortArrayFS(size)) : (this.cas.isLongArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createLongArrayFS(size)) : (this.cas.isDoubleArrayType(type) ? (FeatureStructureImpl)((Object)this.cas.createDoubleArrayFS(size)) : (FeatureStructureImpl)((Object)this.cas.createArrayFS(size)))))))));
            int addr = fs.getAddress();
            FSInfo fsInfo = new FSInfo(addr, indexRep);
            if (id >= 0) {
                this.fsTree.put(id, fsInfo);
            } else {
                this.idLess.add(fsInfo);
            }
            this.currentAddr = addr;
            this.arrayPos = 0;
            this.state = 6;
        }

        private final boolean emptyVal(String val) {
            return val == null || val.length() == 0;
        }

        private void handleFeature(int addr, String featName, String featVal, boolean lenient) throws SAXParseException {
            int typeCode = this.cas.ll_getFSRefType(addr);
            Type type = this.cas.ll_getTypeSystem().ll_getTypeForCode(typeCode);
            this.handleFeature(type, addr, featName, featVal, lenient);
        }

        private void handleFeature(Type type, int addr, String featName, String featVal, boolean lenient) throws SAXParseException {
            String realFeatName;
            FeatureImpl feat;
            if (featName.equals("sofa") && XCASDeserializer.this.ts.subsumes(this.annotBaseType, type)) {
                featVal = Integer.toString(this.sofaRefMap.get(Integer.parseInt(featVal)));
            }
            if (featName.equals("sofaID") && this.sofaTypeCode == this.cas.getHeapValue(addr)) {
                Type sofaType = XCASDeserializer.this.ts.ll_getTypeForCode(this.sofaTypeCode);
                FeatureImpl sofaNumFeat = (FeatureImpl)sofaType.getFeatureByBaseName("sofaNum");
                int sofaNum = this.cas.getFeatureValue(addr, sofaNumFeat.getCode());
                this.cas.setFeatureValue(addr, sofaNumFeat.getCode(), this.indexMap.get(sofaNum));
            }
            if ((feat = (FeatureImpl)type.getFeatureByBaseName(realFeatName = featName.startsWith("_ref_") ? featName.substring("_ref_".length()) : featName)) == null) {
                if (this.outOfTypeSystemData != null) {
                    Integer addrInteger = addr;
                    List<String[]> ootsAttrs = this.outOfTypeSystemData.extraFeatureValues.get(addrInteger);
                    if (ootsAttrs == null) {
                        ootsAttrs = new ArrayList<String[]>();
                        this.outOfTypeSystemData.extraFeatureValues.put(addrInteger, ootsAttrs);
                    }
                    ootsAttrs.add(new String[]{featName, featVal});
                } else if (!lenient) {
                    throw this.createException(8, featName);
                }
            } else if (this.cas.ll_isRefType(XCASDeserializer.this.ts.range(feat.getCode()))) {
                this.cas.setFeatureValue(addr, feat.getCode(), Integer.parseInt(featVal));
            } else {
                this.cas.setFeatureValueFromString(addr, feat.getCode(), featVal);
            }
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
            switch (this.state) {
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    this.buffer.append(chars, start, length);
                    break;
                }
            }
        }

        boolean isAllWhitespace(StringBuffer b) {
            int len = b.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(b.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public void endElement(String nsURI, String localName, String qualifiedName) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    if (!this.isAllWhitespace(this.buffer)) {
                        try {
                            this.handleFeature(this.currentAddr, this.currentContentFeat, this.buffer.toString(), true);
                        }
                        catch (XCASParsingException x) {
                            // empty catch block
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 4: {
                    this.handleFeature(this.currentAddr, qualifiedName, this.buffer.toString(), false);
                    this.state = 2;
                    break;
                }
                case 5: {
                    this.addArrayElement(this.buffer.toString());
                    this.state = 6;
                    break;
                }
                case 6: {
                    this.state = 1;
                    break;
                }
                case 7: {
                    SofaFS newSofa = this.cas.createInitialSofa("text");
                    CASImpl tcas = (CASImpl)this.cas.getInitialView();
                    tcas.registerView(newSofa);
                    tcas.setDocTextFromDeserializtion(this.buffer.toString());
                    int addr = 1;
                    int id = 1;
                    this.sofaRefMap.add(id);
                    FSInfo fsInfo = new FSInfo(addr, new IntVector());
                    this.fsTree.put(id, fsInfo);
                    this.state = 1;
                    break;
                }
                case 9: {
                    if (!this.isAllWhitespace(this.buffer)) {
                        this.currentOotsFs.featVals.put(this.currentContentFeat, this.buffer.toString());
                    }
                    this.state = 1;
                    break;
                }
                case 8: {
                    this.state = 1;
                }
            }
        }

        private void addArrayElement(String content) throws SAXParseException {
            if (this.arrayPos >= this.cas.ll_getArraySize(this.currentAddr)) {
                throw this.createException(11);
            }
            try {
                if (!this.emptyVal(content)) {
                    if (this.cas.isArrayType(this.cas.getHeap().heap[this.currentAddr])) {
                        this.cas.setArrayValueFromString(this.currentAddr, this.arrayPos, content);
                    } else {
                        System.out.println(" not a known array type ");
                    }
                }
            }
            catch (NumberFormatException e) {
                throw this.createException(9, content);
            }
            ++this.arrayPos;
        }

        public void endDocument() throws SAXException {
            for (FSInfo fsInfo : this.fsTree) {
                this.finalizeFS(fsInfo);
            }
            for (int i = 0; i < this.idLess.size(); ++i) {
                this.finalizeFS(this.idLess.get(i));
            }
            if (this.outOfTypeSystemData != null) {
                for (FSData fsData : this.outOfTypeSystemData.fsList) {
                    this.finalizeOutOfTypeSystemFS(fsData);
                }
                this.finalizeOutOfTypeSystemFeatures();
            }
            for (int i = 0; i < this.views.size(); ++i) {
                ((CASImpl)this.views.get(i)).updateDocumentAnnotation();
            }
        }

        private void finalizeFS(FSInfo fsInfo) {
            int type;
            int addr = fsInfo.addr;
            if (fsInfo.indexRep.size() >= 0) {
                for (int i = 0; i < fsInfo.indexRep.size(); ++i) {
                    if (this.indexMap.size() == 1) {
                        ((FSIndexRepositoryImpl)this.indexRepositories.get(fsInfo.indexRep.get(i))).addFS(addr);
                        continue;
                    }
                    ((FSIndexRepositoryImpl)this.indexRepositories.get(this.indexMap.get(fsInfo.indexRep.get(i)))).addFS(addr);
                }
            }
            if (this.cas.isArrayType(type = this.cas.getHeapValue(addr))) {
                this.finalizeArray(type, addr, fsInfo);
                return;
            }
            int[] feats = this.cas.getTypeSystemImpl().ll_getAppropriateFeatures(type);
            for (int i = 0; i < feats.length; ++i) {
                int feat = feats[i];
                if (!this.cas.ll_isRefType(XCASDeserializer.this.ts.range(feats[i]))) continue;
                int featVal = this.cas.getFeatureValue(addr, feat);
                FSInfo fsValInfo = this.fsTree.get(featVal);
                if (fsValInfo == null) {
                    this.cas.setFeatureValue(addr, feat, 0);
                    if (featVal == 0 || this.outOfTypeSystemData == null) continue;
                    Integer addrInteger = addr;
                    List<String[]> ootsAttrs = this.outOfTypeSystemData.extraFeatureValues.get(addrInteger);
                    if (ootsAttrs == null) {
                        ootsAttrs = new ArrayList<String[]>();
                        this.outOfTypeSystemData.extraFeatureValues.put(addrInteger, ootsAttrs);
                    }
                    String featFullName = XCASDeserializer.this.ts.ll_getFeatureForCode(feat).getName();
                    int separatorOffset = featFullName.indexOf(58);
                    String featName = "_ref_" + featFullName.substring(separatorOffset + 1);
                    ootsAttrs.add(new String[]{featName, Integer.toString(featVal)});
                    continue;
                }
                this.cas.setFeatureValue(addr, feat, fsValInfo.addr);
            }
        }

        private void finalizeArray(int type, int addr, FSInfo fsInfo) {
            if (!this.cas.isFSArrayType(type)) {
                return;
            }
            int size = this.cas.ll_getArraySize(addr);
            for (int i = 0; i < size; ++i) {
                int arrayVal = this.cas.getArrayValue(addr, i);
                FSInfo fsValInfo = this.fsTree.get(arrayVal);
                if (fsValInfo == null) {
                    this.cas.setArrayValue(addr, i, 0);
                    if (arrayVal == 0 || this.outOfTypeSystemData == null) continue;
                    Integer arrayAddrInteger = addr;
                    List<ArrayElement> ootsElements = this.outOfTypeSystemData.arrayElements.get(arrayAddrInteger);
                    if (ootsElements == null) {
                        ootsElements = new ArrayList<ArrayElement>();
                        this.outOfTypeSystemData.arrayElements.put(arrayAddrInteger, ootsElements);
                    }
                    ArrayElement ootsElem = new ArrayElement(i, "a" + Integer.toString(arrayVal));
                    ootsElements.add(ootsElem);
                    continue;
                }
                this.cas.setArrayValue(addr, i, fsValInfo.addr);
            }
        }

        private void finalizeOutOfTypeSystemFS(FSData aFS) {
            aFS.id = 'a' + aFS.id;
            for (Map.Entry<String, String> entry : aFS.featVals.entrySet()) {
                int val;
                String attrName = entry.getKey();
                if (!attrName.startsWith("_ref_") || (val = Integer.parseInt(entry.getValue())) < 0) continue;
                FSInfo fsValInfo = this.fsTree.get(val);
                if (fsValInfo != null) {
                    entry.setValue(Integer.toString(fsValInfo.addr));
                    continue;
                }
                entry.setValue("a" + val);
            }
        }

        private void finalizeOutOfTypeSystemFeatures() {
            for (List<String[]> attrs : this.outOfTypeSystemData.extraFeatureValues.values()) {
                for (String[] attr : attrs) {
                    int val;
                    if (!attr[0].startsWith("_ref_") || (val = Integer.parseInt(attr[1])) < 0) continue;
                    FSInfo fsValInfo = this.fsTree.get(val);
                    if (fsValInfo != null) {
                        attr[1] = Integer.toString(fsValInfo.addr);
                        continue;
                    }
                    attr[1] = "a" + val;
                }
            }
        }

        private XCASParsingException createException(int code) {
            XCASParsingException e = new XCASParsingException(code);
            String source = unknownXMLSource;
            String line = unknownXMLSource;
            String col = unknownXMLSource;
            if (this.locator != null) {
                source = this.locator.getSystemId();
                if (source == null) {
                    source = this.locator.getPublicId();
                }
                if (source == null) {
                    source = unknownXMLSource;
                }
                line = Integer.toString(this.locator.getLineNumber());
                col = Integer.toString(this.locator.getColumnNumber());
            }
            e.addArgument(source);
            e.addArgument(line);
            e.addArgument(col);
            return e;
        }

        private XCASParsingException createException(int code, String arg) {
            XCASParsingException e = this.createException(code);
            e.addArgument(arg);
            return e;
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void setDocumentLocator(Locator loc) {
            this.locator = loc;
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        private void addToOutOfTypeSystemData(String typeName, Attributes attrs) throws XCASParsingException {
            if (this.outOfTypeSystemData != null) {
                FSData fs = new FSData();
                fs.type = typeName;
                fs.indexRep = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attrName = attrs.getQName(i);
                    String attrValue = attrs.getValue(i);
                    if (attrName.startsWith(reservedAttrPrefix)) {
                        if (attrName.equals("_id")) {
                            fs.id = attrValue;
                            continue;
                        }
                        if (attrName.equals("_content")) {
                            this.currentContentFeat = attrValue;
                            continue;
                        }
                        if (attrName.equals("_indexed")) {
                            fs.indexRep = attrValue;
                            continue;
                        }
                        fs.featVals.put(attrName, attrValue);
                        continue;
                    }
                    fs.featVals.put(attrName, attrValue);
                }
                this.outOfTypeSystemData.fsList.add(fs);
                this.currentOotsFs = fs;
                this.state = 9;
            }
        }

        private String[] parseArray(String val) {
            String[] arrayVals = this.emptyVal(val = val.trim()) ? new String[]{} : val.split("\\s+");
            return arrayVals;
        }

        private String getCasTypeName(String aTagName) {
            if (aTagName.indexOf(58) == -1 && aTagName.indexOf(45) == -1) {
                return aTagName;
            }
            return StringUtils.replaceAll(StringUtils.replaceAll(aTagName, ":", "_colon_"), "-", "_dash_");
        }
    }

    private static class FSInfo {
        private int addr;
        private IntVector indexRep;

        private FSInfo(int addr, IntVector indexRep) {
            this.addr = addr;
            this.indexRep = indexRep;
        }
    }
}

