/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainEndResultTransformer
implements EndResultTransformer {
    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        Object value = result.get(rb.getGroupingSpec().getFields()[0]);
        if (TopGroups.class.isInstance(value)) {
            TopGroups topGroups = (TopGroups)value;
            SolrDocumentList docList = new SolrDocumentList();
            docList.setStart((long)rb.getGroupingSpec().getOffset());
            docList.setNumFound((long)rb.totalHitCount);
            Float maxScore = Float.valueOf(Float.NEGATIVE_INFINITY);
            for (GroupDocs group : topGroups.groups) {
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    if (maxScore.floatValue() < scoreDoc.score) {
                        maxScore = Float.valueOf(scoreDoc.score);
                    }
                    docList.add((Object)solrDocumentSource.retrieve(scoreDoc));
                }
            }
            if (maxScore.floatValue() != Float.NEGATIVE_INFINITY) {
                docList.setMaxScore(maxScore);
            }
            rb.rsp.add("response", docList);
        }
    }
}

