/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.SolrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShingleFilterFactory
extends BaseTokenFilterFactory {
    private int minShingleSize;
    private int maxShingleSize;
    private boolean outputUnigrams;
    private boolean outputUnigramsIfNoShingles;
    private String tokenSeparator;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.maxShingleSize = this.getInt("maxShingleSize", 2);
        if (this.maxShingleSize < 2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid maxShingleSize (" + this.maxShingleSize + ") - must be at least 2");
        }
        this.minShingleSize = this.getInt("minShingleSize", 2);
        if (this.minShingleSize < 2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid minShingleSize (" + this.minShingleSize + ") - must be at least 2");
        }
        if (this.minShingleSize > this.maxShingleSize) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid minShingleSize (" + this.minShingleSize + ") - must be no greater than maxShingleSize (" + this.maxShingleSize + ")");
        }
        this.outputUnigrams = this.getBoolean("outputUnigrams", true);
        this.outputUnigramsIfNoShingles = this.getBoolean("outputUnigramsIfNoShingles", false);
        this.tokenSeparator = args.containsKey("tokenSeparator") ? args.get("tokenSeparator") : " ";
    }

    public ShingleFilter create(TokenStream input) {
        ShingleFilter r = new ShingleFilter(input, this.minShingleSize, this.maxShingleSize);
        r.setOutputUnigrams(this.outputUnigrams);
        r.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
        r.setTokenSeparator(this.tokenSeparator);
        return r;
    }
}

