/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.analytics.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.analytics.AnalyticsExecutor;
import org.mobylet.core.analytics.AnalyticsHelper;
import org.mobylet.core.analytics.AnalyticsParameters;
import org.mobylet.core.analytics.impl.GoogleAnalyticsConfig;
import org.mobylet.core.analytics.impl.GoogleAnalyticsProcess;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.util.SingletonUtils;

public class GoogleAnalyticsExecutor
implements AnalyticsExecutor {
    protected ExecutorService pool;
    protected GoogleAnalyticsConfig config;
    protected boolean isInitialized = false;

    @Override
    public void execute(String urchinId) {
        block5: {
            this.initialize();
            try {
                AnalyticsHelper helper = SingletonUtils.get(AnalyticsHelper.class);
                AnalyticsParameters parameters = helper.getParameters(urchinId);
                if (this.isIgnoreUserAgent(parameters)) {
                    return;
                }
                GoogleAnalyticsProcess process = new GoogleAnalyticsProcess(parameters);
                if (this.pool != null) {
                    this.pool.execute(process);
                } else {
                    process.run();
                }
            }
            catch (Throwable t) {
                MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
                if (logger == null || !logger.isLoggable()) break block5;
                logger.log("[mobylet] GoogleAnalyticsExecutor#execute\u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u305f\u3081\u30b9\u30ec\u30c3\u30c9\u3092\u7d42\u4e86\u3057\u307e\u3059 = " + t.getMessage());
            }
        }
    }

    protected boolean isIgnoreUserAgent(AnalyticsParameters parameters) {
        try {
            if (this.config.isIgnoreMobileCrawler.booleanValue()) {
                Matcher mobileMatcher = this.config.getRegexMobileCrawler().matcher(parameters.getUserAgent());
                if (mobileMatcher.find()) {
                    return true;
                }
                if (this.config.isIgnoreCrawler.booleanValue() && this.config.getRegexCrawler().matcher(parameters.getUserAgent()).find()) {
                    return true;
                }
            } else if (this.config.isIgnoreCrawler.booleanValue() && this.config.getRegexCrawler().matcher(parameters.getUserAgent()).find()) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
            if (logger != null && logger.isLoggable()) {
                logger.log("[mobylet] \u9664\u5916UserAgent\u691c\u8a3c\u51e6\u7406\u3067\u4f8b\u5916\u767a\u751f = " + e.getMessage());
            }
            throw new MobyletRuntimeException("\u9664\u5916UserAgent\u691c\u8a3c\u51e6\u7406\u306b\u3066\u4f8b\u5916\u767a\u751f", e);
        }
    }

    protected boolean isInitialized() {
        return this.isInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        if (!this.isInitialized()) {
            GoogleAnalyticsExecutor googleAnalyticsExecutor = this;
            synchronized (googleAnalyticsExecutor) {
                if (!this.isInitialized()) {
                    this.config = SingletonUtils.get(GoogleAnalyticsConfig.class);
                    Integer maxThread = this.config.getMaxThread();
                    if (maxThread > 0) {
                        this.pool = Executors.newFixedThreadPool(this.config.getMaxThread());
                    }
                    this.isInitialized = true;
                }
            }
        }
    }
}

