/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils {
    private MapUtils() {
    }

    public static <K, V> HashMap<K, V> asHashMap(Map<K, V> map) {
        if (map instanceof HashMap) {
            return (HashMap)map;
        }
        return new HashMap<K, V>(map);
    }

    public static Map<String, Object> unpack(Map map) {
        HashMap result = Maps.newHashMap();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry;
            Map.Entry mapEntry = entry = i$.next();
            String parameterName = (String)mapEntry.getKey();
            Object[] parameterValues = (String[])mapEntry.getValue();
            if (parameterValues.length == 1) {
                result.put(parameterName, parameterValues[0]);
                continue;
            }
            result.put(parameterName, Lists.newArrayList((Object[])parameterValues));
        }
        return result;
    }

    public static <K> Integer increment(Map<K, Integer> map, K key) {
        return MapUtils.increment(map, key, 1);
    }

    public static <K> Integer increment(Map<K, Integer> map, K key, int value) {
        Integer current = map.get(key);
        if (current == null) {
            map.put(key, value);
            return value;
        }
        map.put(key, current + value);
        return current + value;
    }
}

