/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.pipeline;

import java.util.List;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.DefaultLexicalDataFactory;
import org.carrot2.text.linguistic.DefaultStemmerFactory;
import org.carrot2.text.linguistic.DefaultTokenizerFactory;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.ITokenizerFactory;
import org.carrot2.text.linguistic.LanguageModel;
import org.carrot2.text.preprocessing.CaseNormalizer;
import org.carrot2.text.preprocessing.LanguageModelStemmer;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.StopListMarker;
import org.carrot2.text.preprocessing.Tokenizer;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.constraint.ImplementingClasses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="PreprocessingPipeline")
public class BasicPreprocessingPipeline {
    public final Tokenizer tokenizer = new Tokenizer();
    public final CaseNormalizer caseNormalizer = new CaseNormalizer();
    public final LanguageModelStemmer languageModelStemmer = new LanguageModelStemmer();
    public final StopListMarker stopListMarker = new StopListMarker();
    @Input
    @Init
    @Processing
    @Internal
    @Attribute
    @ImplementingClasses(classes={}, strict=false)
    public ITokenizerFactory tokenizerFactory = new DefaultTokenizerFactory();
    @Input
    @Init
    @Processing
    @Internal
    @Attribute
    @ImplementingClasses(classes={}, strict=false)
    public IStemmerFactory stemmerFactory = new DefaultStemmerFactory();
    @Input
    @Init
    @Processing
    @Internal
    @Attribute
    @ImplementingClasses(classes={}, strict=false)
    public ILexicalDataFactory lexicalDataFactory = new DefaultLexicalDataFactory();

    public PreprocessingContext preprocess(List<Document> documents, String query, LanguageCode language) {
        PreprocessingContext context = new PreprocessingContext(LanguageModel.create(language, this.stemmerFactory, this.tokenizerFactory, this.lexicalDataFactory), documents, query);
        this.preprocess(context);
        return context;
    }

    public void preprocess(PreprocessingContext context) {
        this.tokenizer.tokenize(context);
        this.caseNormalizer.normalize(context);
        this.languageModelStemmer.stem(context);
        this.stopListMarker.mark(context);
        context.preprocessingFinished();
    }
}

