/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.yahoo;

import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.yahoo.YahooSearchService;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="YahooNewsSearchService")
public final class YahooNewsSearchService
extends YahooSearchService {
    @Init
    @Input
    @Attribute
    public String serviceURI = "http://search.yahooapis.com/NewsSearchService/V1/newsSearch";
    @Processing
    @Input
    @Attribute
    public String site;
    @Processing
    @Input
    @Attribute
    public SortType sort = SortType.RANK;

    @Override
    protected ArrayList<NameValuePair> createRequestParams(String query, int start, int results) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(10);
        params.add((NameValuePair)new BasicNameValuePair("query", query));
        params.add((NameValuePair)new BasicNameValuePair("start", Integer.toString(start)));
        params.add((NameValuePair)new BasicNameValuePair("results", Integer.toString(results)));
        params.add((NameValuePair)new BasicNameValuePair("appid", this.appid));
        if (this.language != null) {
            params.add((NameValuePair)new BasicNameValuePair("language", this.language));
        }
        if (this.site != null) {
            params.add((NameValuePair)new BasicNameValuePair("site", this.site));
        }
        if (this.sort != null) {
            params.add((NameValuePair)new BasicNameValuePair("sort", this.sort.getApiOption()));
        }
        if (this.type != null) {
            params.add((NameValuePair)new BasicNameValuePair("type", this.type.getApiOption()));
        }
        return params;
    }

    @Override
    protected String getServiceURI() {
        return this.serviceURI;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortType {
        RANK,
        DATE;


        public String getApiOption() {
            switch (this) {
                case RANK: {
                    return "rank";
                }
                case DATE: {
                    return "date";
                }
            }
            throw new RuntimeException("Unknown constant: " + this.name());
        }

        public String toString() {
            return "by " + this.name().toLowerCase();
        }
    }
}

