/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.carrot2.core.Document;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IControllerContextListener;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.lucene.FSDirectoryWrapper;
import org.carrot2.source.lucene.IFieldMapper;
import org.carrot2.source.lucene.SimpleFieldMapper;
import org.carrot2.source.lucene.StandardAnalyzerWrapper;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeUtils;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.attribute.constraint.NotBlank;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="LuceneDocumentSource", inherit={CommonAttributes.class})
public final class LuceneDocumentSource
extends ProcessingComponentBase
implements IDocumentSource {
    private static final Logger logger = LoggerFactory.getLogger(LuceneDocumentSource.class);
    @Processing
    @Input
    @Attribute(key="results", inherit=true)
    @IntRange(min=1)
    public int results = 100;
    @Processing
    @Output
    @Attribute(key="results-total", inherit=true)
    public long resultsTotal;
    @Processing
    @Output
    @Attribute(key="documents", inherit=true)
    @Internal
    public Collection<Document> documents;
    @Input
    @Attribute
    @Init
    @Processing
    @Required
    @Internal(configuration=true)
    @ImplementingClasses(classes={RAMDirectory.class, FSDirectory.class}, strict=false)
    public Directory directory;
    @Input
    @Init
    @Processing
    @Required
    @Attribute
    @ImplementingClasses(classes={SimpleAnalyzer.class, StandardAnalyzer.class, WhitespaceAnalyzer.class}, strict=false)
    public Analyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);
    @Input
    @Init
    @Processing
    @Required
    @Attribute
    @Internal
    @ImplementingClasses(classes={SimpleFieldMapper.class}, strict=false)
    public IFieldMapper fieldMapper = new SimpleFieldMapper();
    @Input
    @Processing
    @Attribute(key="query", inherit=false)
    @Required
    @ImplementingClasses(classes={Query.class, String.class}, strict=false)
    @NotBlank
    public Object query;
    private IdentityHashMap<Directory, IndexSearcher> openIndexes;
    private IControllerContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(IControllerContext context) {
        super.init(context);
        this.context = context;
        IControllerContext iControllerContext = context;
        synchronized (iControllerContext) {
            String key = AttributeUtils.getKey(this.getClass(), "openIndexes");
            if (context.getAttribute(key) == null) {
                context.setAttribute(key, Maps.newIdentityHashMap());
                context.addListener(new IControllerContextListener(){

                    public void beforeDisposal(IControllerContext context) {
                        LuceneDocumentSource.this.closeAllIndexes();
                    }
                });
            }
            this.openIndexes = (IdentityHashMap)context.getAttribute(key);
        }
    }

    public void process() throws ProcessingException {
        try {
            SearchEngineResponse response = this.fetchSearchResponse();
            this.documents = response.results;
            this.resultsTotal = response.getResultsTotal();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAs(ProcessingException.class, e);
        }
    }

    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        if (this.directory == null) {
            throw new ProcessingException("Directory attribute must not be empty.");
        }
        if (this.query instanceof String) {
            String[] searchFields = this.fieldMapper.getSearchFields();
            if (searchFields == null || searchFields.length == 0) {
                throw new ProcessingException("At least one search field must be given for a plain text query. Alternatively, use a Lucene Query object.");
            }
            String textQuery = (String)this.query;
            if (StringUtils.isEmpty((String)textQuery)) {
                throw new ProcessingException("An instantiated Lucene Query object or a non-empty plain text query is required.");
            }
            this.query = searchFields.length == 1 ? new QueryParser(Version.LUCENE_30, searchFields[0], this.analyzer).parse(textQuery) : new MultiFieldQueryParser(Version.LUCENE_30, searchFields, this.analyzer).parse(textQuery);
        }
        SearchEngineResponse response = new SearchEngineResponse();
        IndexSearcher searcher = this.indexOpen(this.directory);
        TopDocs docs = searcher.search((Query)this.query, null, this.results);
        response.metadata.put("resultsTotal", docs.totalHits);
        for (ScoreDoc scoreDoc : docs.scoreDocs) {
            Document doc = new Document();
            org.apache.lucene.document.Document luceneDoc = searcher.doc(scoreDoc.doc);
            this.fieldMapper.map((Query)this.query, this.analyzer, luceneDoc, doc);
            response.results.add(doc);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllIndexes() {
        IControllerContext iControllerContext = this.context;
        synchronized (iControllerContext) {
            for (IndexSearcher searcher : this.openIndexes.values()) {
                try {
                    searcher.close();
                }
                catch (IOException e) {
                    logger.warn("Could not close search index: " + searcher, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher indexOpen(Directory directory) throws ProcessingException {
        IControllerContext iControllerContext = this.context;
        synchronized (iControllerContext) {
            IndexSearcher searcher = this.openIndexes.get(directory);
            if (searcher == null) {
                try {
                    searcher = new IndexSearcher(directory, true);
                    this.openIndexes.put(directory, searcher);
                }
                catch (IOException e) {
                    throw ExceptionUtils.wrapAs(ProcessingException.class, e);
                }
            }
            return searcher;
        }
    }

    static {
        SimpleXmlWrappers.addWrapper(FSDirectory.class, FSDirectoryWrapper.class, false);
        SimpleXmlWrappers.addWrapper(StandardAnalyzer.class, StandardAnalyzerWrapper.class, true);
    }
}

