/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.output.metrics;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.Processing;
import org.carrot2.output.metrics.IdealPartitioningBasedMetric;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;

@Bindable
public class NormalizedMutualInformationMetric
extends IdealPartitioningBasedMetric {
    @Processing
    @Output
    @Attribute
    public Double normalizedMutualInformation;
    @Processing
    @Input
    @Attribute(key="documents")
    public List<Document> documents;
    @Processing
    @Input
    @Attribute(key="clusters")
    public List<Cluster> clusters;
    @Processing
    @Input
    @Attribute
    public boolean enabled = true;

    public void calculate() {
        int partitionCount = this.getPartitionsCount(this.documents);
        if (partitionCount == 0) {
            return;
        }
        if (this.clusters.size() == 0) {
            return;
        }
        Set<Object> partitions = this.getPartitions(this.documents);
        SetMultimap<Object, Document> documentsByPartition = this.getDocumentsByPartition(this.documents);
        Map<Object, Integer> documentCountByPartition = this.getDocumentCountByPartition(this.documents);
        int documentCount = this.documents.size();
        if (partitions.size() <= 1) {
            this.normalizedMutualInformation = 0.0;
            return;
        }
        Collection partitionSizes = Maps.transformValues((Map)documentsByPartition.asMap(), (Function)new Function<Collection<Document>, Integer>(){

            public Integer apply(Collection<Document> documents) {
                return documents.size();
            }
        }).values();
        double partitionEntropy = this.entropy(documentCount, partitionSizes.toArray(new Integer[partitionSizes.size()]));
        List clusterSizes = Lists.transform(this.clusters, (Function)new Function<Cluster, Integer>(){

            public Integer apply(Cluster cluster) {
                return cluster.size();
            }
        });
        double clusterEntropy = this.entropy(documentCount, clusterSizes.toArray(new Integer[clusterSizes.size()]));
        double mutualInformation = 0.0;
        for (Cluster cluster : this.clusters) {
            int clusterSize = cluster.size();
            for (Object partition : partitions) {
                List<Document> clusterDocuments = cluster.getAllDocuments();
                if (cluster.isOtherTopics() || clusterDocuments.size() == 0) continue;
                HashSet commonDocuments = Sets.newHashSet((Iterable)documentsByPartition.get(partition));
                commonDocuments.retainAll(clusterDocuments);
                int commonDocumentsCount = commonDocuments.size();
                if (commonDocumentsCount == 0) continue;
                mutualInformation += (double)commonDocumentsCount / (double)documentCount * Math.log((double)(documentCount * commonDocumentsCount) / (double)(clusterSize * documentCountByPartition.get(partition)));
            }
        }
        this.normalizedMutualInformation = mutualInformation / ((clusterEntropy + partitionEntropy) / 2.0);
    }

    private double entropy(int count, Integer ... elements) {
        double entropy = 0.0;
        Integer[] arr$ = elements;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int d = arr$[i$];
            if (d == 0) continue;
            entropy += (double)d / (double)count * Math.log((double)d / (double)count);
        }
        return -entropy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

