/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Random;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.NNIDoubleFactory2D;
import org.carrot2.matrix.NNIInterface;
import org.carrot2.matrix.factorization.IMatrixFactorization;
import org.carrot2.matrix.factorization.NonnegativeMatrixFactorizationEDFactory;

class BLASQuickCheck {
    private static final double ROWS_COLUMNS_RATIO = 2.8;
    private static final double COLUMNS_K_RATIO = 4.0;
    private PrintStream resultsPrintStream = System.out;

    BLASQuickCheck() {
    }

    void go() {
        NNIInterface.suppressNNI(false);
        if (NNIInterface.isNativeBlasAvailable()) {
            this.resultsPrintStream.println("Native BLAS routines available.");
            this.resultsPrintStream.println("Warming up...");
            this.benchmarkExecutionTime(true);
            this.resultsPrintStream.println("Benchmarking...");
            this.benchmarkExecutionTime(false);
        } else {
            this.resultsPrintStream.println("Native BLAS routines not available.");
            this.resultsPrintStream.println("Nothing to benchmark.");
        }
        this.resultsPrintStream.println("Done.");
    }

    void benchmarkExecutionTime(boolean warmUp) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(2);
        int[] columnCounts = new int[]{100, 150, 200, 300, 400, 500};
        long start = 0L;
        long stop = 0L;
        double minSpeedUp = 1.0E11;
        double maxSpeedUp = 0.0;
        double avgSpeedUp = 0.0;
        if (!warmUp) {
            this.resultsPrintStream.println("Algorithm\tMode\tTerms\tDocs\tGroups\tIters\tTime [ms]");
        }
        NonnegativeMatrixFactorizationEDFactory factory = new NonnegativeMatrixFactorizationEDFactory();
        factory.setMaxIterations(10);
        factory.setStopThreshold(-1.0);
        for (int j = 0; j < columnCounts.length; ++j) {
            DoubleMatrix2D A = this.createRandomTdMatrix((int)((double)columnCounts[j] * 2.8), columnCounts[j]);
            factory.setK((int)((double)A.columns() / 4.0));
            NNIInterface.suppressNNI(true);
            start = System.currentTimeMillis();
            IMatrixFactorization factorization = factory.factorize(A);
            stop = System.currentTimeMillis();
            long elapsed = stop - start;
            if (!warmUp) {
                this.resultsPrintStream.println(factorization.toString() + "\t" + "Java" + "\t" + A.rows() + "\t" + A.columns() + "\t" + factory.getK() + "\t" + factory.getMaxIterations() + "\t" + elapsed);
            }
            NNIInterface.suppressNNI(false);
            start = System.currentTimeMillis();
            factorization = factory.factorize(A);
            stop = System.currentTimeMillis();
            long elapsedNative = stop - start;
            if (warmUp) continue;
            this.resultsPrintStream.println(factorization.toString() + "\t" + "Native" + "\t" + A.rows() + "\t" + A.columns() + "\t" + factory.getK() + "\t" + factory.getMaxIterations() + "\t" + elapsedNative);
            double speedUp = (double)elapsed / (double)elapsedNative;
            if (minSpeedUp > speedUp) {
                minSpeedUp = speedUp;
            }
            if (maxSpeedUp < speedUp) {
                maxSpeedUp = speedUp;
            }
            avgSpeedUp += speedUp;
        }
        if (!warmUp) {
            this.resultsPrintStream.println("Min speedup: " + format.format(minSpeedUp));
            this.resultsPrintStream.println("Max speedup: " + format.format(maxSpeedUp));
            this.resultsPrintStream.println("Avg speedup: " + format.format(avgSpeedUp /= (double)columnCounts.length));
        }
    }

    private DoubleMatrix2D createRandomTdMatrix(int t, int d) {
        DoubleMatrix2D matrix = NNIDoubleFactory2D.nni.make(t, d);
        Random random = new Random(0L);
        double termsPerDocument = 0.01 + 0.01 * random.nextDouble();
        for (int i = 0; i < d; ++i) {
            int j = 0;
            while ((double)j < (double)t * termsPerDocument) {
                matrix.setQuick(random.nextInt(t), i, random.nextDouble());
                ++j;
            }
        }
        return matrix;
    }

    public static void main(String[] args) {
        new BLASQuickCheck().go();
    }
}

