/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.robot.dbflute.twowaysql.context.CommandContext;
import org.seasar.robot.dbflute.twowaysql.node.ValueAndType;
import org.seasar.robot.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.robot.dbflute.twowaysql.node.VariableNode;

public class BindVariableNode
extends VariableNode {
    public BindVariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        super(expression, testValue, specifiedSql, blockNullParameter);
    }

    protected void doProcess(CommandContext ctx, ValueAndType valueAndType) {
        Object finalValue = valueAndType.getTargetValue();
        Class<?> finalType = valueAndType.getTargetType();
        if (this.isInScope()) {
            if (finalValue == null) {
                this.throwBindOrEmbeddedCommentParameterNullValueException(valueAndType);
            }
            if (List.class.isAssignableFrom(finalType)) {
                this.bindArray(ctx, ((List)finalValue).toArray());
            } else if (finalType.isArray()) {
                this.bindArray(ctx, finalValue);
            } else {
                this.throwBindOrEmbeddedCommentInScopeNotListException(valueAndType);
            }
        } else {
            ctx.addSql("?", finalValue, finalType);
            if (this.isAcceptableLike()) {
                this.setupRearOption(ctx, valueAndType);
            }
        }
    }

    protected void bindArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedCommentParameterEmptyListException();
        }
        Class<?> clazz = null;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            clazz = currentElement.getClass();
            break;
        }
        if (clazz == null) {
            this.throwBindOrEmbeddedCommentParameterNullOnlyListException();
        }
        ctx.addSql("(");
        int validCount = 0;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (validCount > 0) {
                ctx.addSql(", ");
            }
            ctx.addSql("?", currentElement, clazz);
            ++validCount;
        }
        ctx.addSql(")");
    }

    protected ValueAndTypeSetupper.CommentType getCommentType() {
        return ValueAndTypeSetupper.CommentType.BIND;
    }
}

