/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.gps;

import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.gps.Accuracy;
import org.mobylet.core.gps.Geo;
import org.mobylet.core.util.StringUtils;

public class Gps {
    public static final char PLS = '+';
    public static final char MNS = '-';
    public static final char N = 'N';
    public static final char S = 'S';
    public static final char E = 'E';
    public static final char W = 'W';
    protected String strLat;
    protected Double lat;
    protected String strLon;
    protected Double lon;
    protected Double height = 0.0;
    protected Geo geo;
    protected Accuracy accuracy;

    public Gps(String strLat, String strLon, Geo geo) {
        this.setStrLat(strLat);
        this.setStrLon(strLon);
        this.setGeo(geo);
    }

    public Gps(Double lat, Double lon, Geo geo) {
        this.setLat(lat);
        this.setLon(lon);
        this.setGeo(geo);
    }

    public Gps(Gps gps) {
        this.setLat(gps.getLat());
        this.setLon(gps.getLon());
        this.setGeo(gps.getGeo());
    }

    public String getStrLat() {
        if (StringUtils.isEmpty(this.strLat) && this.lat != null) {
            double s = 3600.0 * this.lat % 60.0;
            int m = (int)((3600.0 * this.lat - s) / 60.0 % 60.0);
            double dd = ((3600.0 * this.lat - s) / 60.0 - (double)m) / 60.0;
            int d = (int)dd;
            this.strLat = String.valueOf(dd >= 0.0 ? (char)'+' : '-') + d + "." + m + "." + s;
        }
        return this.strLat;
    }

    public void setStrLat(String strLat) {
        this.strLat = strLat;
    }

    public Double getLat() {
        if (this.lat == null && StringUtils.isNotEmpty(this.strLat)) {
            try {
                boolean isPlus = true;
                int p1st = -1;
                int p2nd = -1;
                if (this.strLat.charAt(0) == '-' || this.strLat.charAt(0) == 'S' || this.strLat.charAt(0) == 'W') {
                    isPlus = false;
                    p1st = this.strLat.indexOf(".");
                    this.lat = Double.parseDouble(this.strLat.substring(1, p1st));
                } else if (this.strLat.charAt(0) == '+' || this.strLat.charAt(0) == 'N' || this.strLat.charAt(0) == 'E') {
                    isPlus = true;
                    p1st = this.strLat.indexOf(".");
                    this.lat = Double.parseDouble(this.strLat.substring(1, p1st));
                } else {
                    isPlus = true;
                    p1st = this.strLat.indexOf(".");
                    this.lat = Double.parseDouble(this.strLat.substring(0, p1st));
                }
                p2nd = this.strLat.indexOf(".", p1st + 1);
                this.lat = this.lat + Double.parseDouble(this.strLat.substring(p1st + 1, p2nd)) / 60.0;
                this.lat = this.lat + Double.parseDouble(this.strLat.substring(p2nd + 1)) / 3600.0;
                this.lat = isPlus ? this.lat : -this.lat.doubleValue();
            }
            catch (Exception e) {
                throw new MobyletRuntimeException("\u7def\u5ea6\u60c5\u5831\u306e\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059 LAT=" + this.strLat, e);
            }
        }
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public String getStrLon() {
        if (StringUtils.isEmpty(this.strLon) && this.lon != null) {
            double s = 3600.0 * this.lon % 60.0;
            int m = (int)((3600.0 * this.lon - s) / 60.0 % 60.0);
            double dd = ((3600.0 * this.lon - s) / 60.0 - (double)m) / 60.0;
            int d = (int)dd;
            this.strLon = String.valueOf(dd >= 0.0 ? (char)'+' : '-') + d + "." + m + "." + s;
        }
        return this.strLon;
    }

    public void setStrLon(String strLon) {
        this.strLon = strLon;
    }

    public Double getLon() {
        if (this.lon == null && StringUtils.isNotEmpty(this.strLon)) {
            try {
                boolean isPlus = true;
                int p1st = -1;
                int p2nd = -1;
                if (this.strLon.charAt(0) == '-' || this.strLon.charAt(0) == 'S' || this.strLon.charAt(0) == 'W') {
                    isPlus = false;
                    p1st = this.strLon.indexOf(".");
                    this.lon = Double.parseDouble(this.strLon.substring(1, p1st));
                } else if (this.strLon.charAt(0) == '+' || this.strLon.charAt(0) == 'N' || this.strLon.charAt(0) == 'E') {
                    isPlus = true;
                    p1st = this.strLon.indexOf(".");
                    this.lon = Double.parseDouble(this.strLon.substring(1, p1st));
                } else {
                    isPlus = true;
                    p1st = this.strLon.indexOf(".");
                    this.lon = Double.parseDouble(this.strLon.substring(0, p1st));
                }
                p2nd = this.strLon.indexOf(".", p1st + 1);
                this.lon = this.lon + Double.parseDouble(this.strLon.substring(p1st + 1, p2nd)) / 60.0;
                this.lon = this.lon + Double.parseDouble(this.strLon.substring(p2nd + 1)) / 3600.0;
                this.lon = isPlus ? this.lon : -this.lon.doubleValue();
            }
            catch (Exception e) {
                throw new MobyletRuntimeException("\u7d4c\u5ea6\u60c5\u5831\u306e\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059 LAT=" + this.strLat, e);
            }
        }
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Geo getGeo() {
        return this.geo;
    }

    public void setGeo(Geo geo) {
        this.geo = geo;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Accuracy accuracy) {
        this.accuracy = accuracy;
    }

    public String toString() {
        return "GEO=" + (Object)((Object)this.getGeo()) + " LAT=" + this.getStrLat() + " LON=" + this.getStrLon() + " HEIGHT=" + this.getHeight();
    }
}

