/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrueTypeParser
extends AbstractParser {
    private static final MediaType TYPE = MediaType.application((String)"x-font-ttf");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TTFParser parser = new TTFParser();
        TikaInputStream tis = TikaInputStream.cast((InputStream)stream);
        TrueTypeFont font = tis != null && tis.hasFile() ? parser.parseTTF(tis.getFile()) : parser.parseTTF(stream);
        metadata.set("Content-Type", TYPE.toString());
        metadata.set(DublinCore.DATE, font.getHeader().getCreated().getTime());
        metadata.set(Property.internalDate((String)"modified"), font.getHeader().getModified().getTime());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

