/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.DoubleFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleField
extends FieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.restrictProps(3072);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        field.checkSortability();
        return new SortField(field.name, 7, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new DoubleFieldSource(field.name);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeDouble(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String s = f.stringValue();
        if (s.length() == 0) {
            writer.writeNull(name);
            return;
        }
        try {
            double val = Double.parseDouble(s);
            writer.writeDouble(name, val);
        }
        catch (NumberFormatException e) {
            writer.writeStr(name, s, true);
        }
    }

    @Override
    public Double toObject(Fieldable f) {
        return Double.valueOf(this.toExternal(f));
    }
}

