/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.FileUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrResourceLoader
implements ResourceLoader {
    public static final Logger log = LoggerFactory.getLogger(SolrResourceLoader.class);
    static final String project = "solr";
    static final String base = "org.apache.solr";
    static final String[] packages = new String[]{"", "analysis.", "schema.", "handler.", "search.", "update.", "core.", "response.", "request.", "update.processor.", "util.", "spelling.", "handler.component.", "handler.dataimport."};
    private URLClassLoader classLoader;
    private final String instanceDir;
    private String dataDir;
    private final List<SolrCoreAware> waitingForCore = Collections.synchronizedList(new ArrayList());
    private final List<SolrInfoMBean> infoMBeans = Collections.synchronizedList(new ArrayList());
    private final List<ResourceLoaderAware> waitingForResources = Collections.synchronizedList(new ArrayList());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Properties coreProperties;
    private volatile boolean live;
    private static Map<String, String> classNameCache = new ConcurrentHashMap<String, String>();
    private static final Map<Class, Class[]> awareCompatibility = new HashMap<Class, Class[]>();

    public SolrResourceLoader(String instanceDir, ClassLoader parent, Properties coreProperties) {
        this.instanceDir = instanceDir == null ? SolrResourceLoader.locateSolrHome() : SolrResourceLoader.normalizeDir(instanceDir);
        log.info("Solr home set to '" + this.instanceDir + "'");
        this.classLoader = SolrResourceLoader.createClassLoader(null, parent);
        this.addToClassLoader("./lib/", null);
        this.coreProperties = coreProperties;
    }

    public SolrResourceLoader(String instanceDir, ClassLoader parent) {
        this(instanceDir, parent, null);
    }

    void addToClassLoader(String baseDir, FileFilter filter) {
        File base = FileUtils.resolvePath((File)new File(this.getInstanceDir()), (String)baseDir);
        this.classLoader = SolrResourceLoader.replaceClassLoader(this.classLoader, base, filter);
    }

    void addToClassLoader(String path) {
        final File file = FileUtils.resolvePath((File)new File(this.getInstanceDir()), (String)path);
        if (file.canRead()) {
            this.classLoader = SolrResourceLoader.replaceClassLoader(this.classLoader, file.getParentFile(), new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.equals(file);
                }
            });
        } else {
            log.error("Can't find (or read) file to add to classloader: " + file);
        }
    }

    private static URLClassLoader replaceClassLoader(URLClassLoader oldLoader, File base, FileFilter filter) {
        if (null != base && base.canRead() && base.isDirectory()) {
            File[] files = base.listFiles(filter);
            if (null == files || 0 == files.length) {
                return oldLoader;
            }
            URL[] oldElements = oldLoader.getURLs();
            URL[] elements = new URL[oldElements.length + files.length];
            System.arraycopy(oldElements, 0, elements, 0, oldElements.length);
            for (int j = 0; j < files.length; ++j) {
                try {
                    URL element = files[j].toURI().normalize().toURL();
                    log.info("Adding '" + element.toString() + "' to classloader");
                    elements[oldElements.length + j] = element;
                    continue;
                }
                catch (MalformedURLException e) {
                    SolrException.log((Logger)log, (String)("Can't add element to classloader: " + files[j]), (Throwable)e);
                }
            }
            return URLClassLoader.newInstance(elements, oldLoader.getParent());
        }
        return oldLoader;
    }

    static URLClassLoader createClassLoader(File libDir, ClassLoader parent) {
        if (null == parent) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        return SolrResourceLoader.replaceClassLoader(URLClassLoader.newInstance(new URL[0], parent), libDir, null);
    }

    public SolrResourceLoader(String instanceDir) {
        this(instanceDir, null, null);
    }

    public static String normalizeDir(String path) {
        return path != null && !path.endsWith("/") && !path.endsWith("\\") ? path + File.separator : path;
    }

    public String getConfigDir() {
        return this.instanceDir + "conf/";
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public Properties getCoreProperties() {
        return this.coreProperties;
    }

    public InputStream openSchema(String name) {
        return this.openResource(name);
    }

    public InputStream openConfig(String name) {
        return this.openResource(name);
    }

    public InputStream openResource(String resource) {
        InputStream is = null;
        try {
            File f0;
            File f = f0 = new File(resource);
            if (!f.isAbsolute()) {
                f = new File(this.getConfigDir() + resource);
            }
            if (f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            if (f != f0 && f0.isFile() && f0.canRead()) {
                return new FileInputStream(f0);
            }
            is = this.classLoader.getResourceAsStream(resource);
            if (is == null) {
                is = this.classLoader.getResourceAsStream(this.getConfigDir() + resource);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new RuntimeException("Can't find resource '" + resource + "' in classpath or '" + this.getConfigDir() + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    public List<String> getLines(String resource) throws IOException {
        return this.getLines(resource, UTF_8);
    }

    public List<String> getLines(String resource, String encoding) throws IOException {
        return this.getLines(resource, Charset.forName(encoding));
    }

    public List<String> getLines(String resource, Charset charset) throws IOException {
        ArrayList<String> lines;
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader(this.openResource(resource), charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT)));
            lines = new ArrayList<String>();
            String word = null;
            while ((word = input.readLine()) != null) {
                if (lines.isEmpty() && word.length() > 0 && word.charAt(0) == '\ufeff') {
                    word = word.substring(1);
                }
                if (word.startsWith("#") || (word = word.trim()).length() == 0) continue;
                lines.add(word);
            }
        }
        catch (CharacterCodingException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading resource (wrong encoding?): " + resource, (Throwable)ex);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return lines;
    }

    public Class findClass(String cname, String ... subpackages) {
        if (subpackages == null || subpackages.length == 0 || subpackages == packages) {
            subpackages = packages;
            String c = classNameCache.get(cname);
            if (c != null) {
                try {
                    return Class.forName(c, true, this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    log.error("Unable to load cached class-name :  " + c + " for shortname : " + cname + e);
                }
            }
        }
        Class<?> clazz = null;
        try {
            Class<?> e = Class.forName(cname, true, this.classLoader);
            return e;
        }
        catch (ClassNotFoundException e) {
            String newName = cname;
            if (newName.startsWith(project)) {
                newName = cname.substring(project.length() + 1);
            }
            for (String subpackage : subpackages) {
                try {
                    String name = "org.apache.solr." + subpackage + newName;
                    log.trace("Trying class name " + name);
                    Class<?> clazz2 = clazz = Class.forName(name, true, this.classLoader);
                    return clazz2;
                }
                catch (ClassNotFoundException e1) {
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading class '" + cname + "'", (Throwable)e, false);
        }
        finally {
            if (!(clazz == null || clazz.getClassLoader() != SolrResourceLoader.class.getClassLoader() || cname.equals(clazz.getName()) || subpackages.length != 0 && subpackages != packages)) {
                classNameCache.put(cname, clazz.getName());
            }
        }
    }

    public Object newInstance(String cname, String ... subpackages) {
        Class clazz = this.findClass(cname, subpackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cname + " in " + this.classLoader, false);
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e, false);
        }
        if (!this.live) {
            if (obj instanceof SolrCoreAware) {
                this.assertAwareCompatibility(SolrCoreAware.class, obj);
                this.waitingForCore.add(obj);
            }
            if (obj instanceof ResourceLoaderAware) {
                this.assertAwareCompatibility(ResourceLoaderAware.class, obj);
                this.waitingForResources.add(obj);
            }
            if (obj instanceof SolrInfoMBean) {
                this.infoMBeans.add(obj);
            }
        }
        return obj;
    }

    public Object newAdminHandlerInstance(CoreContainer coreContainer, String cname, String ... subpackages) {
        Class clazz = this.findClass(cname, subpackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cname + " in " + this.classLoader, false);
        }
        Object obj = null;
        try {
            Constructor ctor = clazz.getConstructor(CoreContainer.class);
            obj = ctor.newInstance(coreContainer);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e, false);
        }
        if (!this.live && obj instanceof ResourceLoaderAware) {
            this.assertAwareCompatibility(ResourceLoaderAware.class, obj);
            this.waitingForResources.add(obj);
        }
        return obj;
    }

    public Object newInstance(String cName, String[] subPackages, Class[] params, Object[] args) {
        Class clazz = this.findClass(cName, subPackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cName + " in " + this.classLoader, false);
        }
        Object obj = null;
        try {
            Constructor constructor = clazz.getConstructor(params);
            obj = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e, false);
        }
        if (!this.live) {
            if (obj instanceof SolrCoreAware) {
                this.assertAwareCompatibility(SolrCoreAware.class, obj);
                this.waitingForCore.add(obj);
            }
            if (obj instanceof ResourceLoaderAware) {
                this.assertAwareCompatibility(ResourceLoaderAware.class, obj);
                this.waitingForResources.add(obj);
            }
            if (obj instanceof SolrInfoMBean) {
                this.infoMBeans.add(obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(SolrCore core) {
        this.dataDir = core.getDataDir();
        while (this.waitingForCore.size() > 0) {
            SolrCoreAware[] arr;
            List<SolrCoreAware> list = this.waitingForCore;
            synchronized (list) {
                arr = this.waitingForCore.toArray(new SolrCoreAware[this.waitingForCore.size()]);
                this.waitingForCore.clear();
            }
            for (SolrCoreAware aware : arr) {
                aware.inform(core);
            }
        }
        this.live = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(ResourceLoader loader) {
        while (this.waitingForResources.size() > 0) {
            ResourceLoaderAware[] arr;
            List<ResourceLoaderAware> list = this.waitingForResources;
            synchronized (list) {
                arr = this.waitingForResources.toArray(new ResourceLoaderAware[this.waitingForResources.size()]);
                this.waitingForResources.clear();
            }
            for (ResourceLoaderAware aware : arr) {
                aware.inform(loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(Map<String, SolrInfoMBean> infoRegistry) {
        SolrInfoMBean[] arr;
        List<SolrInfoMBean> list = this.infoMBeans;
        synchronized (list) {
            arr = this.infoMBeans.toArray(new SolrInfoMBean[this.infoMBeans.size()]);
            this.waitingForResources.clear();
        }
        for (SolrInfoMBean bean : arr) {
            infoRegistry.put(bean.getName(), bean);
        }
    }

    public static String locateSolrHome() {
        String prop;
        String home = null;
        try {
            InitialContext c = new InitialContext();
            home = (String)c.lookup("java:comp/env/solr/home");
            log.info("Using JNDI solr.home: " + home);
        }
        catch (NoInitialContextException e) {
            log.info("JNDI not configured for solr (NoInitialContextEx)");
        }
        catch (NamingException e) {
            log.info("No /solr/home in JNDI");
        }
        catch (RuntimeException ex) {
            log.warn("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
        }
        if (home == null && (home = System.getProperty(prop = "solr.solr.home")) != null) {
            log.info("using system property " + prop + ": " + home);
        }
        if (home == null) {
            home = "solr/";
            log.info("solr home defaulted to '" + home + "' (could not find system property or JNDI)");
        }
        return SolrResourceLoader.normalizeDir(home);
    }

    @Deprecated
    public static String locateInstanceDir() {
        return SolrResourceLoader.locateSolrHome();
    }

    public String getInstanceDir() {
        return this.instanceDir;
    }

    void assertAwareCompatibility(Class aware, Object obj) {
        Class[] valid = awareCompatibility.get(aware);
        if (valid == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Aware interface: " + aware);
        }
        for (Class v : valid) {
            if (!v.isInstance(obj)) continue;
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Invalid 'Aware' object: ").append(obj);
        builder.append(" -- ").append(aware.getName());
        builder.append(" must be an instance of: ");
        for (Class v : valid) {
            builder.append("[").append(v.getName()).append("] ");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, builder.toString());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    static {
        awareCompatibility.put(SolrCoreAware.class, new Class[]{SolrRequestHandler.class, QueryResponseWriter.class, SearchComponent.class, UpdateRequestProcessorFactory.class});
        awareCompatibility.put(ResourceLoaderAware.class, new Class[]{CharFilterFactory.class, TokenFilterFactory.class, TokenizerFactory.class, QParserPlugin.class, FieldType.class});
    }
}

