/*
 * Decompiled with CFR 0.152.
 */
package org.apache.noggit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.noggit.CharArr;

public abstract class TextWriter {
    public abstract void writeNull();

    public abstract void writeString(CharSequence var1);

    public abstract void writeString(CharArr var1);

    public abstract void writeStringStart();

    public abstract void writeStringChars(CharArr var1);

    public abstract void writeStringEnd();

    public abstract void write(long var1);

    public abstract void write(int var1);

    public void write(short number) {
        this.write((int)number);
    }

    public void write(byte number) {
        this.write((int)number);
    }

    public abstract void write(double var1);

    public abstract void write(float var1);

    public abstract void write(boolean var1);

    public abstract void write(char[] var1);

    public abstract void writeNumber(CharArr var1);

    public abstract void writePartialNumber(CharArr var1);

    public abstract void startObject();

    public abstract void endObject();

    public abstract void startArray();

    public abstract void endArray();

    public abstract void writeValueSeparator();

    public abstract void writeNameSeparator();

    public void write(Object o) {
        if (o == null) {
            this.writeNull();
        } else if (o instanceof CharSequence) {
            this.writeString((CharSequence)o);
        } else if (o instanceof Number) {
            if (o instanceof Integer || o instanceof Long) {
                this.write(((Number)o).longValue());
            } else if (o instanceof Float || o instanceof Double) {
                this.write(((Number)o).doubleValue());
            } else {
                CharArr arr = new CharArr();
                arr.write(o.toString());
                this.writeNumber(arr);
            }
        } else if (o instanceof Map) {
            this.write((Map)o);
        } else if (o instanceof Collection) {
            this.write((Collection)o);
        } else if (o instanceof Object[]) {
            this.write(Arrays.asList((Object[])o));
        } else if (o instanceof Boolean) {
            this.write((Boolean)o);
        } else if (o instanceof int[]) {
            this.write((int[])o);
        } else if (o instanceof float[]) {
            this.write((float[])o);
        } else if (o instanceof long[]) {
            this.write((long[])o);
        } else if (o instanceof double[]) {
            this.write((double[])o);
        } else if (o instanceof short[]) {
            this.write((short[])o);
        } else if (o instanceof boolean[]) {
            this.write((boolean[])o);
        } else if (o instanceof char[]) {
            this.write((char[])o);
        } else if (o instanceof byte[]) {
            this.write((byte[])o);
        } else {
            this.writeString(o.toString());
        }
    }

    public void write(Map val) {
        this.startObject();
        boolean first = true;
        for (Map.Entry entry : val.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.writeString(entry.getKey().toString());
            this.writeNameSeparator();
            this.write(entry.getValue());
        }
        this.endObject();
    }

    public void write(Collection val) {
        this.startArray();
        boolean first = true;
        for (Object o : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(o);
        }
        this.endArray();
    }

    public void write(byte[] val) {
        this.startArray();
        boolean first = true;
        byte[] arr$ = val;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            short v = arr$[i$];
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(short[] val) {
        this.startArray();
        boolean first = true;
        for (short v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(int[] val) {
        this.startArray();
        boolean first = true;
        for (int v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(long[] val) {
        this.startArray();
        boolean first = true;
        for (long v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(float[] val) {
        this.startArray();
        boolean first = true;
        for (float v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(double[] val) {
        this.startArray();
        boolean first = true;
        for (double v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(boolean[] val) {
        this.startArray();
        boolean first = true;
        for (boolean v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }
}

