/*
 * Decompiled with CFR 0.152.
 */
package org.apache.noggit;

import org.apache.noggit.CharArr;
import org.apache.noggit.JSONUtil;
import org.apache.noggit.TextWriter;

public class JSONWriter
extends TextWriter {
    int level;
    boolean doIndent;
    final CharArr out;

    JSONWriter(CharArr out) {
        this.out = out;
    }

    public void writeNull() {
        JSONUtil.writeNull(this.out);
    }

    public void writeString(CharSequence str) {
        JSONUtil.writeString(str, 0, str.length(), this.out);
    }

    public void writeString(CharArr str) {
        JSONUtil.writeString(str, this.out);
    }

    public void writeStringStart() {
        this.out.write('\"');
    }

    public void writeStringChars(CharArr partialStr) {
        JSONUtil.writeStringPart(partialStr.getArray(), partialStr.getStart(), partialStr.getEnd(), this.out);
    }

    public void writeStringEnd() {
        this.out.write('\"');
    }

    public void write(long number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(int number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(double number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(float number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(boolean bool) {
        JSONUtil.writeBoolean(bool, this.out);
    }

    public void write(char[] val) {
        JSONUtil.writeString(val, 0, val.length, this.out);
    }

    public void writeNumber(CharArr digits) {
        this.out.write(digits);
    }

    public void writePartialNumber(CharArr digits) {
        this.out.write(digits);
    }

    public void startObject() {
        this.out.write('{');
        ++this.level;
    }

    public void endObject() {
        this.out.write('}');
        --this.level;
    }

    public void startArray() {
        this.out.write('[');
        ++this.level;
    }

    public void endArray() {
        this.out.write(']');
        --this.level;
    }

    public void writeValueSeparator() {
        this.out.write(',');
    }

    public void writeNameSeparator() {
        this.out.write(':');
    }
}

