/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.h2.command.Parser;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class ScriptCommand
extends ScriptBase {
    private String charset = SysProperties.FILE_ENCODING;
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private LocalResult result;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(Session session) {
        super(session);
    }

    public boolean isQuery() {
        return true;
    }

    public void setData(boolean bl) {
        this.data = bl;
    }

    public void setPasswords(boolean bl) {
        this.passwords = bl;
    }

    public void setSettings(boolean bl) {
        this.settings = bl;
    }

    public void setLobBlockSize(long l) {
        this.lobBlockSize = MathUtils.convertLongToInt(l);
    }

    public void setDrop(boolean bl) {
        this.drop = bl;
    }

    public ResultInterface queryMeta() {
        LocalResult localResult = this.createResult();
        localResult.done();
        return localResult;
    }

    private LocalResult createResult() {
        Expression[] expressionArray = new Expression[]{new ExpressionColumn(this.session.getDatabase(), new Column("SCRIPT", 13))};
        return new LocalResult(this.session, expressionArray, 1);
    }

    /*
     * WARNING - void declaration
     */
    public ResultInterface query(int n) {
        Object object;
        this.session.getUser().checkAdmin();
        this.reset();
        try {
            Object object2;
            Object object3;
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            object = this.session.getDatabase();
            if (this.settings) {
                for (Setting object62 : ((Database)object).getAllSettings()) {
                    if (object62.getName().equals(SetTypes.getTypeName(34))) continue;
                    this.add(object62.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            for (User user : ((Database)object).getAllUsers()) {
                this.add(user.getCreateSQL(this.passwords, true), false);
            }
            for (Role role : ((Database)object).getAllRoles()) {
                this.add(role.getCreateSQL(true), false);
            }
            for (Schema schema : ((Database)object).getAllSchemas()) {
                this.add(schema.getCreateSQL(), false);
            }
            for (UserDataType userDataType : ((Database)object).getAllUserDataTypes()) {
                if (this.drop) {
                    this.add(userDataType.getDropSQL(), false);
                }
                this.add(userDataType.getCreateSQL(), false);
            }
            for (SchemaObject schemaObject : ((Database)object).getAllSchemaObjects(11)) {
                Constant constant = (Constant)schemaObject;
                this.add(constant.getCreateSQL(), false);
            }
            for (SchemaObject schemaObject : ((Database)object).getAllSchemaObjects(9)) {
                if (this.drop) {
                    this.add(schemaObject.getDropSQL(), false);
                }
                this.add(schemaObject.getCreateSQL(), false);
            }
            for (UserAggregate userAggregate : ((Database)object).getAllAggregates()) {
                if (this.drop) {
                    this.add(userAggregate.getDropSQL(), false);
                }
                this.add(userAggregate.getCreateSQL(), false);
            }
            ArrayList<Table> arrayList = ((Database)object).getAllTablesAndViews(false);
            Collections.sort(arrayList, new Comparator<Table>(){

                @Override
                public int compare(Table table, Table table2) {
                    return table.getId() - table2.getId();
                }
            });
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (table.isHidden()) continue;
                table.lock(this.session, false, false);
                object3 = table.getCreateSQL();
                if (object3 == null || !this.drop) continue;
                this.add(table.getDropSQL(), false);
            }
            for (SchemaObject schemaObject : ((Database)object).getAllSchemaObjects(3)) {
                object3 = (Sequence)schemaObject;
                if (this.drop) {
                    this.add(((Sequence)object3).getDropSQL(), false);
                }
                this.add(((Sequence)object3).getCreateSQL(), false);
            }
            boolean bl = false;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                void var11_44;
                Object object4;
                Object object5;
                object3 = (Table)iterator2.next();
                if (((Table)object3).isHidden()) continue;
                ((Table)object3).lock(this.session, false, false);
                String string = ((DbObjectBase)object3).getCreateSQL();
                if (string == null) continue;
                object2 = ((Table)object3).getTableType();
                this.add(string, false);
                ArrayList<Constraint> arrayList2 = ((Table)object3).getConstraints();
                if (arrayList2 != null) {
                    for (Constraint constraint : arrayList2) {
                        if (!"PRIMARY KEY".equals(constraint.getConstraintType())) continue;
                        this.add(constraint.getCreateSQLWithoutIndexes(), false);
                    }
                }
                if ("TABLE".equals(object2)) {
                    if (((Table)object3).canGetRowCount()) {
                        object5 = "-- " + ((Table)object3).getRowCountApproximation() + " +/- SELECT COUNT(*) FROM " + ((SchemaObjectBase)object3).getSQL();
                        this.add((String)object5, false);
                    }
                    if (this.data) {
                        int n2;
                        object5 = ((Table)object3).getBestPlanItem(this.session, null);
                        Index index = ((PlanItem)object5).getIndex();
                        object4 = index.find(this.session, null, null);
                        Column[] columnArray = ((Table)object3).getColumns();
                        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
                        statementBuilder.append(((SchemaObjectBase)object3).getSQL()).append('(');
                        Column[] columnArray2 = columnArray;
                        int n3 = columnArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            Column column = columnArray2[n2];
                            statementBuilder.appendExceptFirst(", ");
                            statementBuilder.append(Parser.quoteIdentifier(column.getName()));
                        }
                        statementBuilder.append(") VALUES");
                        if (!this.simple) {
                            statementBuilder.append('\n');
                        }
                        statementBuilder.append('(');
                        String string2 = statementBuilder.toString();
                        statementBuilder = null;
                        while (object4.next()) {
                            void var4_23;
                            Row row = object4.get();
                            if (statementBuilder == null) {
                                statementBuilder = new StatementBuilder(string2);
                            } else {
                                statementBuilder.append(",\n(");
                            }
                            for (n2 = 0; n2 < row.getColumnCount(); ++n2) {
                                Value value;
                                if (n2 > 0) {
                                    statementBuilder.append(", ");
                                }
                                if ((value = row.getValue(n2)).getPrecision() > (long)this.lobBlockSize) {
                                    int n4;
                                    if (value.getType() == 16) {
                                        n4 = this.writeLobStream(value);
                                        statementBuilder.append("SYSTEM_COMBINE_CLOB(" + n4 + ")");
                                        continue;
                                    }
                                    if (value.getType() == 15) {
                                        n4 = this.writeLobStream(value);
                                        statementBuilder.append("SYSTEM_COMBINE_BLOB(" + n4 + ")");
                                        continue;
                                    }
                                    statementBuilder.append(value.getSQL());
                                    continue;
                                }
                                statementBuilder.append(value.getSQL());
                            }
                            statementBuilder.append(')');
                            if ((++var4_23 & 0x7F) == 0) {
                                this.checkCanceled();
                            }
                            if (!this.simple && statementBuilder.length() <= 4096) continue;
                            this.add(statementBuilder.toString(), true);
                            statementBuilder = null;
                        }
                        if (statementBuilder != null) {
                            this.add(statementBuilder.toString(), true);
                        }
                    }
                }
                object5 = ((Table)object3).getIndexes();
                boolean bl2 = false;
                while (object5 != null && var11_44 < ((ArrayList)object5).size()) {
                    object4 = (Index)((ArrayList)object5).get((int)var11_44);
                    if (!object4.getIndexType().getBelongsToConstraint()) {
                        this.add(object4.getCreateSQL(), false);
                    }
                    ++var11_44;
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("CALL SYSTEM_COMBINE_BLOB(-1)", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            ArrayList<SchemaObject> arrayList3 = ((Database)object).getAllSchemaObjects(5);
            Collections.sort(arrayList3, new Comparator<SchemaObject>(){

                @Override
                public int compare(SchemaObject schemaObject, SchemaObject schemaObject2) {
                    return ((Constraint)schemaObject).compareTo((Constraint)schemaObject2);
                }
            });
            for (SchemaObject schemaObject : arrayList3) {
                object2 = (Constraint)schemaObject;
                if (((Constraint)object2).getTable().isHidden() || "PRIMARY KEY".equals(((Constraint)object2).getConstraintType())) continue;
                this.add(((Constraint)object2).getCreateSQLWithoutIndexes(), false);
            }
            for (SchemaObject schemaObject : ((Database)object).getAllSchemaObjects(4)) {
                object2 = (TriggerObject)schemaObject;
                this.add(((TriggerObject)object2).getCreateSQL(), false);
            }
            for (Right right : ((Database)object).getAllRights()) {
                this.add(right.getCreateSQL(), false);
            }
            for (Comment comment : ((Database)object).getAllComments()) {
                this.add(comment.getCreateSQL(), false);
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.getFileName());
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        object = this.result;
        this.reset();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLobStream(Value value) throws IOException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA BINARY)", true);
            this.add("CREATE PRIMARY KEY SYSTEM_LOB_STREAM_PRIMARY_KEY ON SYSTEM_LOB_STREAM(ID, PART)", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR \"" + this.getClass().getName() + ".combineClob\"", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR \"" + this.getClass().getName() + ".combineBlob\"", true);
            this.tempLobTableCreated = true;
        }
        int n = this.nextLobId++;
        block2 : switch (value.getType()) {
            case 15: {
                byte[] byArray = new byte[this.lobBlockSize];
                InputStream inputStream = value.getInputStream();
                try {
                    int n2 = 0;
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder(this.lobBlockSize * 2);
                        stringBuilder.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + n + ", " + n2 + ", NULL, '");
                        int n3 = IOUtils.readFully(inputStream, byArray, 0, this.lobBlockSize);
                        if (n3 <= 0) {
                            break block2;
                        }
                        stringBuilder.append(StringUtils.convertBytesToString(byArray, n3)).append("')");
                        String string = stringBuilder.toString();
                        this.add(string, true);
                        ++n2;
                    }
                }
                finally {
                    IOUtils.closeSilently(inputStream);
                }
            }
            case 16: {
                char[] cArray = new char[this.lobBlockSize];
                Reader reader = value.getReader();
                try {
                    int n4 = 0;
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder(this.lobBlockSize * 2);
                        stringBuilder.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + n + ", " + n4 + ", ");
                        int n5 = IOUtils.readFully(reader, cArray, this.lobBlockSize);
                        if (n5 < 0) {
                            break block2;
                        }
                        stringBuilder.append(StringUtils.quoteStringSQL(new String(cArray, 0, n5))).append(", NULL)");
                        String string = stringBuilder.toString();
                        this.add(string, true);
                        ++n4;
                    }
                }
                finally {
                    IOUtils.closeSilently(reader);
                }
            }
            default: {
                DbException.throwInternalError("type:" + value.getType());
            }
        }
        return n;
    }

    public static InputStream combineBlob(Connection connection, int n) throws SQLException {
        if (n < 0) {
            return null;
        }
        final ResultSet resultSet = ScriptCommand.getLobStream(connection, "BDATA", n);
        return new InputStream(){
            private InputStream current;
            private boolean closed;

            public int read() throws IOException {
                try {
                    while (true) {
                        int n;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!resultSet.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = resultSet.getBinaryStream(1);
                            this.current = new BufferedInputStream(this.current);
                        }
                        if ((n = this.current.read()) >= 0) {
                            return n;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }

            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }
        };
    }

    public static Reader combineClob(Connection connection, int n) throws SQLException {
        if (n < 0) {
            return null;
        }
        final ResultSet resultSet = ScriptCommand.getLobStream(connection, "CDATA", n);
        return new Reader(){
            private Reader current;
            private boolean closed;

            public int read() throws IOException {
                try {
                    while (true) {
                        int n;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!resultSet.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = resultSet.getCharacterStream(1);
                            this.current = new BufferedReader(this.current);
                        }
                        if ((n = this.current.read()) >= 0) {
                            return n;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }

            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                if (n2 == 0) {
                    return 0;
                }
                int n4 = this.read();
                if (n4 == -1) {
                    return -1;
                }
                cArray[n] = (char)n4;
                for (n3 = 1; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
                    cArray[n + n3] = (char)n4;
                }
                return n3;
            }
        };
    }

    private static ResultSet getLobStream(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT " + string + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        preparedStatement.setInt(1, n);
        return preparedStatement.executeQuery();
    }

    private void reset() {
        this.result = null;
        this.buffer = null;
        try {
            this.lineSeparator = SysProperties.LINE_SEPARATOR.getBytes(this.charset);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private void add(String string, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        string = string + ";";
        if (this.out != null) {
            int n;
            byte[] byArray = string.getBytes(this.charset);
            int n2 = MathUtils.roundUpInt(byArray.length + this.lineSeparator.length, 16);
            this.buffer = Utils.copy(byArray, this.buffer);
            if (n2 > this.buffer.length) {
                this.buffer = new byte[n2];
            }
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            for (n = byArray.length; n < n2 - this.lineSeparator.length; ++n) {
                this.buffer[n] = 32;
            }
            n = 0;
            int n3 = n2 - this.lineSeparator.length;
            while (n3 < n2) {
                this.buffer[n3] = this.lineSeparator[n];
                ++n3;
                ++n;
            }
            this.out.write(this.buffer, 0, n2);
            if (!bl) {
                Value[] valueArray = new Value[]{ValueString.get(string)};
                this.result.addRow(valueArray);
            }
        } else {
            Value[] valueArray = new Value[]{ValueString.get(string)};
            this.result.addRow(valueArray);
        }
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public int getType() {
        return 65;
    }
}

