/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.ValueSourceScorer;

public class LongFieldSource
extends FieldCacheSource {
    protected FieldCache.LongParser parser;

    public LongFieldSource(String field) {
        this(field, null);
    }

    public LongFieldSource(String field, FieldCache.LongParser parser) {
        super(field);
        this.parser = parser;
    }

    public String description() {
        return "long(" + this.field + ')';
    }

    public long externalToLong(String extVal) {
        return Long.parseLong(extVal);
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final long[] arr = this.parser == null ? this.cache.getLongs(reader, this.field) : this.cache.getLongs(reader, this.field, this.parser);
        return new DocValues(){

            public float floatVal(int doc) {
                return arr[doc];
            }

            public int intVal(int doc) {
                return (int)arr[doc];
            }

            public long longVal(int doc) {
                return arr[doc];
            }

            public double doubleVal(int doc) {
                return arr[doc];
            }

            public String strVal(int doc) {
                return Long.toString(arr[doc]);
            }

            public String toString(int doc) {
                return LongFieldSource.this.description() + '=' + this.longVal(doc);
            }

            public ValueSourceScorer getRangeScorer(IndexReader reader, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
                long upper;
                long lower;
                if (lowerVal == null) {
                    lower = Long.MIN_VALUE;
                } else {
                    lower = LongFieldSource.this.externalToLong(lowerVal);
                    if (!includeLower && lower < Long.MAX_VALUE) {
                        ++lower;
                    }
                }
                if (upperVal == null) {
                    upper = Long.MAX_VALUE;
                } else {
                    upper = LongFieldSource.this.externalToLong(upperVal);
                    if (!includeUpper && upper > Long.MIN_VALUE) {
                        --upper;
                    }
                }
                final long ll = lower;
                final long uu = upper;
                return new ValueSourceScorer(reader, this){

                    public boolean matchesValue(int doc) {
                        long val = arr[doc];
                        return val >= ll && val <= uu;
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        LongFieldSource other = (LongFieldSource)o;
        return super.equals(other) && this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    public int hashCode() {
        int h = this.parser == null ? this.getClass().hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

