/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.BoundedTreeSet;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;

public class SimpleFacets {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;
    protected ResponseBuilder rb;
    SolrParams localParams;
    String facetValue;
    DocSet base;
    String key;
    private static final Comparator nullStrComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    };

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this(req, docs, params, null);
    }

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.base = this.docs = docs;
        this.params = params;
        this.rb = rb;
    }

    void parseParams(String type, String param) throws ParseException, IOException {
        this.localParams = QueryParsing.getLocalParams(param, this.req.getParams());
        this.base = this.docs;
        this.facetValue = param;
        this.key = param;
        if (this.localParams == null) {
            return;
        }
        if (type != "facet.query") {
            this.facetValue = this.localParams.get("v");
        }
        this.key = this.facetValue;
        this.key = this.localParams.get("key", this.key);
        String excludeStr = this.localParams.get("ex");
        if (excludeStr == null) {
            return;
        }
        Map tagMap = (Map)this.req.getContext().get("tags");
        if (tagMap != null && this.rb != null) {
            List excludeTagList = StrUtils.splitSmart((String)excludeStr, (char)',');
            IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
            for (String excludeTag : excludeTagList) {
                Object olst = tagMap.get(excludeTag);
                if (!(olst instanceof Collection)) continue;
                for (Object o : (Collection)olst) {
                    if (!(o instanceof QParser)) continue;
                    QParser qp = (QParser)o;
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
            }
            if (excludeSet.size() == 0) {
                return;
            }
            ArrayList<Query> qlist = new ArrayList<Query>();
            qlist.add(this.rb.getQuery());
            for (Query q : this.rb.getFilters()) {
                if (excludeSet.containsKey(q)) continue;
                qlist.add(q);
            }
            this.base = this.searcher.getDocSet(qlist);
        }
    }

    public NamedList getFacetCounts() {
        if (!this.params.getBool("facet", true)) {
            return null;
        }
        SimpleOrderedMap res = new SimpleOrderedMap();
        try {
            res.add("facet_queries", (Object)this.getFacetQueryCounts());
            res.add("facet_fields", (Object)this.getFacetFieldCounts());
            res.add("facet_dates", (Object)this.getFacetDateCounts());
        }
        catch (Exception e) {
            SolrException.logOnce((Logger)SolrCore.log, (String)"Exception during facet counts", (Throwable)e);
            res.add("exception", (Object)SolrException.toStr((Throwable)e));
        }
        return res;
    }

    public NamedList getFacetQueryCounts() throws IOException, ParseException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetQs = this.params.getParams("facet.query");
        if (null != facetQs && 0 != facetQs.length) {
            for (String q : facetQs) {
                this.parseParams("facet.query", q);
                Query qobj = QParser.getParser(q, null, this.req).getQuery();
                res.add(this.key, (Object)this.searcher.numDocs(qobj, this.base));
            }
        }
        return res;
    }

    public NamedList getTermCounts(String field) throws IOException {
        NamedList counts;
        boolean multiToken;
        int offset = this.params.getFieldInt(field, "facet.offset", 0);
        int limit = this.params.getFieldInt(field, "facet.limit", 100);
        if (limit == 0) {
            return new NamedList();
        }
        Integer mincount = this.params.getFieldInt(field, "facet.mincount");
        if (mincount == null) {
            Boolean zeros = this.params.getFieldBool(field, "facet.zeros");
            mincount = zeros != null && zeros == false ? 1 : 0;
        }
        boolean missing = this.params.getFieldBool(field, "facet.missing", false);
        String sort = this.params.getFieldParam(field, "facet.sort", limit > 0 ? "count" : "index");
        String prefix = this.params.getFieldParam(field, "facet.prefix");
        SchemaField sf = this.searcher.getSchema().getField(field);
        FieldType ft = sf.getType();
        String method = this.params.getFieldParam(field, "facet.method");
        boolean enumMethod = "enum".equals(method);
        if (method == null && ft instanceof BoolField) {
            enumMethod = true;
        }
        boolean bl = multiToken = sf.multiValued() || ft.multiValuedFieldCache();
        if (TrieField.getMainValuePrefix(ft) != null) {
            enumMethod = false;
            multiToken = true;
        }
        if (enumMethod) {
            counts = this.getFacetTermEnumCounts(this.searcher, this.base, field, offset, limit, mincount, missing, sort, prefix);
        } else if (multiToken) {
            UnInvertedField uif = UnInvertedField.getUnInvertedField(field, this.searcher);
            counts = uif.getCounts(this.searcher, this.base, offset, limit, mincount, missing, sort, prefix);
        } else {
            counts = SimpleFacets.getFieldCacheCounts(this.searcher, this.base, field, offset, limit, mincount, missing, sort, prefix);
        }
        return counts;
    }

    public NamedList getFacetFieldCounts() throws IOException, ParseException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetFs = this.params.getParams("facet.field");
        if (null != facetFs) {
            for (String f : facetFs) {
                String termList;
                this.parseParams("facet.field", f);
                String string = termList = this.localParams == null ? null : this.localParams.get("terms");
                if (termList != null) {
                    res.add(this.key, (Object)this.getListedTermCounts(this.facetValue, termList));
                    continue;
                }
                res.add(this.key, (Object)this.getTermCounts(this.facetValue));
            }
        }
        return res;
    }

    private NamedList getListedTermCounts(String field, String termList) throws IOException {
        FieldType ft = this.searcher.getSchema().getFieldType(field);
        List terms = StrUtils.splitSmart((String)termList, (String)",", (boolean)true);
        NamedList res = new NamedList();
        Term t = new Term(field);
        for (String term : terms) {
            String internal = ft.toInternal(term);
            int count = this.searcher.numDocs((Query)new TermQuery(t.createTerm(internal)), this.base);
            res.add(term, (Object)count);
        }
        return res;
    }

    public static int getFieldMissingCount(SolrIndexSearcher searcher, DocSet docs, String fieldName) throws IOException {
        DocSet hasVal = searcher.getDocSet((Query)new TermRangeQuery(fieldName, null, null, false, false));
        return docs.andNotSize(hasVal);
    }

    public static NamedList getFieldCacheCounts(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix) throws IOException {
        int endTermIndex;
        int startTermIndex;
        FieldType ft = searcher.getSchema().getFieldType(fieldName);
        NamedList res = new NamedList();
        FieldCache.StringIndex si = FieldCache.DEFAULT.getStringIndex((IndexReader)searcher.getReader(), fieldName);
        String[] terms = si.lookup;
        int[] termNum = si.order;
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        if (prefix != null) {
            startTermIndex = Arrays.binarySearch(terms, prefix, nullStrComparator);
            if (startTermIndex < 0) {
                startTermIndex = -startTermIndex - 1;
            }
            endTermIndex = Arrays.binarySearch(terms, prefix + "\uffff\uffff\uffff\uffff", nullStrComparator);
            endTermIndex = -endTermIndex - 1;
        } else {
            startTermIndex = 1;
            endTermIndex = terms.length;
        }
        int nTerms = endTermIndex - startTermIndex;
        if (nTerms > 0 && docs.size() >= mincount) {
            int lim;
            int[] counts = new int[nTerms];
            DocIterator iter = docs.iterator();
            while (iter.hasNext()) {
                int term = termNum[iter.nextDoc()];
                int arrIdx = term - startTermIndex;
                if (arrIdx < 0 || arrIdx >= nTerms) continue;
                int n = arrIdx;
                counts[n] = counts[n] + 1;
            }
            int off = offset;
            int n = lim = limit >= 0 ? limit : Integer.MAX_VALUE;
            if (sort.equals("count") || sort.equals("true")) {
                int maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
                maxsize = Math.min(maxsize, nTerms);
                BoundedTreeSet<CountPair<String, Integer>> queue = new BoundedTreeSet<CountPair<String, Integer>>(maxsize);
                int min = mincount - 1;
                for (int i = 0; i < nTerms; ++i) {
                    int n2 = counts[i];
                    if (n2 <= min) continue;
                    queue.add(new CountPair<String, Integer>(terms[startTermIndex + i], n2));
                    if (queue.size() < maxsize) continue;
                    min = (Integer)((CountPair)queue.last()).val;
                }
                for (CountPair countPair : queue) {
                    if (--off >= 0) continue;
                    if (--lim >= 0) {
                        res.add(ft.indexedToReadable((String)countPair.key), countPair.val);
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                if (mincount <= 0) {
                    i = off;
                    off = 0;
                }
                while (i < nTerms) {
                    int c = counts[i];
                    if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        res.add(ft.indexedToReadable(terms[startTermIndex + i]), (Object)c);
                    }
                    ++i;
                }
            }
        }
        if (missing) {
            res.add(null, (Object)SimpleFacets.getFieldMissingCount(searcher, docs, fieldName));
        }
        return res;
    }

    public NamedList getFacetTermEnumCounts(SolrIndexSearcher searcher, DocSet docs, String field, int offset, int limit, int mincount, boolean missing, String sort, String prefix) throws IOException {
        int minDfFilterCache = this.params.getFieldInt(field, "facet.enum.cache.minDf", 0);
        IndexSchema schema = searcher.getSchema();
        SolrIndexReader r = searcher.getReader();
        FieldType ft = schema.getFieldType(field);
        int maxsize = limit >= 0 ? offset + limit : 0x7FFFFFFE;
        BoundedTreeSet<CountPair<String, Integer>> queue = sort.equals("count") || sort.equals("true") ? new BoundedTreeSet<CountPair<String, Integer>>(maxsize) : null;
        NamedList res = new NamedList();
        int min = mincount - 1;
        int off = offset;
        int lim = limit >= 0 ? limit : Integer.MAX_VALUE;
        String startTerm = prefix == null ? "" : ft.toInternal(prefix);
        TermEnum te = r.terms(new Term(field, startTerm));
        TermDocs td = r.termDocs();
        if (docs.size() >= mincount) {
            Term t;
            while (null != (t = te.term()) && t.field().equals(field) && (prefix == null || t.text().startsWith(prefix))) {
                int n = te.docFreq();
                if (n > 0 && n > min) {
                    int c;
                    if (n >= minDfFilterCache) {
                        c = searcher.numDocs((Query)new TermQuery(t), docs);
                    } else {
                        td.seek(te);
                        c = 0;
                        while (td.next()) {
                            if (!docs.exists(td.doc())) continue;
                            ++c;
                        }
                    }
                    if (sort.equals("count") || sort.equals("true")) {
                        if (c > min) {
                            queue.add(new CountPair<String, Integer>(t.text(), c));
                            if (queue.size() >= maxsize) {
                                min = (Integer)((CountPair)queue.last()).val;
                            }
                        }
                    } else if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        res.add(ft.indexedToReadable(t.text()), (Object)c);
                    }
                }
                if (te.next()) continue;
            }
        }
        if (sort.equals("count") || sort.equals("true")) {
            for (CountPair countPair : queue) {
                if (--off >= 0) continue;
                if (--lim < 0) break;
                res.add(ft.indexedToReadable((String)countPair.key), countPair.val);
            }
        }
        if (missing) {
            res.add(null, (Object)SimpleFacets.getFieldMissingCount(searcher, docs, field));
        }
        te.close();
        td.close();
        return res;
    }

    public NamedList getFacetDateCounts() throws IOException, ParseException {
        RequiredSolrParams required = new RequiredSolrParams(this.params);
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.date");
        Date NOW = new Date();
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        IndexSchema schema = this.searcher.getSchema();
        for (String f : fields) {
            Date end;
            Date start;
            this.parseParams("facet.date", f);
            f = this.facetValue;
            SimpleOrderedMap resInner = new SimpleOrderedMap();
            resOuter.add(this.key, (Object)resInner);
            SchemaField sf = schema.getField(f);
            if (!(sf.getType() instanceof DateField)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not date facet on a field which is not a DateField: " + f);
            }
            DateField ft = (DateField)sf.getType();
            String startS = required.getFieldParam(f, "facet.date.start");
            try {
                start = ft.parseMath(NOW, startS);
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'start' is not a valid Date string: " + startS, (Throwable)e);
            }
            String endS = required.getFieldParam(f, "facet.date.end");
            try {
                end = ft.parseMath(NOW, endS);
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' is not a valid Date string: " + endS, (Throwable)e);
            }
            if (end.before(start)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' comes before 'start': " + endS + " < " + startS);
            }
            String gap = required.getFieldParam(f, "facet.date.gap");
            DateMathParser dmp = new DateMathParser(DateField.UTC, Locale.US);
            dmp.setNow(NOW);
            try {
                Date low = start;
                while (low.before(end)) {
                    dmp.setNow(low);
                    String label = ft.toExternal(low);
                    Date high = dmp.parseMath(gap);
                    if (end.before(high)) {
                        if (this.params.getFieldBool(f, "facet.date.hardend", false)) {
                            high = end;
                        } else {
                            end = high;
                        }
                    }
                    if (high.before(low)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop (is gap negative?)");
                    }
                    resInner.add(label, (Object)this.rangeCount(sf, low, high, true, true));
                    low = high;
                }
            }
            catch (java.text.ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'gap' is not a valid Date Math string: " + gap, (Throwable)e);
            }
            resInner.add("gap", (Object)gap);
            resInner.add("end", (Object)end);
            String[] othersP = this.params.getFieldParams(f, "facet.date.other");
            if (null == othersP || 0 >= othersP.length) continue;
            EnumSet<FacetParams.FacetDateOther> others = EnumSet.noneOf(FacetParams.FacetDateOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetDateOther.get((String)o));
            }
            if (others.contains(FacetParams.FacetDateOther.NONE)) continue;
            boolean all = others.contains(FacetParams.FacetDateOther.ALL);
            if (all || others.contains(FacetParams.FacetDateOther.BEFORE)) {
                resInner.add(FacetParams.FacetDateOther.BEFORE.toString(), (Object)this.rangeCount(sf, null, start, false, false));
            }
            if (all || others.contains(FacetParams.FacetDateOther.AFTER)) {
                resInner.add(FacetParams.FacetDateOther.AFTER.toString(), (Object)this.rangeCount(sf, end, null, false, false));
            }
            if (!all && !others.contains(FacetParams.FacetDateOther.BETWEEN)) continue;
            resInner.add(FacetParams.FacetDateOther.BETWEEN.toString(), (Object)this.rangeCount(sf, start, end, true, true));
        }
        return resOuter;
    }

    protected int rangeCount(SchemaField sf, String low, String high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = sf.getType().getRangeQuery(null, sf, low, high, iLow, iHigh);
        return this.searcher.numDocs(rangeQ, this.base);
    }

    protected int rangeCount(SchemaField sf, Date low, Date high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = ((DateField)sf.getType()).getRangeQuery(null, sf, low, high, iLow, iHigh);
        return this.searcher.numDocs(rangeQ, this.base);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CountPair<K extends Comparable<? super K>, V extends Comparable<? super V>>
    implements Comparable<CountPair<K, V>> {
        public K key;
        public V val;

        public CountPair(K k, V v) {
            this.key = k;
            this.val = v;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof CountPair && 0 == this.compareTo((CountPair)o);
        }

        @Override
        public int compareTo(CountPair<K, V> o) {
            int vc = o.val.compareTo(this.val);
            return 0 != vc ? vc : this.key.compareTo(o.key);
        }
    }
}

