/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.mobylet.core.config.enums.ConfigKeyword;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class ConfigUtils {
    public static final Pattern PAT_VARIABLE = Pattern.compile("[$]{1}[{]{1}[a-zA-Z0-9_.]+[}]{1}");

    public static String parseValue(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        FilterConfig filterConfig = SingletonUtils.get(FilterConfig.class);
        ServletContext servletContext = SingletonUtils.get(ServletContext.class);
        Matcher matcher = PAT_VARIABLE.matcher(value);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            Object obj;
            String matchedSeq = matcher.group();
            String word = matchedSeq.substring(2, matchedSeq.length() - 1);
            String parsedVal = "";
            if (filterConfig != null) {
                parsedVal = filterConfig.getInitParameter(word);
            }
            if (StringUtils.isEmpty(parsedVal) && servletContext != null && StringUtils.isEmpty(parsedVal = ConfigUtils.getKeywordValue(word, servletContext)) && (obj = servletContext.getAttribute(word)) != null) {
                parsedVal = obj.toString();
            }
            if (StringUtils.isEmpty(parsedVal)) {
                parsedVal = System.getProperty(word);
            }
            if (StringUtils.isNotEmpty(parsedVal)) {
                parsedVal = StringUtils.escape(parsedVal);
            }
            if (parsedVal == null) {
                matcher.appendReplacement(buf, "\\" + matchedSeq);
                MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
                if (logger == null || !logger.isLoggable()) continue;
                logger.log("[mobylet] InjectionConfig - \u5024\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u5909\u6570  = " + matchedSeq);
                continue;
            }
            matcher.appendReplacement(buf, parsedVal);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    protected static String getKeywordValue(String value, ServletContext servletContext) {
        block10: for (ConfigKeyword keyword : ConfigKeyword.values()) {
            if (!value.equals(keyword.getKeyword())) continue;
            switch (keyword) {
                case CONTEXT_PATH: {
                    MobyletLogger logger;
                    try {
                        Method method = ServletContext.class.getMethod("getContextPath", new Class[0]);
                        Object obj = method.invoke((Object)servletContext, new Object[0]);
                        if (obj == null) continue block10;
                        return obj.toString();
                    }
                    catch (SecurityException e) {
                        logger = SingletonUtils.get(MobyletLogger.class);
                        if (logger == null || !logger.isLoggable()) continue block10;
                        logger.log("[mobylet] ContextPath\u5909\u6570\u5024\u3092\u53d6\u5f97\u6642\u306b\u4f8b\u5916\u767a\u751f = " + e);
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        logger = SingletonUtils.get(MobyletLogger.class);
                        if (logger == null || !logger.isLoggable()) continue block10;
                        logger.log("[mobylet] ContextPath\u5909\u6570\u5024\u3092\u53d6\u5f97\u6642\u306b\u4f8b\u5916\u767a\u751f = " + e);
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        logger = SingletonUtils.get(MobyletLogger.class);
                        if (logger == null || !logger.isLoggable()) continue block10;
                        logger.log("[mobylet] ContextPath\u5909\u6570\u5024\u3092\u53d6\u5f97\u6642\u306b\u4f8b\u5916\u767a\u751f = " + e);
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        logger = SingletonUtils.get(MobyletLogger.class);
                        if (logger == null || !logger.isLoggable()) continue block10;
                        logger.log("[mobylet] ContextPath\u5909\u6570\u5024\u3092\u53d6\u5f97\u6642\u306b\u4f8b\u5916\u767a\u751f = " + e);
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        logger = SingletonUtils.get(MobyletLogger.class);
                        if (logger == null || !logger.isLoggable()) continue block10;
                        logger.log("[mobylet] ContextPath\u5909\u6570\u5024\u3092\u53d6\u5f97\u6642\u306b\u4f8b\u5916\u767a\u751f = " + e);
                        e.printStackTrace();
                    }
                    continue block10;
                }
                case DOC_BASE: {
                    return servletContext.getRealPath("");
                }
            }
        }
        return null;
    }
}

