/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.db.allcommon;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;
import org.seasar.robot.dbflute.exception.DBMetaNotFoundException;
import org.seasar.robot.dbflute.helper.StringKeyMap;
import org.seasar.robot.dbflute.util.DfAssertUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBMetaInstanceHandler
implements DBMetaProvider {
    protected static final Map<String, DBMeta> _tableDbNameInstanceMap = DBMetaInstanceHandler.newHashMap();
    protected static final Map<String, String> _tableDbNameClassNameMap;
    protected static final Map<String, String> _tableDbNameFlexibleMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DBMeta> getUnmodifiableDBMetaMap() {
        DBMetaInstanceHandler.initializeDBMetaMap();
        Map<String, DBMeta> map = _tableDbNameInstanceMap;
        synchronized (map) {
            return Collections.unmodifiableMap(_tableDbNameInstanceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initializeDBMetaMap() {
        if (DBMetaInstanceHandler.isInitialized()) {
            return;
        }
        Map<String, DBMeta> map = _tableDbNameInstanceMap;
        synchronized (map) {
            Set<String> tableDbNameSet = _tableDbNameClassNameMap.keySet();
            for (String tableDbName : tableDbNameSet) {
                DBMetaInstanceHandler.findDBMeta(tableDbName);
            }
            if (!DBMetaInstanceHandler.isInitialized()) {
                String msg = "Failed to initialize tableDbNameInstanceMap:";
                msg = msg + " tableDbNameInstanceMap=" + _tableDbNameInstanceMap;
                throw new IllegalStateException(msg);
            }
        }
    }

    protected static boolean isInitialized() {
        return _tableDbNameInstanceMap.size() == _tableDbNameClassNameMap.size();
    }

    public static DBMeta findDBMeta(String tableFlexibleName) {
        DBMeta dbmeta = DBMetaInstanceHandler.byTableFlexibleName(tableFlexibleName);
        if (dbmeta == null) {
            String msg = "The DB meta was not found by the table flexible name: " + tableFlexibleName;
            msg = msg + " key=" + tableFlexibleName + " instanceMap=" + _tableDbNameInstanceMap;
            throw new DBMetaNotFoundException(msg);
        }
        return dbmeta;
    }

    protected static DBMeta byTableFlexibleName(String tableFlexibleName) {
        String tableDbName;
        DBMetaInstanceHandler.assertStringNotNullAndNotTrimmedEmpty("tableFlexibleName", tableFlexibleName);
        int dotLastIndex = tableFlexibleName.lastIndexOf(".");
        if (dotLastIndex >= 0) {
            tableFlexibleName = tableFlexibleName.substring(dotLastIndex + ".".length());
        }
        if ((tableDbName = _tableDbNameFlexibleMap.get(tableFlexibleName)) != null) {
            return DBMetaInstanceHandler.byTableDbName(tableDbName);
        }
        return null;
    }

    protected static DBMeta byTableDbName(String tableDbName) {
        DBMetaInstanceHandler.assertStringNotNullAndNotTrimmedEmpty("tableDbName", tableDbName);
        return DBMetaInstanceHandler.getCachedDBMeta(tableDbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DBMeta getCachedDBMeta(String tableName) {
        DBMeta dbmeta = _tableDbNameInstanceMap.get(tableName);
        if (dbmeta != null) {
            return dbmeta;
        }
        Map<String, DBMeta> map = _tableDbNameInstanceMap;
        synchronized (map) {
            dbmeta = _tableDbNameInstanceMap.get(tableName);
            if (dbmeta != null) {
                return dbmeta;
            }
            String entityName = _tableDbNameClassNameMap.get(tableName);
            _tableDbNameInstanceMap.put(tableName, DBMetaInstanceHandler.getDBMeta(entityName));
            return _tableDbNameInstanceMap.get(tableName);
        }
    }

    protected static DBMeta getDBMeta(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Method methoz = clazz.getMethod("getInstance", null);
            Object result = methoz.invoke(null, (Object[])null);
            return (DBMeta)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DBMeta provideDBMeta(String tableFlexibleName) {
        return DBMetaInstanceHandler.byTableFlexibleName(tableFlexibleName);
    }

    public DBMeta provideDBMetaChecked(String tableFlexibleName) {
        return DBMetaInstanceHandler.findDBMeta(tableFlexibleName);
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull((String)variableName, (Object)value);
    }

    protected static void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty((String)variableName, (String)value);
    }

    static {
        HashMap tmpMap = DBMetaInstanceHandler.newHashMap();
        tmpMap.put("ACCESS_RESULT", "org.seasar.robot.db.bsentity.dbmeta.AccessResultDbm");
        tmpMap.put("ACCESS_RESULT_DATA", "org.seasar.robot.db.bsentity.dbmeta.AccessResultDataDbm");
        tmpMap.put("URL_FILTER", "org.seasar.robot.db.bsentity.dbmeta.UrlFilterDbm");
        tmpMap.put("URL_QUEUE", "org.seasar.robot.db.bsentity.dbmeta.UrlQueueDbm");
        _tableDbNameClassNameMap = Collections.unmodifiableMap(tmpMap);
        _tableDbNameFlexibleMap = StringKeyMap.createAsFlexibleConcurrent();
        Set<String> tableDbNameSet = _tableDbNameClassNameMap.keySet();
        for (String tableDbName : tableDbNameSet) {
            _tableDbNameFlexibleMap.put(tableDbName, tableDbName);
        }
    }
}

