/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class HyphenatedWordsFilter
extends TokenFilter {
    public HyphenatedWordsFilter(TokenStream in) {
        super(in);
    }

    public final Token next(Token in) throws IOException {
        StringBuilder termText = new StringBuilder(25);
        int startOffset = -1;
        int firstPositionIncrement = -1;
        int wordsMerged = 0;
        Token lastToken = null;
        Token token = this.input.next(in);
        while (token != null) {
            termText.append(token.termBuffer(), 0, token.termLength());
            if (termText.charAt(termText.length() - 1) == '-') {
                ++wordsMerged;
                termText.setLength(termText.length() - 1);
                if (startOffset == -1) {
                    startOffset = token.startOffset();
                    firstPositionIncrement = token.getPositionIncrement();
                }
            } else {
                if (wordsMerged == 0) {
                    return token;
                }
                Token mergedToken = new Token(termText.toString(), startOffset, token.endOffset(), token.type());
                mergedToken.setPositionIncrement(firstPositionIncrement);
                return mergedToken;
            }
            lastToken = token;
            token = this.input.next();
        }
        if (startOffset != -1) {
            return lastToken;
        }
        return null;
    }
}

