/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExecutionTimeoutException;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;
import org.seasar.robot.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(CommandExtractor.class);
    public String outputEncoding = "UTF-8";
    public File tempDir = null;
    public String command;
    public long executionTimeout = 30000L;
    public File workingDirectory = null;
    public String commandOutputEncoding = System.getProperty("file.encoding");
    public int maxOutputLine = 1000;

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        ExtractData extractData;
        File outputFile;
        block13: {
            String extention;
            String filePrefix;
            String resourceName;
            String string = resourceName = params == null ? null : params.get("resourceName");
            if (StringUtil.isNotBlank((String)resourceName)) {
                String[] strings = resourceName.split("\\.");
                StringBuilder buf = new StringBuilder();
                if (strings.length > 1) {
                    for (int i = 0; i < strings.length - 1; ++i) {
                        if (buf.length() != 0) {
                            buf.append('.');
                        }
                        buf.append(strings[i]);
                    }
                    filePrefix = buf.toString();
                    extention = strings[strings.length - 1];
                } else {
                    filePrefix = resourceName;
                    extention = "";
                }
            } else {
                filePrefix = "none";
                extention = "";
            }
            File inputFile = null;
            outputFile = null;
            try {
                inputFile = File.createTempFile("cmdextin_" + filePrefix + "_", extention, this.tempDir);
                outputFile = File.createTempFile("cmdextout_" + filePrefix + "_", extention, this.tempDir);
                StreamUtil.drain(in, inputFile);
                this.executeCommand(inputFile, outputFile);
                ExtractData extractData2 = new ExtractData(new String(FileUtil.getBytes((File)outputFile), this.outputEncoding));
                if (StringUtil.isNotBlank((String)resourceName)) {
                    extractData2.putValues("resourceName", new String[]{resourceName});
                }
                extractData = extractData2;
                Object var11_12 = null;
                if (inputFile == null || inputFile.delete()) break block13;
            }
            catch (IOException e) {
                try {
                    throw new ExtractException("Could not extract a content.", e);
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var11_13 = null;
                        if (inputFile != null && !inputFile.delete()) {
                            logger.info("Failed to delete " + inputFile.getAbsolutePath());
                        }
                        if (outputFile == null || outputFile.delete()) break block14;
                        logger.info("Failed to delete " + outputFile.getAbsolutePath());
                    }
                    throw throwable;
                }
            }
            logger.info("Failed to delete " + inputFile.getAbsolutePath());
        }
        if (outputFile != null && !outputFile.delete()) {
            logger.info("Failed to delete " + outputFile.getAbsolutePath());
        }
        return extractData;
    }

    /*
     * Loose catch block
     */
    private void executeCommand(File inputFile, File outputFile) {
        Process currentProcess;
        block22: {
            Exception e22;
            MonitorThread mt;
            List<String> cmdList;
            block21: {
                block20: {
                    if (StringUtil.isBlank((String)this.command)) {
                        throw new RobotSystemException("command is empty.");
                    }
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("$INPUT_FILE", inputFile.getAbsolutePath());
                    params.put("$OUTPUT_FILE", outputFile.getAbsolutePath());
                    cmdList = this.parseCommand(this.command, params);
                    if (logger.isInfoEnabled()) {
                        logger.info("Command: " + cmdList);
                    }
                    ProcessBuilder pb = new ProcessBuilder(cmdList);
                    if (this.workingDirectory != null) {
                        pb.directory(this.workingDirectory);
                    }
                    pb.redirectErrorStream(true);
                    currentProcess = null;
                    mt = null;
                    currentProcess = pb.start();
                    mt = new MonitorThread(currentProcess, this.executionTimeout);
                    mt.start();
                    InputStreamThread it = new InputStreamThread(currentProcess.getInputStream(), this.commandOutputEncoding, this.maxOutputLine);
                    it.start();
                    currentProcess.waitFor();
                    it.join(5000L);
                    if (mt.isTeminated()) {
                        throw new ExecutionTimeoutException("The command execution is timeout: " + cmdList);
                    }
                    int exitValue = currentProcess.exitValue();
                    if (!logger.isInfoEnabled()) break block20;
                    logger.info("Exit Code: " + exitValue + " - Process Output:\n" + it.getOutput());
                }
                Object var11_13 = null;
                if (mt == null) break block21;
                mt.setFinished(true);
                try {
                    mt.interrupt();
                }
                catch (Exception e22) {
                    // empty catch block
                }
            }
            if (currentProcess != null) {
                try {
                    currentProcess.destroy();
                    break block22;
                }
                catch (Exception e22) {
                    // empty catch block
                }
                {
                }
            }
            break block22;
            {
                catch (RobotSystemException e3) {
                    throw e3;
                }
                catch (InterruptedException e4) {
                    if (mt != null && mt.isTeminated()) {
                        throw new ExecutionTimeoutException("The command execution is timeout: " + cmdList, e4);
                    }
                    throw new RobotSystemException("Process terminated.", e4);
                }
                catch (Exception e5) {
                    throw new RobotSystemException("Process terminated.", e5);
                }
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var11_14 = null;
                if (mt != null) {
                    mt.setFinished(true);
                    try {
                        mt.interrupt();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (currentProcess != null) {
                    try {
                        currentProcess.destroy();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                currentProcess = null;
                throw throwable;
            }
        }
        currentProcess = null;
    }

    List<String> parseCommand(String command, Map<String, String> params) {
        String cmd = command.trim();
        ArrayList<String> cmdList = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean singleQuote = false;
        boolean doubleQuote = false;
        int prevChar = 32;
        for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            if (c == ' ' && !singleQuote && !doubleQuote && buf.length() > 0) {
                cmdList.add(this.getCommandValue(buf.toString(), params));
                buf.delete(0, buf.length());
            } else if (c == '\"' && !singleQuote && prevChar != 92) {
                if (doubleQuote) {
                    if (buf.length() > 0) {
                        cmdList.add(this.getCommandValue(buf.toString(), params));
                        buf.delete(0, buf.length());
                    }
                    doubleQuote = false;
                } else {
                    doubleQuote = true;
                }
            } else if (c == '\'' && !doubleQuote && prevChar != 92) {
                if (singleQuote) {
                    if (buf.length() > 0) {
                        cmdList.add(this.getCommandValue(buf.toString(), params));
                        buf.delete(0, buf.length());
                    }
                    singleQuote = false;
                } else {
                    singleQuote = true;
                }
            } else {
                buf.append(c);
            }
            prevChar = c;
        }
        if (buf.length() > 0) {
            cmdList.add(this.getCommandValue(buf.toString(), params));
        }
        return cmdList;
    }

    private String getCommandValue(String key, Map<String, String> params) {
        String value = params.get(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    protected static class InputStreamThread
    extends Thread {
        private BufferedReader br;
        private final List<String> list = new LinkedList<String>();
        private final int maxLineBuffer;

        public InputStreamThread(InputStream is, String charset, int maxOutputLineBuffer) {
            try {
                this.br = new BufferedReader(new InputStreamReader(is, charset));
            }
            catch (UnsupportedEncodingException e) {
                throw new RobotSystemException(e);
            }
            this.maxLineBuffer = maxOutputLineBuffer;
        }

        public void run() {
            try {
                String line;
                while ((line = this.br.readLine()) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(line);
                    }
                    this.list.add(line);
                    if (this.list.size() <= this.maxLineBuffer) continue;
                    this.list.remove(0);
                }
            }
            catch (IOException e) {
                throw new RobotSystemException(e);
            }
        }

        public String getOutput() {
            StringBuilder buf = new StringBuilder();
            for (String value : this.list) {
                buf.append(value).append("\n");
            }
            return buf.toString();
        }
    }

    protected static class MonitorThread
    extends Thread {
        private final Process process;
        private final long timeout;
        private boolean finished = false;
        private boolean teminated = false;

        public MonitorThread(Process process, long timeout) {
            this.process = process;
            this.timeout = timeout;
        }

        public void run() {
            block5: {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.finished) {
                    try {
                        this.process.destroy();
                        this.teminated = true;
                    }
                    catch (Exception e) {
                        if (!logger.isInfoEnabled()) break block5;
                        logger.info("Could not kill the subprocess.", (Throwable)e);
                    }
                }
            }
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public boolean isTeminated() {
            return this.teminated;
        }
    }
}

