/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.io.IOException;
import java.io.StringReader;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class HTMLHighlighter {
    private final Implementation implementation = new Implementation();
    private static final TagAction TA_IGNORABLE_ELEMENT = new TagAction(){

        void beforeStart(Implementation instance, String localName) {
            instance.inIgnorableElement++;
        }

        void afterEnd(Implementation instance, String localName) {
            instance.inIgnorableElement--;
        }
    };
    private static final TagAction TA_HEAD = new TagAction(){

        void beforeEnd(Implementation instance, String localName) {
            instance.html.append("\n<style type=\"text/css\">\n.x-boilerpipe-mark1 { text-decoration:none; background-color: #ffff42 !important; color: black !important; display:inline !important; visibility:visible !important; }\n</style>\n");
        }
    };
    private static Map<String, TagAction> TAG_ACTIONS = new HashMap<String, TagAction>();

    public HTMLHighlighter(TextDocument doc, String origHTML) throws BoilerpipeProcessingException {
        this(doc, new InputSource(new StringReader(origHTML)));
    }

    public HTMLHighlighter(TextDocument doc, InputSource is) throws BoilerpipeProcessingException {
        this.implementation.process(doc, is);
    }

    public String getHTML() {
        return this.implementation.html.toString();
    }

    private static String xmlEncode(String in) {
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(in.length());
        block6: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block6;
                }
                case '>': {
                    out.append("&gt;");
                    continue block6;
                }
                case '&': {
                    out.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    static {
        TAG_ACTIONS.put("STYLE", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("SCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("NOSCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("OBJECT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("EMBED", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("APPLET", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("LINK", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("HEAD", TA_HEAD);
    }

    private final class Implementation
    extends AbstractSAXParser
    implements ContentHandler {
        StringBuilder html;
        private int inIgnorableElement;
        private int characterElementIdx;
        private final BitSet contentBitSet;

        Implementation() {
            super((XMLParserConfiguration)new HTMLConfiguration());
            this.html = new StringBuilder();
            this.inIgnorableElement = 0;
            this.characterElementIdx = 0;
            this.contentBitSet = new BitSet();
            this.setContentHandler(this);
        }

        void process(TextDocument doc, InputSource is) throws BoilerpipeProcessingException {
            for (TextBlock block : doc.getTextBlocks()) {
                if (!block.isContent()) continue;
                this.contentBitSet.or(block.getContainedTextElements());
            }
            try {
                this.parse(is);
            }
            catch (SAXException e) {
                throw new BoilerpipeProcessingException(e);
            }
            catch (IOException e) {
                throw new BoilerpipeProcessingException(e);
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            TagAction ta = (TagAction)TAG_ACTIONS.get(localName);
            if (ta != null) {
                ta.beforeStart(this, localName);
            }
            if (this.inIgnorableElement == 0) {
                this.html.append('<');
                this.html.append(qName);
                int numAtts = atts.getLength();
                for (int i = 0; i < numAtts; ++i) {
                    String attr = atts.getQName(i);
                    String value = atts.getValue(i);
                    this.html.append(' ');
                    this.html.append(attr);
                    this.html.append("=\"");
                    this.html.append(HTMLHighlighter.xmlEncode(value));
                    this.html.append("\"");
                }
                this.html.append('>');
            }
            if (ta != null) {
                ta.afterStart(this, localName);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            TagAction ta = (TagAction)TAG_ACTIONS.get(localName);
            if (ta != null) {
                ta.beforeEnd(this, localName);
            }
            if (this.inIgnorableElement == 0) {
                this.html.append("</");
                this.html.append(qName);
                this.html.append('>');
            }
            if (ta != null) {
                ta.afterEnd(this, localName);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            ++this.characterElementIdx;
            if (this.inIgnorableElement == 0) {
                boolean highlight = this.contentBitSet.get(this.characterElementIdx);
                if (highlight) {
                    this.html.append("<span class=\"x-boilerpipe-mark1\">");
                }
                this.html.append(HTMLHighlighter.xmlEncode(String.valueOf(ch, start, length)));
                if (highlight) {
                    this.html.append("</span>");
                }
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }

    private static abstract class TagAction {
        private TagAction() {
        }

        void beforeStart(Implementation instance, String localName) {
        }

        void afterStart(Implementation instance, String localName) {
        }

        void beforeEnd(Implementation instance, String localName) {
        }

        void afterEnd(Implementation instance, String localName) {
        }
    }
}

