/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.regex.Pattern;

public class TerminatingBlocksFinder
implements BoilerpipeFilter {
    public static final TerminatingBlocksFinder INSTANCE = new TerminatingBlocksFinder();
    private static final Pattern N_COMMENTS = Pattern.compile("^[0-9]+ Comments");

    public static TerminatingBlocksFinder getInstance() {
        return INSTANCE;
    }

    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (tb.getNumWords() >= 20) continue;
            String text = tb.getText().trim();
            String textLC = text.toLowerCase();
            if (!text.startsWith("Comments") && !N_COMMENTS.matcher(text).find() && !textLC.contains("what you think...") && !textLC.contains("add your comment:") && !text.contains("Add Comment") && !text.contains("Reader views") && !text.contains("Have your say") && !text.contains("Have Your Say") && !text.contains("Reader Comments") && !text.equals("Thanks for your comments - this feedback is now closed") && !text.startsWith("\u00a9 Reuters") && !text.startsWith("Please rate this")) continue;
            tb.addLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
            changes = true;
        }
        return changes;
    }
}

