/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.robot.dbflute.twowaysql.context.CommandContext;
import org.seasar.robot.dbflute.twowaysql.node.AbstractNode;
import org.seasar.robot.dbflute.twowaysql.node.NodeUtil;
import org.seasar.robot.dbflute.twowaysql.node.ParameterFinder;
import org.seasar.robot.dbflute.twowaysql.node.ValueAndType;
import org.seasar.robot.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.robot.dbflute.twowaysql.pmbean.ParameterBean;
import org.seasar.robot.dbflute.util.DfStringUtil;

public class EmbeddedValueNode
extends AbstractNode {
    protected String _expression;
    protected String _testValue;
    protected List<String> _nameList;
    protected String _specifiedSql;
    protected boolean _blockNullParameter;

    public EmbeddedValueNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        this._expression = expression;
        this._testValue = testValue;
        this._nameList = DfStringUtil.splitList(expression, ".");
        this._specifiedSql = specifiedSql;
        this._blockNullParameter = blockNullParameter;
    }

    public void accept(CommandContext ctx) {
        String firstName = this._nameList.get(0);
        this.assertFirstName(ctx, firstName);
        Object value = ctx.getArg(firstName);
        Class<?> clazz = ctx.getArgType(firstName);
        ValueAndType valueAndType = new ValueAndType();
        valueAndType.setTargetValue(value);
        valueAndType.setTargetType(clazz);
        this.setupValueAndType(valueAndType);
        if (this._blockNullParameter && valueAndType.getTargetValue() == null) {
            this.throwBindOrEmbeddedParameterNullValueException(valueAndType);
        }
        if (!this.isInScope()) {
            if (valueAndType.getTargetValue() != null && valueAndType.getTargetValue().toString().indexOf("?") > -1) {
                String msg = "The value of expression for embedded comment should not contain a question mark '?':";
                msg = msg + " value=" + valueAndType.getTargetValue() + " expression=" + this._expression;
                throw new IllegalStateException(msg);
            }
            ctx.addSql(valueAndType.getTargetValue().toString());
        } else if (List.class.isAssignableFrom(valueAndType.getTargetType())) {
            this.embedArray(ctx, ((List)valueAndType.getTargetValue()).toArray());
        } else if (valueAndType.getTargetType().isArray()) {
            this.embedArray(ctx, valueAndType.getTargetValue());
        } else {
            if (valueAndType.getTargetValue() != null && valueAndType.getTargetValue().toString().indexOf("?") > -1) {
                String msg = "The value of expression for embedded comment should not contain a question mark '?':";
                msg = msg + " value=" + valueAndType.getTargetValue() + " expression=" + this._expression;
                throw new IllegalStateException(msg);
            }
            ctx.addSql(valueAndType.getTargetValue().toString());
        }
        if (valueAndType.isValidRearOption()) {
            ctx.addSql(valueAndType.buildRearOptionOnSql());
        }
    }

    protected void assertFirstName(final CommandContext ctx, String firstName) {
        NodeUtil.assertParameterBeanName(firstName, new ParameterFinder(){

            public Object find(String name) {
                return ctx.getArg(name);
            }
        }, new NodeUtil.IllegalParameterBeanHandler(){

            public void handle(ParameterBean pmb) {
                EmbeddedValueNode.this.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(pmb);
            }
        });
    }

    protected void setupValueAndType(ValueAndType valueAndType) {
        ValueAndTypeSetupper setupper = new ValueAndTypeSetupper(this._expression, this._nameList, this._specifiedSql, false);
        setupper.setupValueAndType(valueAndType);
    }

    protected void throwBindOrEmbeddedParameterNullValueException(ValueAndType valueAndType) {
        NodeUtil.throwBindOrEmbeddedCommentParameterNullValueException(this._expression, valueAndType.getTargetType(), this._specifiedSql, false);
    }

    protected boolean isInScope() {
        return this._testValue != null && this._testValue.startsWith("(") && this._testValue.endsWith(")");
    }

    protected void embedArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedCommentParameterEmptyListException();
        }
        String quote = null;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            quote = !(currentElement instanceof Number) ? "'" : "";
            break;
        }
        if (quote == null) {
            this.throwBindOrEmbeddedCommentParameterNullOnlyListException();
        }
        boolean existsValidElements = false;
        ctx.addSql("(");
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (!existsValidElements) {
                ctx.addSql(quote + currentElement + quote);
                existsValidElements = true;
                continue;
            }
            ctx.addSql(", " + quote + currentElement + quote);
        }
        ctx.addSql(")");
    }

    protected void throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(ParameterBean pmb) {
        NodeUtil.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(this._expression, this._specifiedSql, false, pmb);
    }

    protected void throwBindOrEmbeddedCommentParameterEmptyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterEmptyListException(this._expression, this._specifiedSql, false);
    }

    protected void throwBindOrEmbeddedCommentParameterNullOnlyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterNullOnlyListException(this._expression, this._specifiedSql, false);
    }
}

