/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.rowcreator.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.robot.dbflute.s2dao.rowcreator.impl.TnRelationRowCreationResource;
import org.seasar.robot.dbflute.util.DfReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnRelationRowCreatorImpl
implements TnRelationRowCreator {
    @Override
    public Object createRelationRow(ResultSet rs, TnRelationPropertyType rpt, Set<String> columnNames, Map<String, Object> relKeyValues, Map<String, Map<String, TnPropertyType>> relationPropertyCache) throws SQLException {
        TnRelationRowCreationResource res = this.createResourceForRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache);
        return this.createRelationRow(res);
    }

    protected abstract TnRelationRowCreationResource createResourceForRow(ResultSet var1, TnRelationPropertyType var2, Set<String> var3, Map<String, Object> var4, Map<String, Map<String, TnPropertyType>> var5) throws SQLException;

    protected Object createRelationRow(TnRelationRowCreationResource res) throws SQLException {
        if (!res.hasPropertyCacheElement()) {
            return null;
        }
        this.setupRelationKeyValue(res);
        this.setupRelationAllValue(res);
        return res.getRow();
    }

    protected void setupRelationKeyValue(TnRelationRowCreationResource res) {
        TnRelationPropertyType rpt = res.getRelationPropertyType();
        TnBeanMetaData bmd = rpt.getBeanMetaData();
        for (int i = 0; i < rpt.getKeySize(); ++i) {
            Object value;
            String columnName = rpt.getMyKey(i) + res.getBaseSuffix();
            if (!res.containsColumnName(columnName)) continue;
            if (!res.hasRowInstance()) {
                res.setRow(this.newRelationRow(rpt));
            }
            if (!res.containsRelKeyValueIfExists(columnName) || (value = res.extractRelKeyValue(columnName)) == null) continue;
            String yourKey = rpt.getYourKey(i);
            TnPropertyType pt = bmd.getPropertyTypeByColumnName(yourKey);
            DfPropertyDesc pd = pt.getPropertyDesc();
            pd.setValue(res.getRow(), value);
        }
    }

    protected void setupRelationAllValue(TnRelationRowCreationResource res) throws SQLException {
        Map<String, TnPropertyType> propertyCacheElement = res.extractPropertyCacheElement();
        Set<Map.Entry<String, TnPropertyType>> entrySet = propertyCacheElement.entrySet();
        for (Map.Entry<String, TnPropertyType> entry : entrySet) {
            TnPropertyType pt = entry.getValue();
            res.setCurrentPropertyType(pt);
            if (!this.isValidRelationPerPropertyLoop(res)) {
                res.clearRowInstance();
                return;
            }
            this.setupRelationProperty(res);
        }
        if (!this.isValidRelationAfterPropertyLoop(res)) {
            res.clearRowInstance();
            return;
        }
        res.clearValidValueCount();
        if (res.hasNextRelationProperty() && res.hasNextRelationLevel()) {
            this.setupNextRelationRow(res);
        }
    }

    protected boolean isValidRelationPerPropertyLoop(TnRelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected boolean isValidRelationAfterPropertyLoop(TnRelationRowCreationResource res) throws SQLException {
        if (res.isCreateDeadLink()) {
            return true;
        }
        return res.hasValidValueCount();
    }

    protected void setupRelationProperty(TnRelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        if (!res.hasRowInstance()) {
            res.setRow(this.newRelationRow(res));
        }
        this.registerRelationValue(res, columnName);
    }

    protected abstract void registerRelationValue(TnRelationRowCreationResource var1, String var2) throws SQLException;

    protected void registerRelationValidValue(TnRelationRowCreationResource res, TnPropertyType pt, Object value) throws SQLException {
        res.incrementValidValueCount();
        DfPropertyDesc pd = pt.getPropertyDesc();
        pd.setValue(res.getRow(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRow(TnRelationRowCreationResource res) throws SQLException {
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        Object row = res.getRow();
        res.backupRelationPropertyType();
        res.incrementCurrentRelationNestLevel();
        try {
            for (int i = 0; i < nextBmd.getRelationPropertyTypeSize(); ++i) {
                TnRelationPropertyType nextRpt = nextBmd.getRelationPropertyType(i);
                this.setupNextRelationRowElement(res, row, nextRpt);
            }
        }
        finally {
            res.setRow(row);
            res.restoreRelationPropertyType();
            res.decrementCurrentRelationNestLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRowElement(TnRelationRowCreationResource res, Object row, TnRelationPropertyType nextRpt) throws SQLException {
        if (nextRpt == null) {
            return;
        }
        res.clearRowInstance();
        res.setRelationPropertyType(nextRpt);
        String baseSuffix = res.getRelationNoSuffix();
        String additionalRelationNoSuffix = this.buildRelationNoSuffix(nextRpt);
        res.backupSuffixAndPrepare(baseSuffix, additionalRelationNoSuffix);
        try {
            Object relationRow = this.createRelationRow(res);
            if (relationRow != null) {
                nextRpt.getPropertyDesc().setValue(row, relationRow);
            }
        }
        finally {
            res.restoreSuffix();
        }
    }

    @Override
    public Map<String, Map<String, TnPropertyType>> createPropertyCache(Set<String> columnNames, TnBeanMetaData bmd) throws SQLException {
        Map<String, Map<String, TnPropertyType>> relationPropertyCache = this.newRelationPropertyCache();
        for (int i = 0; i < bmd.getRelationPropertyTypeSize(); ++i) {
            TnRelationPropertyType rpt = bmd.getRelationPropertyType(i);
            String baseSuffix = "";
            String relationNoSuffix = this.buildRelationNoSuffix(rpt);
            TnRelationRowCreationResource res = this.createResourceForPropertyCache(rpt, columnNames, relationPropertyCache, "", relationNoSuffix, this.getLimitRelationNestLevel());
            if (rpt == null) continue;
            this.setupPropertyCache(res);
        }
        return relationPropertyCache;
    }

    protected abstract TnRelationRowCreationResource createResourceForPropertyCache(TnRelationPropertyType var1, Set<String> var2, Map<String, Map<String, TnPropertyType>> var3, String var4, String var5, int var6) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupPropertyCache(TnRelationRowCreationResource res) throws SQLException {
        res.initializePropertyCacheElement();
        if (!this.isTargetRelation(res)) {
            return;
        }
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        Map<String, TnPropertyType> propertyTypeMap = nextBmd.getPropertyTypeMap();
        Set<Map.Entry<String, TnPropertyType>> entrySet = propertyTypeMap.entrySet();
        for (Map.Entry<String, TnPropertyType> entry : entrySet) {
            TnPropertyType pt = entry.getValue();
            res.setCurrentPropertyType(pt);
            if (!this.isTargetProperty(res)) continue;
            this.setupPropertyCacheElement(res);
        }
        if (res.hasNextRelationProperty() && res.hasNextRelationLevel()) {
            res.backupRelationPropertyType();
            res.incrementCurrentRelationNestLevel();
            try {
                this.setupNextPropertyCache(res, nextBmd);
            }
            finally {
                res.restoreRelationPropertyType();
                res.decrementCurrentRelationNestLevel();
            }
        }
    }

    protected void setupPropertyCacheElement(TnRelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        if (!res.containsColumnName(columnName)) {
            return;
        }
        res.savePropertyCacheElement();
    }

    protected void setupNextPropertyCache(TnRelationRowCreationResource res, TnBeanMetaData nextBmd) throws SQLException {
        for (int i = 0; i < nextBmd.getRelationPropertyTypeSize(); ++i) {
            TnRelationPropertyType nextNextRpt = nextBmd.getRelationPropertyType(i);
            res.setRelationPropertyType(nextNextRpt);
            this.setupNextPropertyCacheElement(res, nextNextRpt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextPropertyCacheElement(TnRelationRowCreationResource res, TnRelationPropertyType nextNextRpt) throws SQLException {
        String baseSuffix = res.getRelationNoSuffix();
        String additionalRelationNoSuffix = this.buildRelationNoSuffix(nextNextRpt);
        res.backupSuffixAndPrepare(baseSuffix, additionalRelationNoSuffix);
        try {
            this.setupPropertyCache(res);
        }
        finally {
            res.restoreSuffix();
        }
    }

    protected Map<String, Map<String, TnPropertyType>> newRelationPropertyCache() {
        return new HashMap<String, Map<String, TnPropertyType>>();
    }

    protected String buildRelationNoSuffix(TnRelationPropertyType rpt) {
        return "_" + rpt.getRelationNo();
    }

    protected Object newRelationRow(TnRelationRowCreationResource res) {
        return this.newRelationRow(res.getRelationPropertyType());
    }

    protected Object newRelationRow(TnRelationPropertyType rpt) {
        return DfReflectionUtil.newInstance(rpt.getPropertyDesc().getPropertyType());
    }

    protected boolean isTargetRelation(TnRelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected boolean isTargetProperty(TnRelationRowCreationResource res) throws SQLException {
        TnPropertyType pt = res.getCurrentPropertyType();
        return pt.getPropertyDesc().isWritable();
    }

    protected boolean isCreateDeadLink() {
        return true;
    }

    protected int getLimitRelationNestLevel() {
        return 1;
    }
}

