/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.cbean.ConditionQuery;
import org.seasar.robot.dbflute.cbean.OrQuery;
import org.seasar.robot.dbflute.cbean.OrderByBean;
import org.seasar.robot.dbflute.cbean.PagingBean;
import org.seasar.robot.dbflute.cbean.SpecifyQuery;
import org.seasar.robot.dbflute.cbean.UnionQuery;
import org.seasar.robot.dbflute.cbean.chelper.HpAbstractSpecification;
import org.seasar.robot.dbflute.cbean.sqlclause.OrderByClause;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.WhereClauseSimpleFilter;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.exception.PagingPageSizeNotPlusException;
import org.seasar.robot.dbflute.helper.mapstring.impl.MapListStringImpl;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.twowaysql.factory.SqlAnalyzerFactory;
import org.seasar.robot.dbflute.util.DfStringUtil;
import org.seasar.robot.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionBean
implements ConditionBean {
    private static final String MAP_STRING_MAP_MARK = "map:";
    private static final String MAP_STRING_LIST_MARK = "list:";
    private static final String MAP_STRING_START_BRACE = "@{";
    private static final String MAP_STRING_END_BRACE = "@}";
    private static final String MAP_STRING_DELIMITER = "@;";
    private static final String MAP_STRING_EQUAL = "@=";
    protected final SqlClause _sqlClause = this.createSqlClause();
    private int _safetyMaxResultSize;
    private StatementConfig _statementConfig;
    private boolean _canPagingReSelect = true;
    private Map<String, Object> _freeParameterMap;
    private UnionQuery<ConditionBean> _unionQuerySynchronizer;
    protected boolean _forDerivedReferrer;
    protected boolean _forScalarSelect;
    protected boolean _forScalarSubQuery;
    protected boolean _forUnion;
    protected boolean _forExistsSubQuery;
    protected boolean _forInScopeSubQuery;
    protected boolean _isSelectCountIgnoreFetchScope;

    @Override
    public SqlClause getSqlClause() {
        return this._sqlClause;
    }

    protected abstract SqlClause createSqlClause();

    protected abstract DBMetaProvider getDBMetaProvider();

    public void embedCondition(Set<ColumnInfo> embeddedColumnInfoSet, boolean quote) {
        if (embeddedColumnInfoSet == null) {
            String msg = "The argument[embeddedColumnInfoSet] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (quote) {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet));
        } else {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedSimpleFilter(embeddedColumnInfoSet));
        }
    }

    private WhereClauseSimpleFilter newToEmbeddedQuotedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new WhereClauseSimpleFilter.WhereClauseToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet);
    }

    private WhereClauseSimpleFilter newToEmbeddedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new WhereClauseSimpleFilter.WhereClauseToEmbeddedSimpleFilter(embeddedColumnInfoSet);
    }

    private void addWhereClauseSimpleFilter(WhereClauseSimpleFilter whereClauseSimpleFilter) {
        this._sqlClause.addWhereClauseSimpleFilter(whereClauseSimpleFilter);
    }

    @Override
    public void acceptPrimaryKeyMapString(String primaryKeyMapString) {
        if (primaryKeyMapString == null) {
            String msg = "The argument[primaryKeyMapString] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        String prefix = "map:@{";
        String suffix = MAP_STRING_END_BRACE;
        if (!primaryKeyMapString.trim().startsWith("map:@{")) {
            primaryKeyMapString = "map:@{" + primaryKeyMapString;
        }
        if (!primaryKeyMapString.trim().endsWith(MAP_STRING_END_BRACE)) {
            primaryKeyMapString = primaryKeyMapString + MAP_STRING_END_BRACE;
        }
        MapListStringImpl mapListString = new MapListStringImpl();
        mapListString.setMapMark(MAP_STRING_MAP_MARK);
        mapListString.setListMark(MAP_STRING_LIST_MARK);
        mapListString.setDelimiter(MAP_STRING_DELIMITER);
        mapListString.setStartBrace(MAP_STRING_START_BRACE);
        mapListString.setEndBrace(MAP_STRING_END_BRACE);
        mapListString.setEqual(MAP_STRING_EQUAL);
        this.acceptPrimaryKeyMap(mapListString.generateMap(primaryKeyMapString));
    }

    protected void checkTypeString(Object value, String propertyName, String typeName) {
        if (value == null) {
            throw new IllegalArgumentException("The value should not be null: " + propertyName);
        }
        if (!(value instanceof String)) {
            String msg = "The value of " + propertyName + " should be " + typeName + " or String: ";
            msg = msg + "valueType=" + value.getClass() + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected long parseDateStringAsMillis(Object value, String propertyName, String typeName) {
        this.checkTypeString(value, propertyName, typeName);
        try {
            String valueString = (String)value;
            if (valueString.indexOf("-") >= 0 && valueString.indexOf("-") != valueString.lastIndexOf("-")) {
                return Timestamp.valueOf(valueString).getTime();
            }
            return this.getParseDateFormat().parse((String)value).getTime();
        }
        catch (ParseException e) {
            String msg = "The value of " + propertyName + " should be " + typeName + ". but: " + value;
            throw new RuntimeException(msg + " threw the exception: value=[" + value + "]", e);
        }
        catch (RuntimeException e) {
            String msg = "The value of " + propertyName + " should be " + typeName + ". but: " + value;
            throw new RuntimeException(msg + " threw the exception: value=[" + value + "]", e);
        }
    }

    private DateFormat getParseDateFormat() {
        return DateFormat.getDateTimeInstance();
    }

    @Override
    public boolean isPaging() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean isCountLater() {
        return false;
    }

    @Override
    public void paging(int pageSize, int pageNumber) {
        if (pageSize <= 0) {
            this.throwPagingPageSizeNotPlusException(pageSize, pageNumber);
        }
        this.fetchFirst(pageSize);
        this.fetchPage(pageNumber);
    }

    protected void throwPagingPageSizeNotPlusException(int pageSize, int pageNumber) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Page size for paging should not be minus or zero!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Confirm the value of your parameter 'pageSize'." + this.ln();
        msg = msg + "The first parameter of paging() should be a plus value!" + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x) - cb.paging(0, 1);" + this.ln();
        msg = msg + "    (x) - cb.paging(-3, 2);" + this.ln();
        msg = msg + "    (o) - cb.paging(4, 3);" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Page Size]" + this.ln();
        msg = msg + pageSize + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Page Number]" + this.ln();
        msg = msg + pageNumber + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new PagingPageSizeNotPlusException(msg);
    }

    @Override
    public void xsetPaging(boolean paging) {
    }

    @Override
    public void disablePagingReSelect() {
        this._canPagingReSelect = false;
    }

    @Override
    public boolean canPagingReSelect() {
        return this._canPagingReSelect;
    }

    @Override
    public PagingBean fetchFirst(int fetchSize) {
        this.getSqlClause().fetchFirst(fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchScope(int fetchStartIndex, int fetchSize) {
        this.getSqlClause().fetchScope(fetchStartIndex, fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchPage(int fetchPageNumber) {
        this.getSqlClause().fetchPage(fetchPageNumber);
        return this;
    }

    @Override
    public int getFetchStartIndex() {
        return this.getSqlClause().getFetchStartIndex();
    }

    @Override
    public int getFetchSize() {
        return this.getSqlClause().getFetchSize();
    }

    @Override
    public int getFetchPageNumber() {
        return this.getSqlClause().getFetchPageNumber();
    }

    @Override
    public int getPageStartIndex() {
        return this.getSqlClause().getPageStartIndex();
    }

    @Override
    public int getPageEndIndex() {
        return this.getSqlClause().getPageEndIndex();
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this.getSqlClause().isFetchScopeEffective();
    }

    public String getSelectHint() {
        return this.getSqlClause().getSelectHint();
    }

    public String getFromBaseTableHint() {
        return this.getSqlClause().getFromBaseTableHint();
    }

    public String getFromHint() {
        return this.getSqlClause().getFromHint();
    }

    public String getSqlSuffix() {
        return this.getSqlClause().getSqlSuffix();
    }

    @Override
    public void checkSafetyResult(int safetyMaxResultSize) {
        this._safetyMaxResultSize = safetyMaxResultSize;
    }

    @Override
    public int getSafetyMaxResultSize() {
        return this._safetyMaxResultSize;
    }

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getSqlClause().getFetchNarrowingSkipStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getSqlClause().getFetchNarrowingLoopCount();
    }

    @Override
    public boolean isFetchNarrowingSkipStartIndexEffective() {
        return !this.getSqlClause().isFetchStartIndexSupported();
    }

    @Override
    public boolean isFetchNarrowingLoopCountEffective() {
        return !this.getSqlClause().isFetchSizeSupported();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this.getSqlClause().isFetchNarrowingEffective();
    }

    @Override
    public void ignoreFetchNarrowing() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void restoreIgnoredFetchNarrowing() {
    }

    @Override
    public OrderByClause getSqlComponentOfOrderByClause() {
        return this.getSqlClause().getSqlComponentOfOrderByClause();
    }

    @Override
    public String getOrderByClause() {
        return this._sqlClause.getOrderByClause();
    }

    @Override
    public OrderByBean clearOrderBy() {
        this.getSqlClause().clearOrderBy();
        return this;
    }

    @Override
    public OrderByBean ignoreOrderBy() {
        this.getSqlClause().ignoreOrderBy();
        return this;
    }

    @Override
    public OrderByBean makeOrderByEffective() {
        this.getSqlClause().makeOrderByEffective();
        return this;
    }

    @Override
    public ConditionBean lockForUpdate() {
        this.getSqlClause().lockForUpdate();
        return this;
    }

    @Override
    public ConditionBean xsetupSelectCountIgnoreFetchScope() {
        this._isSelectCountIgnoreFetchScope = true;
        this.getSqlClause().classifySelectClauseType(SqlClause.SelectClauseType.COUNT);
        this.getSqlClause().ignoreOrderBy();
        this.getSqlClause().ignoreFetchScope();
        return this;
    }

    @Override
    public ConditionBean xafterCareSelectCountIgnoreFetchScope() {
        this._isSelectCountIgnoreFetchScope = false;
        this.getSqlClause().rollbackSelectClauseType();
        this.getSqlClause().makeOrderByEffective();
        this.getSqlClause().makeFetchScopeEffective();
        return this;
    }

    @Override
    public boolean isSelectCountIgnoreFetchScope() {
        return this._isSelectCountIgnoreFetchScope;
    }

    protected abstract HpAbstractSpecification<? extends ConditionQuery> localSp();

    protected <CB extends ConditionBean> void xcolqy(CB cb, SpecifyQuery<CB> leftSp, SpecifyQuery<CB> rightSp, String operand) {
        leftSp.specify(cb);
        String leftColumn = cb.getSqlClause().removeSpecifiedColumnRealNameAsOne();
        if (leftColumn == null) {
            ConditionBeanContext.throwColumnQueryInvalidColumnSpecificationException();
        }
        cb.getSqlClause().clearSpecifiedSelectColumn();
        rightSp.specify(cb);
        String rightColumn = cb.getSqlClause().removeSpecifiedColumnRealNameAsOne();
        if (rightColumn == null) {
            ConditionBeanContext.throwColumnQueryInvalidColumnSpecificationException();
        }
        String clause = leftColumn + " " + operand + " " + rightColumn;
        this.getSqlClause().registerWhereClause(clause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <CB extends ConditionBean> void xorQ(CB cb, OrQuery<CB> orQuery) {
        this.getSqlClause().makeOrQueryEffective();
        try {
            orQuery.query(cb);
        }
        finally {
            this.getSqlClause().ignoreOrQuery();
        }
    }

    @Override
    public void configure(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    @Override
    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    @Override
    public String toDisplaySql() {
        SqlAnalyzerFactory factory = this.getSqlAnalyzerFactory();
        String dateFormat = this.getLogDateFormat();
        String timestampFormat = this.getLogTimestampFormat();
        return ConditionBeanContext.convertConditionBean2DisplaySql(factory, this, dateFormat, timestampFormat);
    }

    protected abstract SqlAnalyzerFactory getSqlAnalyzerFactory();

    protected abstract String getLogDateFormat();

    protected abstract String getLogTimestampFormat();

    @Override
    public boolean hasWhereClause() {
        return this.getSqlClause().hasWhereClause();
    }

    @Override
    public boolean hasOrderByClause() {
        return this.getSqlClause().hasOrderByClause();
    }

    public Map<String, Object> getFreeParameterMap() {
        return this._freeParameterMap;
    }

    @Override
    public void xregisterFreeParameter(String key, Object value) {
        if (this._freeParameterMap == null) {
            this._freeParameterMap = new LinkedHashMap<String, Object>();
        }
        this._freeParameterMap.put(key, value);
    }

    protected void xsyncUQ(ConditionBean unionCB) {
        if (this._unionQuerySynchronizer != null) {
            this._unionQuerySynchronizer.query(unionCB);
        }
    }

    @Override
    public void xregisterUnionQuerySynchronizer(UnionQuery<ConditionBean> unionQuerySynchronizer) {
        this._unionQuerySynchronizer = unionQuerySynchronizer;
    }

    public void xsetupForDerivedReferrer() {
        this._forDerivedReferrer = true;
    }

    public void xsetupForScalarSelect() {
        this._forScalarSelect = true;
    }

    public void xsetupForScalarSubQuery() {
        this._forScalarSubQuery = true;
    }

    public void xsetupForUnion() {
        this._forUnion = true;
    }

    public void xsetupForExistsSubQuery() {
        this._forExistsSubQuery = true;
    }

    public void xsetupForInScopeSubQuery() {
        this._forInScopeSubQuery = true;
    }

    protected void doSetupSelect(SsCall callback) {
        String foreignPropertyName = callback.qf().getForeignPropertyName();
        this.assertSetupSelectBeforeUnion(foreignPropertyName);
        String foreignTableAliasName = callback.qf().getRealAliasName();
        String localRelationPath = this.localCQ().getRelationPath();
        this.getSqlClause().registerSelectedSelectColumn(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, localRelationPath);
        this.getSqlClause().registerSelectedForeignInfo(callback.qf().getRelationPath(), foreignPropertyName);
    }

    protected void assertPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        if (primaryKeyMap == null) {
            String msg = "The argument[primaryKeyMap] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (primaryKeyMap.isEmpty()) {
            String msg = "The argument[primaryKeyMap] must not be empty.";
            throw new IllegalArgumentException(msg);
        }
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        List<ColumnInfo> columnInfoList = dbmeta.getPrimaryUniqueInfo().getUniqueColumnList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnDbName = columnInfo.getColumnDbName();
            if (primaryKeyMap.containsKey(columnDbName)) continue;
            String msg = "The primaryKeyMap must have the value of " + columnDbName;
            throw new IllegalStateException(msg + ": primaryKeyMap --> " + primaryKeyMap);
        }
    }

    protected void assertSetupSelectBeforeUnion(String foreignPropertyName) {
        if (this.hasUnionQueryOrUnionAllQuery()) {
            this.throwSetupSelectAfterUnionException(this.getClass().getSimpleName(), foreignPropertyName);
        }
    }

    protected void throwSetupSelectAfterUnionException(String className, String foreignPropertyName) {
        ConditionBeanContext.throwSetupSelectAfterUnionException(className, foreignPropertyName, this.toDisplaySql());
    }

    protected String initCap(String str) {
        return DfStringUtil.initCap(str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(":").append(this.ln());
        try {
            sb.append(this.toDisplaySql());
        }
        catch (RuntimeException e) {
            sb.append(this.getSqlClause().getClause());
        }
        return sb.toString();
    }

    protected static interface SsCall {
        public ConditionQuery qf();
    }
}

