/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.outsidesql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.exception.OutsideSqlNotFoundException;
import org.seasar.dbflute.jdbc.CursorHandler;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.util.DfResourceUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlContext {
    private static final Log _log = LogFactory.getLog(OutsideSqlContext.class);
    private static final ThreadLocal<OutsideSqlContext> _threadLocal = new ThreadLocal();
    protected final DBMetaProvider _dbmetaProvider;
    protected final String _outsideSqlPackage;
    protected String _outsideSqlPath;
    protected Object _parameterBean;
    protected Class<?> _resultType;
    protected CursorHandler _cursorHandler;
    protected String _methodName;
    protected StatementConfig _statementConfig;
    protected String _tableDbName;
    protected boolean _dynamicBinding;
    protected boolean _offsetByCursorForcedly;
    protected boolean _limitByCursorForcedly;
    protected boolean _autoPagingLogging;
    protected boolean removeBlockComment;
    protected boolean removeLineComment;
    protected boolean _formatSql;

    public static OutsideSqlContext getOutsideSqlContextOnThread() {
        return _threadLocal.get();
    }

    public static void setOutsideSqlContextOnThread(OutsideSqlContext outsideSqlContext) {
        if (outsideSqlContext == null) {
            String msg = "The argument[outsideSqlContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(outsideSqlContext);
    }

    public static boolean isExistOutsideSqlContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearOutsideSqlContextOnThread() {
        _threadLocal.set(null);
    }

    public static String generateSpecifiedOutsideSqlUniqueKey(String methodName, String path, Object pmb, OutsideSqlOption option, Class<?> resultType) {
        String pmbKey = pmb != null ? pmb.getClass().getName() : "null";
        String resultKey = resultType != null ? resultType.getName() : "null";
        String tableDbName = option.getTableDbName();
        String generatedUniqueKey = option.generateUniqueKey();
        return tableDbName + ":" + methodName + "():" + path + ":" + pmbKey + ":" + generatedUniqueKey + ":" + resultKey;
    }

    public static void throwOutsideSqlNotFoundException(String path) {
        String msg = "Look! Read the message below." + OutsideSqlContext.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + OutsideSqlContext.getLineSeparator();
        msg = msg + "The outsideSql was not found!" + OutsideSqlContext.getLineSeparator();
        msg = msg + OutsideSqlContext.getLineSeparator();
        msg = msg + "[Advice]" + OutsideSqlContext.getLineSeparator();
        msg = msg + "Please confirm the existence of your target file of outsideSql on your classpath." + OutsideSqlContext.getLineSeparator();
        msg = msg + "And please confirm the file name and the file path STRICTLY!" + OutsideSqlContext.getLineSeparator();
        msg = msg + OutsideSqlContext.getLineSeparator();
        msg = msg + "[Specified OutsideSql Path]" + OutsideSqlContext.getLineSeparator() + path + OutsideSqlContext.getLineSeparator();
        msg = msg + "* * * * * * * * * */" + OutsideSqlContext.getLineSeparator();
        throw new OutsideSqlNotFoundException(msg);
    }

    public OutsideSqlContext(DBMetaProvider dbmetaProvider, String outsideSqlPackage) {
        if (dbmetaProvider == null) {
            String msg = "The argument 'dbmetaProvider' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._dbmetaProvider = dbmetaProvider;
        this._outsideSqlPackage = outsideSqlPackage;
    }

    public String readFilteredOutsideSql(String sqlFileEncoding, String dbmsSuffix) {
        String sql = this.readOutsideSql(sqlFileEncoding, dbmsSuffix);
        sql = this.replaceOutsideSqlBindCharacterOnLineComment(sql);
        return sql;
    }

    protected String replaceOutsideSqlBindCharacterOnLineComment(String sql) {
        String[] lines;
        String bindCharacter = "?";
        if (sql.indexOf("?") < 0) {
            return sql;
        }
        String lineSeparator = "\n";
        if (sql.indexOf("\n") < 0) {
            return sql;
        }
        String lineCommentMark = "--";
        if (sql.indexOf("--") < 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = sql.split("\n")) {
            int lineCommentIndex = line.indexOf("--");
            if (lineCommentIndex < 0) {
                sb.append(line).append("\n");
                continue;
            }
            String lineComment = line.substring(lineCommentIndex);
            if (lineComment.contains("ELSE") || !lineComment.contains("?")) {
                sb.append(line).append("\n");
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("...Replacing bind character on line comment: " + lineComment));
            }
            String filteredLineComment = OutsideSqlContext.replaceString(lineComment, "?", "Q");
            sb.append(line.substring(0, lineCommentIndex)).append(filteredLineComment).append("\n");
        }
        return sb.toString();
    }

    public String readOutsideSql(String sqlFileEncoding, String dbmsSuffix) {
        String sql;
        String standardPath = this._outsideSqlPath;
        String dbmsPath = this.buildDbmsPath(standardPath, dbmsSuffix);
        if (this.isExistResource(dbmsPath)) {
            sql = this.readText(dbmsPath, sqlFileEncoding);
        } else if ("_postgresql".equals(dbmsSuffix) && this.isExistResource("_postgre")) {
            sql = this.readText("_postgre", sqlFileEncoding);
        } else if ("_sqlserver".equals(dbmsSuffix) && this.isExistResource("_mssql")) {
            sql = this.readText("_mssql", sqlFileEncoding);
        } else if (this.isExistResource(standardPath)) {
            sql = this.readText(standardPath, sqlFileEncoding);
        } else {
            OutsideSqlContext.throwOutsideSqlNotFoundException(standardPath);
            return null;
        }
        return this.removeInitialUnicodeBomIfNeeds(sqlFileEncoding, sql);
    }

    protected String buildDbmsPath(String standardPath, String dbmsSuffix) {
        String dbmsPath;
        int lastIndexOfDot = standardPath.lastIndexOf(".");
        if (lastIndexOfDot >= 0 && !standardPath.substring(lastIndexOfDot).contains("/")) {
            String base = standardPath.substring(0, lastIndexOfDot);
            dbmsPath = base + dbmsSuffix + standardPath.substring(lastIndexOfDot);
        } else {
            dbmsPath = standardPath + dbmsSuffix;
        }
        return dbmsPath;
    }

    protected String removeInitialUnicodeBomIfNeeds(String sqlFileEncoding, String sql) {
        if ("UTF-8".equalsIgnoreCase(sqlFileEncoding) && sql.length() > 0 && sql.charAt(0) == '\ufeff') {
            sql = sql.substring(1);
        }
        return sql;
    }

    public void setupBehaviorQueryPathIfNeeds() {
        if (!this.isBehaviorQueryPathEnabled()) {
            return;
        }
        if (this._outsideSqlPath.contains(":")) {
            String subDirectoryValue = this._outsideSqlPath.substring(0, this._outsideSqlPath.lastIndexOf(":"));
            String subDirectoryPath = OutsideSqlContext.replaceString(subDirectoryValue, ":", "/");
            String behaviorQueryPath = this._outsideSqlPath.substring(this._outsideSqlPath.lastIndexOf(":") + ":".length());
            String behaviorClassPath = OutsideSqlContext.replaceString(this.buildBehaviorSqlPackageName(), ".", "/");
            String behaviorPackagePath = behaviorClassPath.substring(0, behaviorClassPath.lastIndexOf("/"));
            String behaviorClassName = behaviorClassPath.substring(behaviorClassPath.lastIndexOf("/") + "/".length());
            this._outsideSqlPath = behaviorPackagePath + "/" + subDirectoryPath + "/" + behaviorClassName + "_" + behaviorQueryPath + ".sql";
        } else {
            this._outsideSqlPath = OutsideSqlContext.replaceString(this.buildBehaviorSqlPackageName(), ".", "/") + "_" + this._outsideSqlPath + ".sql";
        }
    }

    protected String buildBehaviorSqlPackageName() {
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(this._tableDbName);
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        String outsideSqlPackage = this._outsideSqlPackage;
        if (outsideSqlPackage != null && outsideSqlPackage.trim().length() > 0) {
            String behaviorClassName = behaviorTypeName.substring(behaviorTypeName.lastIndexOf(".") + ".".length());
            String tmp = behaviorTypeName.substring(0, behaviorTypeName.lastIndexOf("."));
            String exbhvName = tmp.contains(".") ? tmp.substring(tmp.lastIndexOf(".") + ".".length()) : tmp;
            return outsideSqlPackage + "." + exbhvName + "." + behaviorClassName;
        }
        return behaviorTypeName;
    }

    protected boolean isBehaviorQueryPathEnabled() {
        if (this.isProcedure()) {
            return false;
        }
        return this._outsideSqlPath != null && !this._outsideSqlPath.contains("/") && !this._outsideSqlPath.contains(".") && this._tableDbName != null;
    }

    public boolean isSpecifiedOutsideSql() {
        return this._outsideSqlPath != null;
    }

    public boolean isProcedure() {
        return this._methodName != null && this._methodName.startsWith("call");
    }

    protected boolean isExistResource(String path) {
        return DfResourceUtil.isExist(path);
    }

    protected String readText(String path, String sqlFileEncoding) {
        InputStream ins = DfResourceUtil.getResourceStream(path);
        Reader reader = this.createInputStreamReader(ins, sqlFileEncoding);
        return this.readText(reader);
    }

    protected Reader createInputStreamReader(InputStream ins, String encoding) {
        try {
            return new InputStreamReader(ins, encoding);
        }
        catch (IOException e) {
            String msg = "Failed to create the reader of the input stream:";
            msg = msg + " ins=" + ins + " encoding=" + encoding;
            throw new IllegalStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readText(Reader reader) {
        BufferedReader bfreader = new BufferedReader(reader);
        StringBuilder out = new StringBuilder(100);
        try {
            try {
                int n;
                char[] buf = new char[8192];
                while ((n = bfreader.read(buf)) >= 0) {
                    out.append(buf, 0, n);
                }
            }
            finally {
                bfreader.close();
            }
        }
        catch (IOException e) {
            String msg = "Failed to read the input stream:";
            msg = msg + " bfreader=" + bfreader + " reader=" + reader;
            throw new IllegalStateException(msg, e);
        }
        return out.toString();
    }

    protected static String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected static String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    public String getOutsideSqlPath() {
        return this._outsideSqlPath;
    }

    public void setOutsideSqlPath(String outsideSqlPath) {
        this._outsideSqlPath = outsideSqlPath;
    }

    public Object getParameterBean() {
        return this._parameterBean;
    }

    public void setParameterBean(Object parameterBean) {
        this._parameterBean = parameterBean;
    }

    public Class<?> getResultType() {
        return this._resultType;
    }

    public void setResultType(Class<?> resultType) {
        this._resultType = resultType;
    }

    public CursorHandler getCursorHandler() {
        return this._cursorHandler;
    }

    public void setCursorHandler(CursorHandler handler) {
        this._cursorHandler = handler;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public void setMethodName(String methodName) {
        this._methodName = methodName;
    }

    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void setStatementConfig(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public boolean isDynamicBinding() {
        return this._dynamicBinding;
    }

    public void setDynamicBinding(boolean dynamicBinding) {
        this._dynamicBinding = dynamicBinding;
    }

    public boolean isOffsetByCursorForcedly() {
        return this._offsetByCursorForcedly;
    }

    public void setOffsetByCursorForcedly(boolean offsetByCursorForcedly) {
        this._offsetByCursorForcedly = offsetByCursorForcedly;
    }

    public boolean isLimitByCursorForcedly() {
        return this._limitByCursorForcedly;
    }

    public void setLimitByCursorForcedly(boolean limitByCursorForcedly) {
        this._limitByCursorForcedly = limitByCursorForcedly;
    }

    public boolean isAutoPagingLogging() {
        return this._autoPagingLogging;
    }

    public void setAutoPagingLogging(boolean autoPagingLogging) {
        this._autoPagingLogging = autoPagingLogging;
    }

    public boolean isRemoveBlockComment() {
        return this.removeBlockComment;
    }

    public void setRemoveBlockComment(boolean removeBlockComment) {
        this.removeBlockComment = removeBlockComment;
    }

    public boolean isRemoveLineComment() {
        return this.removeLineComment;
    }

    public void setRemoveLineComment(boolean removeLineComment) {
        this.removeLineComment = removeLineComment;
    }

    public boolean isFormatSql() {
        return this._formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this._formatSql = formatSql;
    }
}

