/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.execution;

import java.util.List;
import javax.sql.DataSource;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.bhv.core.execution.AbstractOutsideSqlExecution;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.util.Srl;

public class OutsideSqlSelectExecution
extends AbstractOutsideSqlExecution {
    protected TnResultSetHandler _resultSetHandler;

    public OutsideSqlSelectExecution(DataSource dataSource, StatementFactory statementFactory, TnResultSetHandler resultSetHandler) {
        super(dataSource, statementFactory);
        this._resultSetHandler = resultSetHandler;
    }

    public Object execute(Object[] args) {
        OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
        if (this.isDynamicBinding(outsideSqlContext)) {
            this.logDynamicBinding();
            return this.executeOutsideSqlAsDynamic(args, outsideSqlContext);
        }
        return this.executeOutsideSqlAsStatic(args, outsideSqlContext);
    }

    protected void logDynamicBinding() {
        if (XLog.isLogEnabled()) {
            XLog.log("...Executing as dynamic binding");
        }
    }

    protected boolean isDynamicBinding(OutsideSqlContext outsideSqlContext) {
        return outsideSqlContext.isDynamicBinding();
    }

    protected Object executeOutsideSqlAsDynamic(Object[] args, OutsideSqlContext outsideSqlContext) {
        Object pmb = args[0];
        String dynamicSql = this.getSql();
        if (pmb != null) {
            dynamicSql = this.resolveDynamicEmbedded(pmb, dynamicSql);
        }
        OutsideSqlSelectExecution dynamicSqlFactory = this.createDynamicSqlFactory();
        dynamicSqlFactory.setArgNames(this.getArgNames());
        dynamicSqlFactory.setArgTypes(this.getArgTypes());
        dynamicSqlFactory.setSql(dynamicSql);
        CommandContext ctx = dynamicSqlFactory.apply(args);
        return this.doExecuteOutsideSql(ctx);
    }

    protected String resolveDynamicEmbedded(Object pmb, String dynamicSql) {
        if (pmb == null) {
            return dynamicSql;
        }
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(pmb.getClass());
        List<String> proppertyNameList = beanDesc.getProppertyNameList();
        for (String proppertyName : proppertyNameList) {
            String outsideSqlPiece;
            DfPropertyDesc propertyDesc = beanDesc.getPropertyDesc(proppertyName);
            Class<?> propertyType = propertyDesc.getPropertyType();
            if (!propertyType.equals(String.class) || (outsideSqlPiece = (String)propertyDesc.getValue(pmb)) == null) continue;
            String embeddedComment = "/*$pmb." + propertyDesc.getPropertyName() + "*/";
            dynamicSql = this.replaceString(dynamicSql, embeddedComment, outsideSqlPiece);
        }
        return dynamicSql;
    }

    protected OutsideSqlSelectExecution createDynamicSqlFactory() {
        return new OutsideSqlSelectExecution(this.getDataSource(), this.getStatementFactory(), this._resultSetHandler);
    }

    protected Object executeOutsideSqlAsStatic(Object[] args, OutsideSqlContext outsideSqlContext) {
        CommandContext ctx = this.apply(args);
        return this.doExecuteOutsideSql(ctx);
    }

    protected Object doExecuteOutsideSql(CommandContext ctx) {
        String realSql = this.filterSql(ctx.getSql());
        TnBasicSelectHandler selectHandler = this.createBasicSelectHandler(realSql, this._resultSetHandler);
        Object[] bindVariables = ctx.getBindVariables();
        Class<?>[] bindVariableTypes = ctx.getBindVariableTypes();
        selectHandler.setExceptionMessageSqlArgs(bindVariables);
        return selectHandler.execute(bindVariables, bindVariableTypes);
    }

    protected TnBasicSelectHandler createBasicSelectHandler(String realSql, TnResultSetHandler rsh) {
        return new TnBasicSelectHandler(this.getDataSource(), realSql, rsh, this.getStatementFactory());
    }

    protected boolean isBlockNullParameter() {
        return true;
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }
}

