/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CountingInputStream;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SecureContentHandler
extends ContentHandlerDecorator {
    private final CountingInputStream stream;
    private long characterCount = 0L;
    private long threshold = 1000000L;
    private long ratio = 100L;

    public SecureContentHandler(ContentHandler handler, CountingInputStream stream) {
        super(handler);
        this.stream = stream;
    }

    public long getOutputThreshold() {
        return this.threshold;
    }

    public void setOutputThreshold(long threshold) {
        this.threshold = threshold;
    }

    public long getMaximumCompressionRatio() {
        return this.ratio;
    }

    public void setMaximumCompressionRatio(long ratio) {
        this.ratio = ratio;
    }

    public void throwIfCauseOf(SAXException e) throws TikaException {
        if (e instanceof SecureSAXException && ((SecureSAXException)e).isCausedBy(this)) {
            throw new TikaException("Zip bomb detected!", e);
        }
    }

    private void advance(int length) throws SAXException {
        this.characterCount += (long)length;
        if (this.characterCount > this.threshold && this.characterCount > this.stream.getByteCount() * this.ratio) {
            throw new SecureSAXException();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.advance(length);
        super.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.advance(length);
        super.ignorableWhitespace(ch, start, length);
    }

    private class SecureSAXException
    extends SAXException {
        public SecureSAXException() {
            super("Suspected zip bomb: " + SecureContentHandler.this.stream.getByteCount() + " input bytes produced " + SecureContentHandler.this.characterCount + " output characters");
        }

        public boolean isCausedBy(SecureContentHandler handler) {
            return SecureContentHandler.this == handler;
        }
    }
}

