<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.file_crawling_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="fileCrawlingConfig" />
	<tiles:put name="headerScript" type="string"></tiles:put>
	<tiles:put name="body" type="string">

      <div id="main">

<!-- Message: BEGIN -->
<div><html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages><html:errors/></div>
<!-- Message: END -->

<!-- List: BEGIN -->
<div class="list-table">
<div>
<s:link href="createpage"><bean:message key="labels.file_crawling_link_create_new"/></s:link>
</div>
<table style="width:500px;margin-top:5px;">
	<thead>
		<tr>
				<th style="text-align: center;width:250px;"><bean:message key="labels.name"/></th>
				<th style="text-align: center;"><bean:message key="labels.available"/></th>
			<th style="text-align: center;width:150px;">&nbsp;</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach var="data" varStatus="s" items="${fileCrawlingConfigItems}">
		<tr class="${s.index % 2 == 0 ? 'row1' : 'row2'}">

								<td>${f:h(data.name)}</td>
								<td style="text-align: center;">
<c:if test="${data.available=='T'}"><bean:message key="labels.enabled"/></c:if>
<c:if test="${data.available=='F'}"><bean:message key="labels.disabled"/></c:if>
								</td>

			<td align="center">


				<s:link href="confirmpage/4/${f:u(data.id)}"><bean:message key="labels.file_crawling_link_details"/></s:link>
				<s:link href="editpage/2/${f:u(data.id)}"><bean:message key="labels.file_crawling_link_edit"/></s:link>
				<s:link href="deletepage/3/${f:u(data.id)}"><bean:message key="labels.file_crawling_link_delete"/></s:link>
     
			</td>
		</tr>
		</c:forEach>
	</tbody>
</table>
<!-- Page Navigation: BEGIN -->
<div>
	<span>
		<c:if test="${fileCrawlingConfigPager.existPrePage}">
		<s:link href="list/${fileCrawlingConfigPager.currentPageNumber - 1}"><bean:message key="labels.file_crawling_link_prev_page"/></s:link>
		</c:if>
	</span>
	<span>
		<c:forEach var="p" varStatus="s" items="${fileCrawlingConfigPager.pageNumberList}">
		<span>
			<c:if test="${p == fileCrawlingConfigPager.currentPageNumber}">
			${p}
			</c:if>
			<c:if test="${p != fileCrawlingConfigPager.currentPageNumber}">
			<s:link href="list/${p}">${p}</s:link>
			</c:if>
		</span>
		</c:forEach>
	</span>
	<span>
		<c:if test="${fileCrawlingConfigPager.existNextPage}">
		<s:link href="list/${fileCrawlingConfigPager.currentPageNumber + 1}"><bean:message key="labels.file_crawling_link_next_page"/></s:link>
		</c:if>
	</span>
</div>
<div>
	<span>
		${fileCrawlingConfigPager.currentPageNumber}/${fileCrawlingConfigPager.allPageCount} (${fileCrawlingConfigPager.allRecordCount})
	</span>
</div>
<!-- Page Navigation: END -->
</div>
<!-- List: END -->

      </div>

	</tiles:put>
</tiles:insert>
