/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.node.AbstractNode;
import org.seasar.dbflute.twowaysql.node.NodeExceptionHandler;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.dbflute.util.DfStringUtil;

public class EmbeddedValueNode
extends AbstractNode {
    protected String _expression;
    protected String _testValue;
    protected String[] _names;
    protected String _specifiedSql;
    protected boolean _blockNullParameter;

    public EmbeddedValueNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        this._expression = expression;
        this._testValue = testValue;
        this._names = DfStringUtil.split(expression, ".");
        this._specifiedSql = specifiedSql;
        this._blockNullParameter = blockNullParameter;
    }

    public void accept(CommandContext ctx) {
        Object value = ctx.getArg(this._names[0]);
        Class<?> clazz = ctx.getArgType(this._names[0]);
        ValueAndType valueAndType = new ValueAndType();
        valueAndType.setTargetValue(value);
        valueAndType.setTargetType(clazz);
        this.setupValueAndType(valueAndType);
        if (this._blockNullParameter && valueAndType.getTargetValue() == null) {
            this.throwBindOrEmbeddedParameterNullValueException(valueAndType);
        }
        if (!this.isInScope()) {
            if (valueAndType.getTargetValue() != null && valueAndType.getTargetValue().toString().indexOf("?") > -1) {
                String msg = "The value of expression for embedded comment should not contain a question mark '?':";
                msg = msg + " value=" + valueAndType.getTargetValue() + " expression=" + this._expression;
                throw new IllegalStateException(msg);
            }
            ctx.addSql(valueAndType.getTargetValue().toString());
        } else if (List.class.isAssignableFrom(valueAndType.getTargetType())) {
            this.embedArray(ctx, ((List)valueAndType.getTargetValue()).toArray());
        } else if (valueAndType.getTargetType().isArray()) {
            this.embedArray(ctx, valueAndType.getTargetValue());
        } else {
            if (valueAndType.getTargetValue() != null && valueAndType.getTargetValue().toString().indexOf("?") > -1) {
                String msg = "The value of expression for embedded comment should not contain a question mark '?':";
                msg = msg + " value=" + valueAndType.getTargetValue() + " expression=" + this._expression;
                throw new IllegalStateException(msg);
            }
            ctx.addSql(valueAndType.getTargetValue().toString());
        }
        if (valueAndType.isValidRearOption()) {
            ctx.addSql(valueAndType.buildRearOptionOnSql());
        }
    }

    protected void setupValueAndType(ValueAndType valueAndType) {
        ValueAndTypeSetupper valueAndTypeSetuper = new ValueAndTypeSetupper(this._expression, this._names, this._specifiedSql, false);
        valueAndTypeSetuper.setupValueAndType(valueAndType);
    }

    protected void throwBindOrEmbeddedParameterNullValueException(ValueAndType valueAndType) {
        NodeExceptionHandler.throwBindOrEmbeddedParameterNullValueException(this._expression, valueAndType.getTargetType(), this._specifiedSql, false);
    }

    protected boolean isInScope() {
        return this._testValue != null && this._testValue.startsWith("(") && this._testValue.endsWith(")");
    }

    protected void embedArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedParameterEmptyListException();
        }
        String quote = null;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            quote = !(currentElement instanceof Number) ? "'" : "";
            break;
        }
        if (quote == null) {
            this.throwBindOrEmbeddedParameterNullOnlyListException();
        }
        boolean existsValidElements = false;
        ctx.addSql("(");
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (!existsValidElements) {
                ctx.addSql(quote + currentElement + quote);
                existsValidElements = true;
                continue;
            }
            ctx.addSql(", " + quote + currentElement + quote);
        }
        ctx.addSql(")");
    }

    protected void throwBindOrEmbeddedParameterEmptyListException() {
        NodeExceptionHandler.throwBindOrEmbeddedParameterEmptyListException(this._expression, this._specifiedSql, false);
    }

    protected void throwBindOrEmbeddedParameterNullOnlyListException() {
        NodeExceptionHandler.throwBindOrEmbeddedParameterNullOnlyListException(this._expression, this._specifiedSql, false);
    }
}

