/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorReadable;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.bhv.batch.TokenFileReflectionFailure;
import org.seasar.dbflute.bhv.batch.TokenFileReflectionOption;
import org.seasar.dbflute.bhv.batch.TokenFileReflectionResult;
import org.seasar.dbflute.bhv.core.CommonColumnAutoSetupper;
import org.seasar.dbflute.bhv.core.command.AbstractEntityCommand;
import org.seasar.dbflute.bhv.core.command.AbstractListEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchInsertEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.DeleteEntityCommand;
import org.seasar.dbflute.bhv.core.command.DeleteNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.InsertEntityCommand;
import org.seasar.dbflute.bhv.core.command.QueryDeleteCBCommand;
import org.seasar.dbflute.bhv.core.command.QueryUpdateEntityCBCommand;
import org.seasar.dbflute.bhv.core.command.UpdateEntityCommand;
import org.seasar.dbflute.bhv.core.command.UpdateNonstrictEntityCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityAlreadyUpdatedException;
import org.seasar.dbflute.exception.EntityDuplicatedException;
import org.seasar.dbflute.helper.mapstring.impl.MapStringBuilderImpl;
import org.seasar.dbflute.helper.token.file.FileTokenizingCallback;
import org.seasar.dbflute.helper.token.file.FileTokenizingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileTokenizingOption;
import org.seasar.dbflute.helper.token.file.FileTokenizingRowResource;
import org.seasar.dbflute.helper.token.file.impl.FileTokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorWritable
extends AbstractBehaviorReadable
implements BehaviorWritable {
    private static final String MAP_STRING_MAP_MARK = "map:";
    private static final String MAP_STRING_START_BRACE = "@{";
    private static final String MAP_STRING_END_BRACE = "@}";
    private static final String MAP_STRING_DELIMITER = "@;";
    private static final String MAP_STRING_EQUAL = "@=";
    protected CommonColumnAutoSetupper _commonColumnAutoSetupper;

    @Override
    public void create(Entity entity) {
        this.doCreate(entity);
    }

    protected abstract void doCreate(Entity var1);

    @Override
    public void modify(Entity entity) {
        this.doModify(entity);
    }

    protected abstract void doModify(Entity var1);

    @Override
    public void modifyNonstrict(Entity entity) {
        this.doModifyNonstrict(entity);
    }

    protected abstract void doModifyNonstrict(Entity var1);

    @Override
    public void createOrModify(Entity entity) {
        this.assertEntityNotNull(entity);
        this.doCreateOrUpdate(entity);
    }

    protected abstract void doCreateOrUpdate(Entity var1);

    @Override
    public void createOrModifyNonstrict(Entity entity) {
        this.assertEntityNotNull(entity);
        this.doCreateOrUpdateNonstrict(entity);
    }

    protected abstract void doCreateOrUpdateNonstrict(Entity var1);

    @Override
    public void remove(Entity entity) {
        this.assertEntityNotNull(entity);
        this.callRemove(entity);
    }

    protected abstract void doRemove(Entity var1);

    protected <ENTITY extends Entity> void helpUpdateInternally(ENTITY entity, InternalUpdateCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
        int updatedCount = callback.callbackDelegateUpdate(entity);
        if (updatedCount == 0) {
            String msg = "The entity was Not Found! it has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (updatedCount > 1) {
            String msg = "The entity was Too Many! it has been duplicated. It should be the only one! But the updatedCount=" + updatedCount;
            msg = msg + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    protected <ENTITY extends Entity> void helpUpdateNonstrictInternally(ENTITY entity, InternalUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int updatedCount = callback.callbackDelegateUpdateNonstrict(entity);
        if (updatedCount == 0) {
            String msg = "The entity was Not Found! it has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (updatedCount > 1) {
            String msg = "The entity was Too Many! it has been duplicated. It should be the only one! But the updatedCount=" + updatedCount;
            msg = msg + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    protected <ENTITY extends Entity, CB_TYPE extends ConditionBean> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateCallback<ENTITY, CB_TYPE> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            RuntimeException exception = null;
            try {
                callback.callbackUpdate(entity);
            }
            catch (EntityAlreadyUpdatedException e) {
                if (e.getRows() == 0) {
                    exception = e;
                }
            }
            catch (EntityAlreadyDeletedException e) {
                exception = e;
            }
            catch (OptimisticLockColumnValueNullException e) {
                exception = e;
            }
            if (exception != null) {
                CB_TYPE cb = callback.callbackNewMyConditionBean();
                cb.acceptPrimaryKeyMapString(this.getDBMeta().extractPrimaryKeyMapString(entity));
                if (callback.callbackSelectCount(cb) == 0) {
                    callback.callbackInsert(entity);
                } else {
                    throw exception;
                }
            }
        }
    }

    protected <ENTITY extends Entity> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            try {
                callback.callbackUpdateNonstrict(entity);
            }
            catch (EntityAlreadyUpdatedException e) {
                callback.callbackInsert(entity);
            }
            catch (EntityAlreadyDeletedException e) {
                callback.callbackInsert(entity);
            }
        }
    }

    protected <ENTITY extends Entity> void helpDeleteInternally(ENTITY entity, InternalDeleteCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
        int deletedCount = callback.callbackDelegateDelete(entity);
        if (deletedCount == 0) {
            String msg = "The entity was Not Found! The entity has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (deletedCount > 1) {
            String msg = "The deleted entity was duplicated. It should be the only one! But the deletedCount=" + deletedCount;
            msg = msg + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictInternally(ENTITY entity, InternalDeleteNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            String msg = "The entity was Not Found! The entity has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (deletedCount > 1) {
            String msg = "The deleted entity was duplicated. It should be the only one! But the deletedCount=" + deletedCount;
            msg = msg + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictIgnoreDeletedInternally(ENTITY entity, InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            return;
        }
        if (deletedCount > 1) {
            String msg = "The deleted entity was duplicated. It should be the only one! But the deletedCount=" + deletedCount;
            msg = msg + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    @Override
    public int[] lumpCreate(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callCreateList(entityList);
    }

    @Override
    public int[] lumpModify(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callModifyList(entityList);
    }

    @Override
    public int[] lumpRemove(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callRemoveList(entityList);
    }

    protected void injectSequenceToPrimaryKeyIfNeeds(Entity entity) {
        DBMeta dbmeta = entity.getDBMeta();
        if (!dbmeta.hasSequence() || dbmeta.hasTwoOrMorePrimaryKeys() || entity.hasPrimaryKeyValue()) {
            return;
        }
        BigDecimal sequenceValue = this.readNextVal();
        String columnDbName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(columnDbName, sequenceValue.toString());
        dbmeta.acceptPrimaryKeyMap(entity, map);
    }

    public TokenFileReflectionExecutor tokenFileReflection() {
        return new TokenFileReflectionExecutor();
    }

    protected int callCreate(Entity entity) {
        if (!this.processBeforeInsert(entity)) {
            return 1;
        }
        return this.doCallCreate(entity);
    }

    protected abstract int doCallCreate(Entity var1);

    protected boolean processBeforeInsert(Entity entity) {
        if (!this.determineExecuteInsert(entity)) {
            return false;
        }
        this.assertEntityNotNull(entity);
        this.frameworkFilterEntityOfInsert(entity);
        this.filterEntityOfInsert(entity);
        this.assertEntityOfInsert(entity);
        return true;
    }

    protected int callModify(Entity entity) {
        if (!this.processBeforeUpdate(entity)) {
            return 1;
        }
        return this.doCallModify(entity);
    }

    protected abstract int doCallModify(Entity var1);

    protected boolean processBeforeUpdate(Entity entity) {
        if (!this.determineExecuteUpdate(entity)) {
            return false;
        }
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfUpdate(entity);
        this.filterEntityOfUpdate(entity);
        this.assertEntityOfUpdate(entity);
        return true;
    }

    protected int callRemove(Entity entity) {
        if (!this.processBeforeDelete(entity)) {
            return 1;
        }
        return this.doCallRemove(entity);
    }

    protected abstract int doCallRemove(Entity var1);

    protected boolean processBeforeDelete(Entity entity) {
        if (!this.determineExecuteDelete(entity)) {
            return false;
        }
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfDelete(entity);
        this.filterEntityOfDelete(entity);
        this.assertEntityOfDelete(entity);
        return true;
    }

    protected boolean determineExecuteInsert(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfInsert(Entity targetEntity) {
        this.injectSequenceToPrimaryKeyIfNeeds(targetEntity);
        this.setupCommonColumnOfInsertIfNeeds(targetEntity);
    }

    protected void setupCommonColumnOfInsertIfNeeds(Entity targetEntity) {
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfInsertIfNeeds(targetEntity);
    }

    private void assertCommonColumnAutoSetupperNotNull() {
        if (this._commonColumnAutoSetupper == null) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "Not found the auto set-upper of common column as behavior's attribute!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "Please confirm the definition of the set-upper at your component configuration of DBFlute." + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Your Behavior's Attributes]" + this.getLineSeparator();
            msg = msg + "  _behaviorCommandInvoker   : " + this._behaviorCommandInvoker + this.getLineSeparator();
            msg = msg + "  _behaviorSelector         : " + this._behaviorSelector + this.getLineSeparator();
            msg = msg + "  _commonColumnAutoSetupper : " + this._commonColumnAutoSetupper + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    protected void filterEntityOfInsert(Entity targetEntity) {
    }

    protected void assertEntityOfInsert(Entity entity) {
    }

    protected boolean determineExecuteUpdate(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfUpdate(Entity targetEntity) {
        this.setupCommonColumnOfUpdateIfNeeds(targetEntity);
    }

    protected void setupCommonColumnOfUpdateIfNeeds(Entity targetEntity) {
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfUpdateIfNeeds(targetEntity);
    }

    protected void filterEntityOfUpdate(Entity targetEntity) {
    }

    protected void assertEntityOfUpdate(Entity entity) {
    }

    protected boolean determineExecuteDelete(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfDelete(Entity targetEntity) {
    }

    protected void filterEntityOfDelete(Entity targetEntity) {
    }

    protected void assertEntityOfDelete(Entity entity) {
    }

    protected int[] callCreateList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeInsertInternally(entityList);
        return this.doCreateList(entityList);
    }

    protected abstract int[] doCreateList(List<Entity> var1);

    protected int[] callModifyList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeUpdateInternally(entityList);
        return this.doModifyList(entityList);
    }

    protected abstract int[] doModifyList(List<Entity> var1);

    protected int[] callRemoveList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeDeleteInternally(entityList);
        return this.doRemoveList(entityList);
    }

    protected abstract int[] doRemoveList(List<Entity> var1);

    protected void assertEntityHasVersionNoValue(Entity entity) {
        if (!this.getDBMeta().hasVersionNo()) {
            return;
        }
        if (this.hasVersionNoValue(entity)) {
            return;
        }
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The value of 'version no' on the entity was Not Found!" + this.getLineSeparator() + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm the existence of the value of 'version no' on the entity." + this.getLineSeparator();
        msg = msg + "You called the method in which the check for optimistic lock is indispensable. " + this.getLineSeparator();
        msg = msg + "So 'version no' is required on the entity. " + this.getLineSeparator();
        msg = msg + "In addition, please confirm the necessity of optimistic lock. It might possibly be unnecessary." + this.getLineSeparator() + this.getLineSeparator();
        msg = msg + "[Entity]" + this.getLineSeparator();
        msg = msg + "entity to string = " + entity + this.getLineSeparator();
        msg = msg + "entity to map    = " + entity.getDBMeta().convertToColumnValueMap(entity) + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
        throw new OptimisticLockColumnValueNullException(msg);
    }

    protected void assertEntityHasUpdateDateValue(Entity entity) {
        if (!this.getDBMeta().hasUpdateDate()) {
            return;
        }
        if (this.hasUpdateDateValue(entity)) {
            return;
        }
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The value of 'update date' on the entity was Not Found!" + this.getLineSeparator() + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm the existence of the value of 'update date' on the entity." + this.getLineSeparator();
        msg = msg + "You called the method in which the check for optimistic lock is indispensable. " + this.getLineSeparator();
        msg = msg + "So 'update date' is required on the entity. " + this.getLineSeparator();
        msg = msg + "In addition, please confirm the necessity of optimistic lock. It might possibly be unnecessary." + this.getLineSeparator() + this.getLineSeparator();
        msg = msg + "[Entity]" + this.getLineSeparator();
        msg = msg + "entity to string = " + entity + this.getLineSeparator();
        msg = msg + "entity to map    = " + entity.getDBMeta().convertToColumnValueMap(entity) + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
        throw new OptimisticLockColumnValueNullException(msg);
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeInsertInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeInsert(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeUpdateInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeUpdate(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeDeleteInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeDelete(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected InsertEntityCommand createInsertEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createInsertEntityCommand");
        return this.xsetupEntityCommand(new InsertEntityCommand(), entity);
    }

    protected UpdateEntityCommand createUpdateEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createUpdateEntityCommand");
        return this.xsetupEntityCommand(new UpdateEntityCommand(), entity);
    }

    protected UpdateNonstrictEntityCommand createUpdateNonstrictEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createUpdateNonstrictEntityCommand");
        return this.xsetupEntityCommand(new UpdateNonstrictEntityCommand(), entity);
    }

    protected DeleteEntityCommand createDeleteEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createDeleteEntityCommand");
        return this.xsetupEntityCommand(new DeleteEntityCommand(), entity);
    }

    protected DeleteNonstrictEntityCommand createDeleteNonstrictEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createDeleteNonstrictEntityCommand");
        return this.xsetupEntityCommand(new DeleteNonstrictEntityCommand(), entity);
    }

    private <COMMAND extends AbstractEntityCommand> COMMAND xsetupEntityCommand(COMMAND command, Entity entity) {
        command.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setEntityType(entity.getClass());
        command.setEntity(entity);
        return command;
    }

    protected BatchInsertEntityCommand createBatchInsertEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchInsertEntityCommand");
        return this.xsetupListEntityCommand(new BatchInsertEntityCommand(), entityList);
    }

    protected BatchUpdateEntityCommand createBatchUpdateEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchUpdateEntityCommand");
        return this.xsetupListEntityCommand(new BatchUpdateEntityCommand(), entityList);
    }

    protected BatchUpdateNonstrictEntityCommand createBatchUpdateNonstrictEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchUpdateNonstrictEntityCommand");
        return this.xsetupListEntityCommand(new BatchUpdateNonstrictEntityCommand(), entityList);
    }

    protected BatchDeleteEntityCommand createBatchDeleteEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchDeleteEntityCommand");
        return this.xsetupListEntityCommand(new BatchDeleteEntityCommand(), entityList);
    }

    protected BatchDeleteNonstrictEntityCommand createBatchDeleteNonstrictEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchDeleteNonstrictEntityCommand");
        return this.xsetupListEntityCommand(new BatchDeleteNonstrictEntityCommand(), entityList);
    }

    private <COMMAND extends AbstractListEntityCommand> COMMAND xsetupListEntityCommand(COMMAND command, List<? extends Entity> entityList) {
        if (entityList.isEmpty()) {
            String msg = "The argument 'entityList' should not be empty: " + entityList;
            throw new IllegalStateException(msg);
        }
        command.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setEntityType(entityList.get(0).getClass());
        command.setEntityList(entityList);
        return command;
    }

    protected QueryDeleteCBCommand createQueryDeleteCBCommand(ConditionBean cb) {
        this.assertBehaviorCommandInvoker("createQueryDeleteCBCommand");
        QueryDeleteCBCommand cmd = new QueryDeleteCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setConditionBeanType(cb.getClass());
        cmd.setConditionBean(cb);
        return cmd;
    }

    protected QueryUpdateEntityCBCommand createQueryUpdateEntityCBCommand(Entity entity, ConditionBean cb) {
        this.assertBehaviorCommandInvoker("createQueryUpdateEntityCBCommand");
        QueryUpdateEntityCBCommand cmd = new QueryUpdateEntityCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setConditionBeanType(cb.getClass());
        cmd.setConditionBean(cb);
        cmd.setEntityType(entity.getClass());
        cmd.setEntity(entity);
        return cmd;
    }

    protected CommonColumnAutoSetupper getCommonColumnAutoSetupper() {
        return this._commonColumnAutoSetupper;
    }

    public void setCommonColumnAutoSetupper(CommonColumnAutoSetupper commonColumnAutoSetupper) {
        this._commonColumnAutoSetupper = commonColumnAutoSetupper;
    }

    public static class OptimisticLockColumnValueNullException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public OptimisticLockColumnValueNullException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TokenFileReflectionExecutor {
        public TokenFileReflectionResult reflectTokenFile(String filename, TokenFileReflectionOption tokenFileReflectionOption) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("filename", filename);
            this.assertFileTokenReflectionOption(tokenFileReflectionOption);
            TokenFileReflectionResult result = this.buildTokenFileReflectionResult();
            FileTokenizingCallback fileTokenizingCallback = this.buildFileTokenReflectionFileTokenizingCallback(tokenFileReflectionOption, result);
            FileTokenizingOption fileTokenizingOption = this.buildFileTokenReflectionFileTokenizingOption(tokenFileReflectionOption);
            FileTokenImpl fileToken = new FileTokenImpl();
            fileToken.tokenize(filename, fileTokenizingCallback, fileTokenizingOption);
            return result;
        }

        public TokenFileReflectionResult reflectTokenFile(InputStream inputStream, TokenFileReflectionOption tokenFileReflectionOption) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertObjectNotNull("inputStream", inputStream);
            this.assertFileTokenReflectionOption(tokenFileReflectionOption);
            TokenFileReflectionResult result = this.buildTokenFileReflectionResult();
            FileTokenizingCallback fileTokenizingCallback = this.buildFileTokenReflectionFileTokenizingCallback(tokenFileReflectionOption, result);
            FileTokenizingOption fileTokenizingOption = this.buildFileTokenReflectionFileTokenizingOption(tokenFileReflectionOption);
            FileTokenImpl fileToken = new FileTokenImpl();
            fileToken.tokenize(inputStream, fileTokenizingCallback, fileTokenizingOption);
            return result;
        }

        protected void assertFileTokenReflectionOption(TokenFileReflectionOption tokenFileReflectionOption) {
            AbstractBehaviorWritable.this.assertObjectNotNull("tokenFileReflectionOption", tokenFileReflectionOption);
            String encoding = tokenFileReflectionOption.getEncoding();
            String delimiter = tokenFileReflectionOption.getDelimiter();
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            AbstractBehaviorWritable.this.assertObjectNotNull("delimiter", delimiter);
        }

        protected TokenFileReflectionResult buildTokenFileReflectionResult() {
            TokenFileReflectionResult result = new TokenFileReflectionResult();
            ArrayList<TokenFileReflectionFailure> failureList = new ArrayList<TokenFileReflectionFailure>();
            result.setFailureList(failureList);
            return result;
        }

        protected FileTokenizingCallback buildFileTokenReflectionFileTokenizingCallback(TokenFileReflectionOption tokenFileReflectionOption, final TokenFileReflectionResult result) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertObjectNotNull("tokenFileReflectionOption", tokenFileReflectionOption);
            String encoding = tokenFileReflectionOption.getEncoding();
            String delimiter = tokenFileReflectionOption.getDelimiter();
            final boolean interruptIfError = tokenFileReflectionOption.isInterruptIfError();
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            AbstractBehaviorWritable.this.assertObjectNotNull("delimiter", delimiter);
            final List<TokenFileReflectionFailure> failureList = result.getFailureList();
            AbstractBehaviorWritable.this.assertObjectNotNull("failureList", failureList);
            FileTokenizingCallback fileTokenizingCallback = new FileTokenizingCallback(){

                public void handleRowResource(FileTokenizingRowResource fileTokenizingRowResource) {
                    FileTokenizingHeaderInfo fileTokenizingHeaderInfo = fileTokenizingRowResource.getFileTokenizingHeaderInfo();
                    List<String> columnNameList = fileTokenizingHeaderInfo.getColumnNameList();
                    List<String> valueList = fileTokenizingRowResource.getValueList();
                    if (result.getColumnNameList() == null) {
                        result.setColumnNameList(columnNameList);
                    }
                    Entity entity = null;
                    try {
                        entity = TokenFileReflectionExecutor.this.createEntityByStringValueList(columnNameList, valueList);
                        AbstractBehaviorWritable.this.doCreateOrUpdateNonstrict(entity);
                        result.incrementSuccessCount();
                    }
                    catch (RuntimeException e) {
                        if (interruptIfError) {
                            throw e;
                        }
                        TokenFileReflectionFailure failure = new TokenFileReflectionFailure();
                        failure.setColumnNameList(columnNameList);
                        failure.setValueList(valueList);
                        failure.setRowString(fileTokenizingRowResource.getRowString());
                        failure.setRowNumber(fileTokenizingRowResource.getRowNumber());
                        failure.setLineNumber(fileTokenizingRowResource.getLineNumber());
                        if (entity != null) {
                            failure.setEntity(entity);
                        }
                        failure.setException(e);
                        failureList.add(failure);
                    }
                }
            };
            return fileTokenizingCallback;
        }

        protected Entity createEntityByStringValueList(List<String> columnNameList, List<String> valueList) {
            MapStringBuilderImpl builder = new MapStringBuilderImpl();
            builder.setMsMapMark(AbstractBehaviorWritable.MAP_STRING_MAP_MARK);
            builder.setMsStartBrace(AbstractBehaviorWritable.MAP_STRING_START_BRACE);
            builder.setMsEndBrace(AbstractBehaviorWritable.MAP_STRING_END_BRACE);
            builder.setMsDelimiter(AbstractBehaviorWritable.MAP_STRING_DELIMITER);
            builder.setMsEqual(AbstractBehaviorWritable.MAP_STRING_EQUAL);
            builder.setColumnNameList(columnNameList);
            String mapString = builder.buildFromList(valueList);
            Entity entity = AbstractBehaviorWritable.this.getDBMeta().newEntity();
            AbstractBehaviorWritable.this.getDBMeta().acceptColumnValueMapString(entity, mapString);
            return entity;
        }

        protected FileTokenizingOption buildFileTokenReflectionFileTokenizingOption(TokenFileReflectionOption tokenFileReflectionOption) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertObjectNotNull("tokenFileReflectionOption", tokenFileReflectionOption);
            String encoding = tokenFileReflectionOption.getEncoding();
            String delimiter = tokenFileReflectionOption.getDelimiter();
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            AbstractBehaviorWritable.this.assertObjectNotNull("delimiter", delimiter);
            FileTokenizingOption fileTokenizingOption = new FileTokenizingOption();
            fileTokenizingOption.setEncoding(encoding);
            fileTokenizingOption.setDelimiter(delimiter);
            if (tokenFileReflectionOption.isHandleEmptyAsNull()) {
                fileTokenizingOption.handleEmptyAsNull();
            }
            return fileTokenizingOption;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteCallback<ENTITY extends Entity> {
        public int callbackDelegateDelete(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalInsertOrUpdateNonstrictCallback<ENTITY extends Entity> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdateNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalInsertOrUpdateCallback<ENTITY extends Entity, CB_TYPE extends ConditionBean> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdate(ENTITY var1);

        public CB_TYPE callbackNewMyConditionBean();

        public int callbackSelectCount(CB_TYPE var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalUpdateNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdateNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalUpdateCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdate(ENTITY var1);
    }
}

