/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.ReturningRowsBatchHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public class BasicReturningRowsBatchHandler
extends BasicHandler
implements ReturningRowsBatchHandler {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int batchSize = -1;

    public BasicReturningRowsBatchHandler() {
    }

    public BasicReturningRowsBatchHandler(DataSource dataSource, String sql) {
        this(dataSource, sql, -1);
    }

    public BasicReturningRowsBatchHandler(DataSource dataSource, String sql, int batchSize) {
        this(dataSource, sql, batchSize, BasicStatementFactory.INSTANCE);
    }

    public BasicReturningRowsBatchHandler(DataSource dataSource, String sql, int batchSize, StatementFactory statementFactory) {
        this.setDataSource(dataSource);
        this.setSql(sql);
        this.setBatchSize(batchSize);
        this.setStatementFactory(statementFactory);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int[] execute(List list) throws SQLRuntimeException {
        if (list.size() == 0) {
            return EMPTY_ARRAY;
        }
        Object[] args = (Object[])list.get(0);
        return this.execute(list, this.getArgTypes(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] execute(List list, Class[] argTypes) throws SQLRuntimeException {
        Connection connection = this.getConnection();
        try {
            int[] nArray = this.execute(connection, list, argTypes);
            return nArray;
        }
        finally {
            ConnectionUtil.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] execute(Connection connection, List list, Class[] argTypes) {
        int size;
        int n = size = this.batchSize > 0 ? Math.min(this.batchSize, list.size()) : list.size();
        if (size == 0) {
            return EMPTY_ARRAY;
        }
        PreparedStatement ps = this.prepareStatement(connection);
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object[] args = (Object[])list.get(i);
                this.logSql(args, argTypes);
                this.bindArgs(ps, args, argTypes);
                PreparedStatementUtil.addBatch((PreparedStatement)ps);
            }
            int[] nArray = PreparedStatementUtil.executeBatch((PreparedStatement)ps);
            return nArray;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }
}

